/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;

public class DeleteMoInstanceAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$DeleteMoInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$DeleteMoInstanceAction = DeleteMoInstanceAction.class$("se.ericsson.crbs.omf.aue.step1.actions.DeleteMoInstanceAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$DeleteMoInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$DeleteMoInstanceAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String ldnToDelete = this.getAndCheckParamMapString("ldn", this.paramMap, "The ldn is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.deleteMoInstance(tableHandler, ldnToDelete);
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Failed to run action: " + THIS_CLASS.getName(), tde);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void deleteMoInstance(TableHandler tableHandler, String ldnToDelete) throws CrbsAueException, TableDataException {
        String froTypeName = this.getFroTypeFromLdn(ldnToDelete);
        TableData tableData = null;
        try {
            tableData = tableHandler.getTableData(froTypeName);
        }
        catch (TableDataException e) {
            logger.traceDebug(THIS_CLASS, "Could not delete Mo instance " + AueUtil.doubleQuote(ldnToDelete) + " due to no data for Mo type.");
        }
        if (tableData != null && tableData.isNotEmpty()) {
            Object[] columnDatas = tableData.getAttributeValues("ldn");
            int rowToDelete = -1;
            for (int i = 0; i < columnDatas.length; ++i) {
                if (!ldnToDelete.equals(columnDatas[i].toString())) continue;
                rowToDelete = i;
                this.findChildrenToDelete(tableHandler, ldnToDelete);
                break;
            }
            if (rowToDelete > -1) {
                tableData.deleteRowData(rowToDelete);
                logger.traceGeneral(THIS_CLASS, "Mo instance, " + AueUtil.doubleQuote(ldnToDelete) + ", is removed");
            } else {
                String errorMsg = "Could not find Mo instance " + AueUtil.doubleQuote(ldnToDelete) + ", for deletion!";
                logger.traceDebug(THIS_CLASS, errorMsg);
                throw new CrbsAueException(errorMsg);
            }
        }
    }

    private void findChildrenToDelete(TableHandler tableHandler, String parentLdn) throws CrbsAueException {
        FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDatas = froVersionsTable.getDatas();
        for (int i = 0; i < froVersionsDatas.length; ++i) {
            String currentFroTypeName = froVersionsDatas[i].froTypeName;
            boolean tableUpdatedFromStart = false;
            try {
                TableData currentTableData = tableHandler.getTableData(currentFroTypeName);
                tableUpdatedFromStart = currentTableData.isTableDataUpdated();
                this.deleteChild(parentLdn, currentTableData, tableHandler);
                this.updateReferencingAttributes(tableHandler, currentFroTypeName, parentLdn, currentTableData);
                tableHandler.checkAndDropIfNotUpdated(tableUpdatedFromStart, currentTableData);
                continue;
            }
            catch (Exception e) {
                String errorMsg = "Could not delete " + AueUtil.doubleQuote(currentFroTypeName);
                logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
                throw new CrbsAueException(errorMsg, e);
            }
        }
    }

    private void deleteChild(String parentLdn, TableData tableData, TableHandler tableHandler) throws CrbsAueException, TableDataException {
        try {
            Object[] columnDatas = tableData.getAttributeValues("ldn");
            for (int i = 0; i < columnDatas.length; ++i) {
                String ldn = columnDatas[i].toString();
                if (!parentLdn.equals(this.getParentLdn(ldn))) continue;
                tableData.clearAllData();
                this.findChildrenToDelete(tableHandler, ldn);
            }
        }
        catch (CrbsAueException e) {
            if (e.getMessage().startsWith("The LDN attribute is not present for: ")) {
                logger.traceDebug(THIS_CLASS, "deleteChild got no children to delete for type " + tableData.getFroTypeName());
            }
            throw new CrbsAueException(e.getMessage());
        }
    }

    private boolean updateReferencingAttributes(TableHandler tableHandler, String froTypeName, String ldn, TableData currentTableData) throws ParseException, TableDataException {
        boolean updated = false;
        String[] attributeNames = currentTableData.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String momType = currentTableData.getMomType(attributeNames[i]);
            Object[] attributeValues = currentTableData.getAttributeValues(attributeNames[i]);
            if (momType.equalsIgnoreCase("moref")) {
                updated = this.updateMoRef(tableHandler, froTypeName, ldn, attributeNames[i], attributeValues);
                continue;
            }
            if (momType.equalsIgnoreCase("struct")) {
                updated = this.updateStruct(tableHandler, froTypeName, ldn, attributeNames[i], attributeValues);
                continue;
            }
            if (!momType.equalsIgnoreCase("array")) continue;
            updated = this.updateArray(tableHandler, froTypeName, ldn, attributeNames[i], attributeValues);
        }
        if (!updated) {
            logger.traceGeneral(THIS_CLASS, "No referencing attributes (MORef, struct or array) contained the MO, " + AueUtil.doubleQuote(ldn) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    private boolean updateMoRef(TableHandler tableHandler, String froTypeName, String ldn, String attributeName, Object[] moRefColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < moRefColumnDatas.length; ++i) {
            String moRefXmlString = (String)moRefColumnDatas[i];
            FroMoRef froMoRef = new FroMoRef(tableHandler);
            froMoRef.parse(moRefXmlString);
            updated = this.updateXmlTags(froMoRef.getXmlTags(), attributeName, froTypeName, ldn);
            if (!updated) continue;
            TableData tableData = tableHandler.getTableData(froTypeName);
            tableData.setAttributeValue(i, attributeName, froMoRef.toXmlString());
        }
        return updated;
    }

    private boolean updateStruct(TableHandler tableHandler, String froTypeName, String ldn, String attributeName, Object[] structColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < structColumnDatas.length; ++i) {
            String structXmlString = (String)structColumnDatas[i];
            FroStruct froStruct = new FroStruct(tableHandler);
            froStruct.parse(structXmlString);
            updated = this.updateXmlTags(froStruct.getXmlTags(), attributeName, froTypeName, ldn);
            if (!updated) continue;
            TableData tableData = tableHandler.getTableData(froTypeName);
            tableData.setAttributeValue(i, attributeName, froStruct.toXmlString());
        }
        return updated;
    }

    private boolean updateArray(TableHandler tableHandler, String froTypeName, String ldn, String attributeName, Object[] arrayColumnDatas) throws ParseException, TableDataException {
        boolean updated = false;
        for (int i = 0; i < arrayColumnDatas.length; ++i) {
            String arrayXmlString = (String)arrayColumnDatas[i];
            FroArray froArray = new FroArray(tableHandler);
            froArray.parse(arrayXmlString);
            updated = this.updateXmlTags(froArray.getXmlTags(), attributeName, froTypeName, ldn);
            if (!updated) continue;
            TableData tableData = tableHandler.getTableData(froTypeName);
            tableData.setAttributeValue(i, attributeName, froArray.toXmlString());
        }
        return updated;
    }

    private boolean updateXmlTags(XmlTag[] xmlTags, String attributeName, String froTypeName, String ldn) {
        boolean updated = false;
        block7: for (int i = 0; i < xmlTags.length; ++i) {
            int tagType = xmlTags[i].getTagType();
            switch (tagType) {
                case 2: {
                    updated |= this.updateTypeValue(attributeName, froTypeName, ldn, (TypeValue)xmlTags[i]);
                    continue block7;
                }
                case 1: {
                    updated |= this.updateNameTypeValue(attributeName, froTypeName, ldn, (NameTypeValue)xmlTags[i]);
                    continue block7;
                }
                case 3: {
                    updated |= this.updateXmlTags(((FroMoRef)xmlTags[i]).getXmlTags(), attributeName, froTypeName, ldn);
                    continue block7;
                }
                case 4: {
                    updated |= this.updateXmlTags(((FroStruct)xmlTags[i]).getXmlTags(), attributeName, froTypeName, ldn);
                    continue block7;
                }
                case 5: {
                    updated |= this.updateXmlTags(((FroArray)xmlTags[i]).getXmlTags(), attributeName, froTypeName, ldn);
                    continue block7;
                }
            }
        }
        return updated;
    }

    private boolean updateTypeValue(String attributeName, String froTypeName, String ldn, TypeValue typeValue) {
        String value;
        boolean updated = false;
        String type = typeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = typeValue.getValue()) && ldn.equalsIgnoreCase(value)) {
            String resetValue = Integer.toString(-1);
            typeValue.setValue(resetValue);
            typeValue.setType(resetValue);
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(ldn) + ", reset with, " + AueUtil.doubleQuote(resetValue) + ", for " + AueUtil.doubleQuote(attributeName) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    private boolean updateNameTypeValue(String attributeName, String froTypeName, String ldn, NameTypeValue nameTypeValue) {
        String value;
        boolean updated = false;
        String type = nameTypeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = nameTypeValue.getValue()) && ldn.equalsIgnoreCase(value)) {
            String resetValue = Integer.toString(-1);
            nameTypeValue.setValue(resetValue);
            nameTypeValue.setType(resetValue);
            nameTypeValue.setName("");
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(ldn) + ", reset with, " + AueUtil.doubleQuote(resetValue) + ", for " + AueUtil.doubleQuote(attributeName) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

