/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.from.Constants;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class SaveRobustSCTPDataAction
implements DataCollectorAction,
Constants {
    public static final String TABLE_NAME = "tmp_table_piu_to_rpuid";
    public static final String ACCESS_HOST_ID = "ipAccessHostGpbId";
    public static final String GPU_ID = "generalProcessorUnitId";
    public static final String PIU_ID = "resourceId";
    public static final String RP_LABEL = "reliableProgramLabel";
    public static final String RPU_ID = "rpuId";
    public static final String ACTIVE_SLOT = "admActiveSlot";
    public static final String PASSIVE_SLOT = "admPassiveSlot";
    public static final String NORMALISATION = "normalisation";
    public static final String REPLICATION = "replication";
    public static final String SWITCH_OVER = "switchOver";
    public static final Integer NORMALISATION_AUTOMATIC = new Integer(2);
    public static final Integer REPLICATION_ALWAYS = new Integer(1);
    public static final Integer SWITCH_OVER_AT_PIU_RESTART = new Integer(2);
    public static final String EXPECTED_RP_LABEL = "sctp_host";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute("robustSctps", false);
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Sctp");
        if (moIterator != null && this.needsUpgrade(moIterator)) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                ManagedObject managedObject2 = this.findRelatedPIU(managedObject);
                ManagedObject managedObject3 = this.findRelatedRPU(managedObject2.getParent(), managedObject, collectorContext, coordinator);
                int n = (Integer)this.getAttribute(managedObject2, PIU_ID);
                long l = (Long)this.getAttribute(managedObject3, RPU_ID);
                collectorContext.getStringDatabase().getTable(TABLE_NAME).writeRow(n, "" + l, coordinator);
                this.collectData(managedObject, managedObject3, sequenceAttribute);
            }
        }
        collectorContext.getDataWriter().writeData((Attribute)sequenceAttribute, collectorContext, coordinator);
    }

    private boolean needsUpgrade(MoIterator moIterator) throws AueException {
        boolean bl = false;
        ManagedObject managedObject = null;
        try {
            managedObject = moIterator.nextMo();
            managedObject.getAttribute(RPU_ID, null);
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            bl = true;
            moIterator.reset();
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to read rpuId from (" + managedObject.getLocalDistinguishedName() + ")", (Throwable)moAccessException);
        }
        return bl;
    }

    private ManagedObject findRelatedPIU(ManagedObject managedObject) throws AueException {
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute(managedObject, ACCESS_HOST_ID);
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute(managedObject2, GPU_ID);
        ManagedObject managedObject4 = managedObject3.getParent();
        if ("Cbu".equals(managedObject4.getType())) {
            managedObject4 = managedObject4.getParent();
        }
        return managedObject4;
    }

    private ManagedObject findRelatedRPU(ManagedObject managedObject, ManagedObject managedObject2, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("ReliableProgramUniter");
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!this.isMatchingRPU(managedObject3, managedObject, collectorContext)) continue;
            return managedObject3;
        }
        return this.createMatchingRPU(managedObject, managedObject2, collectorContext, coordinator);
    }

    private ManagedObject createMatchingRPU(ManagedObject managedObject, ManagedObject managedObject2, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        ManagedObject managedObject3 = collectorContext.getMoAccessor().lookupType("SwManagement").nextMo();
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("ReliableProgramUniter");
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement(RP_LABEL, (Object)EXPECTED_RP_LABEL);
        attrListImpl.addElement(ACTIVE_SLOT, (Object)managedObject);
        attrListImpl.addElement(NORMALISATION, (Object)NORMALISATION_AUTOMATIC);
        attrListImpl.addElement(REPLICATION, (Object)REPLICATION_ALWAYS);
        attrListImpl.addElement(SWITCH_OVER, (Object)SWITCH_OVER_AT_PIU_RESTART);
        ManagedObject managedObject4 = null;
        try {
            managedObject4 = moFactory.createMo(managedObject3, (AttrList)attrListImpl, "sctp-aue_" + managedObject2.getNamingAttributeValue(), null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to create ReliableProgramUniter", (Throwable)moAccessException);
        }
        return managedObject4;
    }

    private boolean isMatchingRPU(ManagedObject managedObject, ManagedObject managedObject2, CollectorContext collectorContext) throws AueException {
        boolean bl = false;
        if (EXPECTED_RP_LABEL.equals(this.getAttribute(managedObject, RP_LABEL)) && this.getAttribute(managedObject, ACTIVE_SLOT) == managedObject2) {
            ManagedObject managedObject3 = (ManagedObject)this.getAttribute(managedObject, PASSIVE_SLOT);
            if (managedObject3 == null) {
                bl = true;
            } else {
                collectorContext.getLogger().info(this.getClass(), "RPU (" + managedObject.getLocalDistinguishedName() + ") is badly configured : " + PASSIVE_SLOT + " = (" + managedObject3.getLocalDistinguishedName() + "), should be NULL");
            }
        }
        return bl;
    }

    private Object getAttribute(ManagedObject managedObject, String string) throws AueException {
        Object object = null;
        try {
            object = managedObject.getAttribute(string, null);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to read (" + managedObject.getLocalDistinguishedName() + ")#" + string, (Throwable)moAccessException);
        }
        return object;
    }

    private void collectData(ManagedObject managedObject, ManagedObject managedObject2, SequenceAttribute sequenceAttribute) {
        StructAttribute structAttribute = new StructAttribute("", false);
        structAttribute.addElement((Attribute)new ReferenceAttribute("Sctp", managedObject.getLocalDistinguishedName(), false));
        structAttribute.addElement((Attribute)new ReferenceAttribute("ReliableProgramUniter", managedObject2.getLocalDistinguishedName(), false));
        sequenceAttribute.addElement((Attribute)structAttribute);
    }
}

