/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.example.config;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.ericsson.cello.emas.example.config.ConfigFileExecutorView;
import se.ericsson.cello.emas.example.config.ConfigParametersDialogController;
import se.ericsson.cello.emas.example.config.ConfigParametersDialogView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.script.Configurator;
import se.ericsson.cello.support.script.ConfiguratorInterface;

public class ConfigFileExecutorController
extends AbstractApplicationController
implements ActionListener,
ConfiguratorInterface {
    private ConfigFileExecutorView view;
    private Configurator configurator = null;
    private ConfigParametersDialogController cpdController = null;
    protected Vector parametersVector = new Vector();
    private JFileChooser fileChooser;
    private int textLength;
    private LookAndFeel initialLookAndFeel = null;
    private boolean lookAndFeelChanged = false;
    private String PROTOCOL = "protocol";
    private String PROTOCOL_HTTP = "http://";
    private String PROTOCOL_HTTPS = "https://";
    private String PROTOCOL_SEPARATOR = "://";
    private DialogListener listener = new DialogListener();

    private void addNameValue(String aCpdName, String aCpdValue) {
        NameValue nameValue = new NameValue(aCpdName, (Object)aCpdValue);
        int returnIndex = this.doesNameValueExist(nameValue);
        if (returnIndex == -1) {
            this.parametersVector.add(nameValue);
            this.view.parameters.addItems(new String[]{aCpdName + "=" + aCpdValue});
        }
        if (this.parametersVector.size() > 0) {
            this.view.deleteButton.setEnabled(true);
        }
    }

    protected void init() {
        this.view = (ConfigFileExecutorView)this.getView();
        this.getApplication().setTitle("CFE_TITLE", null);
        String defaultPath = System.getProperty("user.home");
        if (defaultPath == null) {
            Log.logError((String)"Error retrieving user home directory");
            defaultPath = "";
        }
        this.fileChooser = new JFileChooser(defaultPath);
        this.view.deleteButton.setEnabled(false);
        this.setActionListeners();
        this.setButtonListeners();
        this.setKeyListeners();
    }

    private void setActionListeners() {
        this.view.location.setActionListener((ActionListener)this, "LOCATION_CHANGED");
        this.view.name.setActionListener((ActionListener)this, "DUMMY");
        this.view.browseButton.setActionListener((ActionListener)this, "BROWSE_PRESSED");
        this.view.addButton.setActionListener((ActionListener)this, "ADD_PRESSED");
        this.view.deleteButton.setActionListener((ActionListener)this, "DELETE_PRESSED");
    }

    private void setButtonListeners() {
        this.view.startButton.setActionListener((ActionListener)this, "START_PRESSED");
        this.view.stopButton.setActionListener((ActionListener)this, "STOP_PRESSED");
        this.view.closeButton.setActionListener((ActionListener)this, "CLOSE_PRESSED");
    }

    private void setKeyListeners() {
        ((JList)this.view.parameters.getFieldComponent()).addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    ConfigFileExecutorController.this.copyToClipBoard((JList)((ConfigFileExecutorController)ConfigFileExecutorController.this).view.parameters.getFieldComponent());
                } else if (e.isControlDown() && e.getKeyCode() == 86) {
                    ConfigFileExecutorController.this.copyToList();
                }
            }
        });
    }

    private void copyToList() {
        try {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable tr = cb.getContents(null);
            String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
            StringTokenizer strTok = new StringTokenizer(str);
            while (strTok.hasMoreTokens()) {
                try {
                    String tag = strTok.nextToken();
                    StringTokenizer tmpTok = new StringTokenizer(tag, "=");
                    String nameTag = tmpTok.nextToken();
                    if (!nameTag.startsWith("$") || nameTag.length() <= 1) continue;
                    String value = tmpTok.nextToken();
                    this.addNameValue(nameTag, value);
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyToClipBoard(JList aList) {
        StringBuffer strBuf = new StringBuffer();
        try {
            Object[] objects = aList.getSelectedValues();
            for (int i = 0; i < objects.length; ++i) {
                strBuf.append((String)objects[i]);
                strBuf.append("\n");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(strBuf.toString());
        cb.setContents(ss, null);
    }

    public void actionPerformed(ActionEvent event) {
        block56: {
            String command = event.getActionCommand();
            if (command.equals("LOCATION_CHANGED")) {
                if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
                    this.view.browseButton.setEnabled(true);
                    this.view.name.setValue("");
                    this.view.startButton.setEnabled(false);
                } else {
                    this.view.browseButton.setEnabled(false);
                    String protocol = EmasSystemProperties.getProperty((String)this.PROTOCOL);
                    this.view.name.setValue(protocol + this.PROTOCOL_SEPARATOR);
                    this.view.startButton.setEnabled(false);
                }
            } else if (command.equals("ENTRYFIELD_FILLEDIN")) {
                if (this.view.name.isFilledIn()) {
                    this.view.startButton.setEnabled(true);
                } else {
                    this.view.startButton.setEnabled(false);
                }
            } else if (command.equals("START_PRESSED")) {
                Log.trace((String)"start button pressed");
                this.view.stopButton.setEnabled(true);
                this.view.startButton.setEnabled(false);
                this.view.haltOnErrors.setEnabled(false);
                this.view.verboseLogging.setEnabled(false);
                this.view.addButton.setEnabled(false);
                this.view.name.requestFocus();
                NameValue[] nameValueArray = new NameValue[this.parametersVector.size()];
                for (int i = 0; i < this.parametersVector.size(); ++i) {
                    nameValueArray[i] = (NameValue)this.parametersVector.get(i);
                }
                boolean verboseDeveloperProgress = this.view.verboseLogging.getValue();
                boolean testMode = true;
                if (this.view.haltOnErrors.getValue().booleanValue()) {
                    testMode = false;
                }
                if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
                    String fileName = this.view.name.getValue();
                    if (fileName != null) {
                        this.view.logging.setValue("");
                        this.textLength = 0;
                        this.configurator = new Configurator((ConfiguratorInterface)this, fileName, nameValueArray, verboseDeveloperProgress, 0, testMode);
                        this.configurator.startExecution();
                    }
                } else {
                    try {
                        this.view.logging.setValue("");
                        this.textLength = 0;
                        String url = this.view.name.getValue();
                        if (url != null) {
                            if (this.isUrlStartWithProtocol(url)) {
                                URL newURL = new URL(url);
                                this.configurator = new Configurator((ConfiguratorInterface)this, newURL, nameValueArray, verboseDeveloperProgress, 0, testMode);
                                this.configurator.startExecution();
                            } else {
                                Log.logError((String)"Invalid URL specified");
                                this.configurationNotFound(url);
                            }
                            break block56;
                        }
                        Log.logError((String)"Invalid URL specified");
                        this.configurationNotFound("");
                    }
                    catch (MalformedURLException mue) {
                        Log.logError((String)"Malformed URL", (Throwable)mue);
                    }
                }
            } else if (command.equals("STOP_PRESSED")) {
                Log.trace((String)"stop button pressed");
                if (this.configurator != null) {
                    this.configurator.stopExecution();
                }
                this.view.stopButton.setEnabled(false);
                this.view.haltOnErrors.setEnabled(true);
                this.view.verboseLogging.setEnabled(true);
                this.view.addButton.setEnabled(true);
                if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
                    if ("".equals(this.view.name.getValue())) {
                        this.view.startButton.setEnabled(false);
                    } else {
                        this.view.startButton.setEnabled(true);
                    }
                } else if (this.view.location.getValue().equals("LOCATION_NODE")) {
                    if (this.isUrlStartWithProtocol(this.view.name.getValue()) || "".equals(this.view.name.getValue())) {
                        this.view.startButton.setEnabled(false);
                    } else {
                        this.view.startButton.setEnabled(true);
                    }
                }
            } else if (command.equals("CLOSE_PRESSED")) {
                Log.trace((String)"close button pressed");
                if (this.view.stopButton.isEnabled()) {
                    String cfe_title;
                    Object[] app_title = new Object[]{this.getApplication().getTitle()};
                    String cfe_confirm_msg = this.getString("CFS_CONFIRM_MSG", null);
                    String cfe_confirm_title = this.getString("CFS_CONFIRM_TITLE", null);
                    String cfe_msg = MessageFormat.format(cfe_confirm_msg, app_title);
                    int result = JOptionPane.showConfirmDialog((Component)((Object)this.view), cfe_msg, cfe_title = MessageFormat.format(cfe_confirm_title, app_title), 0, 1, null);
                    if (result == 0) {
                        if (EmasSystemProperties.getProperty((String)"application launched", (String)"false").equalsIgnoreCase("true")) {
                            this.getApplicationManager().exitApplicationEMTApp();
                        } else {
                            this.getApplication().stopApplication();
                        }
                    }
                } else if (EmasSystemProperties.getProperty((String)"application launched", (String)"false").equalsIgnoreCase("true")) {
                    this.getApplicationManager().exitApplicationEMTApp();
                } else {
                    this.getApplication().stopApplication();
                }
            } else if (command.equals("ADD_PRESSED")) {
                Log.trace((String)"add button pressed");
                this.cpdController = (ConfigParametersDialogController)this.startDialog(true, "CONFIGURATION_PARAMETER", null, ConfigParametersDialogView.class, ConfigParametersDialogController.class);
                this.cpdController.addActionListener(this.listener);
            } else if (command.equals("DELETE_PRESSED")) {
                try {
                    JList list = (JList)this.view.parameters.getFieldComponent();
                    Object[] values = list.getSelectedValues();
                    for (int i = 0; i < values.length; ++i) {
                        StringTokenizer strTok = new StringTokenizer((String)values[i], "=");
                        NameValue nv = new NameValue(strTok.nextToken(), (Object)strTok.nextToken());
                        int indexToRemove = this.doesNameValueExist(nv);
                        if (indexToRemove == -1) continue;
                        this.parametersVector.remove(indexToRemove);
                        this.view.parameters.removeItem((String)values[i]);
                    }
                    if (this.parametersVector.size() == 0) {
                        this.view.deleteButton.setEnabled(false);
                    }
                }
                catch (Exception e) {}
            } else if (command.equals("BROWSE_PRESSED")) {
                if (System.getProperty("os.name").equals("SunOS")) {
                    try {
                        this.initialLookAndFeel = UIManager.getLookAndFeel();
                        if (!this.initialLookAndFeel.toString().equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                            SwingUtilities.updateComponentTreeUI(this.fileChooser);
                            this.lookAndFeelChanged = true;
                        }
                    }
                    catch (Exception e) {
                        Log.logError((String)"Not possible to get/change the Look and Feel", (Throwable)e);
                    }
                    this.startFileChooser();
                    if (this.lookAndFeelChanged) {
                        this.lookAndFeelChanged = false;
                        try {
                            UIManager.setLookAndFeel(this.initialLookAndFeel);
                        }
                        catch (Exception e) {
                            Log.logError((String)"Not possible to change the Look and Feel", (Throwable)e);
                        }
                    }
                } else {
                    this.startFileChooser();
                }
            }
        }
    }

    private int doesNameValueExist(NameValue nv) {
        for (int index = 0; index < this.parametersVector.size(); ++index) {
            NameValue nameValue = (NameValue)this.parametersVector.elementAt(index);
            if (!nameValue.name.equals(nv.name)) continue;
            return index;
        }
        return -1;
    }

    private boolean isUrlStartWithProtocol(String url) {
        return url.toLowerCase().startsWith(this.PROTOCOL_HTTP) || url.toLowerCase().startsWith(this.PROTOCOL_HTTPS);
    }

    public void configurationSucceeded(String configFile) {
        String newMsg = "CS : Configuration succeeded: " + configFile + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
        this.view.stopButton.setEnabled(false);
        this.view.haltOnErrors.setEnabled(true);
        this.view.verboseLogging.setEnabled(true);
        this.view.addButton.setEnabled(true);
        if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
            if ("".equals(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        } else if (this.view.location.getValue().equals("LOCATION_NODE")) {
            if (this.isUrlStartWithProtocol(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        }
    }

    public void configurationFailed(String configFile, int lineNr, String errorDescription) {
        String newMsg = "CF : Configuration failed: " + configFile + ", line " + lineNr + "; " + errorDescription + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
        this.view.stopButton.setEnabled(false);
        this.view.haltOnErrors.setEnabled(true);
        this.view.verboseLogging.setEnabled(true);
        this.view.addButton.setEnabled(true);
        if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
            if ("".equals(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        } else if (this.view.location.getValue().equals("LOCATION_NODE")) {
            if (this.isUrlStartWithProtocol(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        }
    }

    public void configurationNotFound(String configFile) {
        String newMsg = "CNF: Configuration not found: " + configFile + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
        this.view.stopButton.setEnabled(false);
        this.view.haltOnErrors.setEnabled(true);
        this.view.verboseLogging.setEnabled(true);
        this.view.addButton.setEnabled(true);
        if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
            if ("".equals(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        } else if (this.view.location.getValue().equals("LOCATION_NODE")) {
            if (this.isUrlStartWithProtocol(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        }
    }

    public void configurationFailed(String logInformation) {
        String newMsg = "LDP: " + logInformation + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
        this.view.stopButton.setEnabled(false);
        this.view.haltOnErrors.setEnabled(true);
        this.view.verboseLogging.setEnabled(true);
        this.view.addButton.setEnabled(true);
        if (this.view.location.getValue().equals("LOCATION_CLIENT")) {
            if ("".equals(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        } else if (this.view.location.getValue().equals("LOCATION_NODE")) {
            if (this.isUrlStartWithProtocol(this.view.name.getValue())) {
                this.view.startButton.setEnabled(false);
            } else {
                this.view.startButton.setEnabled(true);
            }
        }
    }

    public void logDeveloperProgress(String logInformation) {
        String newMsg = "LDP: " + logInformation + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
    }

    public void logOperatorProgress(String logInformation) {
        String newMsg = "LOP: " + logInformation + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
    }

    public void logProgress(int percentage) {
        String newMsg = "LP : " + percentage + "% completed\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
    }

    public void logCFEMessage(String cFEMsg) {
        String newMsg = "CFE: " + cFEMsg + "\n";
        this.textLength += newMsg.length();
        ((JTextArea)this.view.logging.getFieldComponent()).append(newMsg);
        ((JTextArea)this.view.logging.getFieldComponent()).setCaretPosition(this.textLength);
    }

    public void startFileChooser() {
        int status = this.fileChooser.showOpenDialog((Component)((Object)this.view));
        if (status == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.view.name.setValue("");
            this.view.name.setValue(file.toString());
            this.view.startButton.setEnabled(true);
        }
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private class DialogListener
    implements ActionListener {
        private DialogListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("ADD_PRESSED".equals(event.getActionCommand())) {
                if (!((ConfigFileExecutorController)ConfigFileExecutorController.this).cpdController.cpdName.equals("") && !((ConfigFileExecutorController)ConfigFileExecutorController.this).cpdController.cpdValue.equals("")) {
                    ConfigFileExecutorController.this.addNameValue(((ConfigFileExecutorController)ConfigFileExecutorController.this).cpdController.cpdName, ((ConfigFileExecutorController)ConfigFileExecutorController.this).cpdController.cpdValue);
                }
                ConfigFileExecutorController.this.cpdController.stopDialog();
            } else if ("CANCEL_PRESSED".equals(event.getActionCommand())) {
                ConfigFileExecutorController.this.cpdController.stopDialog();
            }
        }
    }
}

