/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListMoGenImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IllegalMoTypeException;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumAdmState;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.PacketFrequencySyncRefMo;
import se.ericsson.cello.sync.PtpPortIdentity;
import se.ericsson.cello.sync.sync_freq_mi;
import se.ericsson.cello.transaction.Coordinator;

public abstract class PacketFrequencySyncRefMoGen
extends CelloMao
implements PacketFrequencySyncRefMo {
    private static String[] ATTRIBUTE_NAMES = new String[]{"ipAccessHostEtRef", "administrativeState", "serverAddress", "dscp", "ptpDomain", "userLabel", "freqTuFroId"};
    private static boolean[] MANDATORY = new boolean[]{true, false, true, false, true, false, false};
    protected FroProxy froProxy = null;
    protected MoData data;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new sync_freq_mi());
    protected MaoFroIndicationHandler indHandler;
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 9000;

    protected PacketFrequencySyncRefMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "PacketFrequencySyncRef", string, coordinator);
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        MoGenUtil.checkAttributesDuringCreate((String[])ATTRIBUTE_NAMES, (boolean[])MANDATORY, (AttrList)attrList, (String)"PacketFrequencySyncRef");
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"administrativeState", (AttrList)attrList, (Class)Integer.class, (String)"PacketFrequencySyncRef");
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        this.validateAdministrativeState(attrList, n2, coordinator);
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"ipAccessHostEtRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"PacketFrequencySyncRef");
        this.validateIpAccessHostEtRef(attrList, managedObject2, coordinator);
        ManagedObject managedObject3 = ((IpAccessHostEtMo)managedObject2).getIpInterfaceMoRef(coordinator);
        int n3 = this.findTuFroID(managedObject3);
        this.validateTuFroId(attrList, n3, coordinator);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"serverAddress", (AttrList)attrList, (Class)String.class, (String)"PacketFrequencySyncRef");
        this.validateServerAddress(attrList, string2, managedObject2, coordinator);
        Integer n4 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"dscp", (AttrList)attrList, (Class)Integer.class, (String)"PacketFrequencySyncRef");
        int n5 = 54;
        if (n4 != null) {
            n5 = n4;
        }
        this.validateDscp(attrList, n5, coordinator);
        Integer n6 = (Integer)MoGenUtil.checkAndGetAttributeType((String)"ptpDomain", (AttrList)attrList, (Class)Integer.class, (String)"PacketFrequencySyncRef");
        int n7 = n6;
        this.validatePtpDomain(attrList, n7, coordinator);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"PacketFrequencySyncRef");
        if (string3 == null) {
            string3 = "";
        }
        this.validateUserLabel(attrList, string3, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n8 = 0;
        if (managedObject2 != null) {
            n8 = ((IpAccessHostEtMo)managedObject2).getFroId(coordinator);
        }
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        arrayList.add(new SignedIntParameter("ipAccessHostEtRef", n8));
        arrayList.add(new SignedIntParameter("administrativeState", n2));
        arrayList.add(new StringParameter("serverAddress", string2));
        arrayList.add(new SignedIntParameter("dscp", n5));
        arrayList.add(new SignedIntParameter("ptpDomain", n7));
        arrayList.add(new SignedIntParameter("freqTuFroId", n3));
        FroData froData = this.froProxy.create(coordinator, arrayList);
        int n9 = froData.getFroId();
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string3));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n9));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef", false, managedObject2));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public PacketFrequencySyncRefMoGen(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("PacketFrequencySyncRef");
        }
        ManagedObject managedObject = this.getIpAccessHostEtRef(coordinator);
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void setIpAccessHostEtRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAccessHostEtRef", managedObject, coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public String getCachedIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("cachedIpAddress", coordinator);
    }

    public void setServerAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("serverAddress", string, coordinator);
    }

    public String getServerAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("serverAddress", coordinator);
    }

    public int getPacketSyncStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("packetSyncStatus", coordinator);
    }

    public String getPtpGrandMasterIdentity(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ptpGrandMasterIdentity", coordinator);
    }

    public int getPtpQualityLevel(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ptpQualityLevel", coordinator);
    }

    public Struct getPtpOwnPortIdentity(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("ptpOwnPortIdentity", coordinator);
    }

    public Struct getPtpParentPortIdentity(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("ptpParentPortIdentity", coordinator);
    }

    public void setDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dscp", new Integer(n), coordinator);
    }

    public int getDscp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("dscp", coordinator);
    }

    public void setPtpDomain(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ptpDomain", new Integer(n), coordinator);
    }

    public int getPtpDomain(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ptpDomain", coordinator);
    }

    public String getPacketFrequencySyncRefId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("PacketFrequencySyncRefId", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setTuFroId(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("freqTuFroId", new Integer(n), coordinator);
    }

    public int getTuFroId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("freqTuFroId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public String getType() {
        return "PacketFrequencySyncRef";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("cachedIpAddress")) {
                signedIntParameter = (StringParameter)(map = this.getFroAttributes(map, coordinator)).get("cachedIpAddress");
                if (signedIntParameter == null) {
                    objectArray[i] = "";
                    continue;
                }
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("serverAddress")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("serverAddress");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("packetSyncStatus")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("packetSyncStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpGrandMasterIdentity")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("ptpGrandMasterIdentity");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpQualityLevel")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ptpQualityLevel");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpOwnPortIdentity")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (StructParameter)map.get("ptpOwnPortIdentity");
                objectArray[i] = PtpPortIdentity.getStruct((StructParameter)signedIntParameter);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpParentPortIdentity")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (StructParameter)map.get("ptpParentPortIdentity");
                objectArray[i] = PtpPortIdentity.getStruct((StructParameter)signedIntParameter);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscp")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("dscp");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpDomain")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ptpDomain");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("freqTuFroId")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("freqTuFroId");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                signedIntParameter = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)signedIntParameter, (Coordinator)coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PacketFrequencySyncRef");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AttrListMoGenImpl attrListMoGenImpl = new AttrListMoGenImpl(stringArray, objectArray);
        MoGenUtil.checkAttributesDuringSet((String[])ATTRIBUTE_NAMES, (AttrList)attrListMoGenImpl, (String)"PacketFrequencySyncRef");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("PacketFrequencySyncRefId")) {
                arrayList.add(new StringParameter("PacketFrequencySyncRefId", (String)objectArray[i]));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                if (!(objectArray[i] instanceof ManagedObject)) {
                    throw new WrongAttributeTypeException("ipAccessHostEtRef", "PacketFrequencySyncRef");
                }
                ManagedObject managedObject = (ManagedObject)objectArray[i];
                managedObject = this.validateIpAccessHostEtRef((AttrList)attrListMoGenImpl, managedObject, coordinator);
                ManagedObject managedObject2 = this.getIpAccessHostEtRef(null);
                ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
                ManagedObject managedObject3 = ((IpAccessHostEtMo)managedObject).getIpInterfaceMoRef(null);
                int n = this.findTuFroID(managedObject3);
                this.validateTuFroId((AttrList)attrListMoGenImpl, n, coordinator);
                ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
                arrayList.add(new SignedIntParameter("ipAccessHostEtRef", ((FroInfo)managedObject).getFroId(coordinator)));
                ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef")).setValue(managedObject);
                arrayList.add(new SignedIntParameter("freqTuFroId", n));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "PacketFrequencySyncRef");
                }
                int n = (Integer)objectArray[i];
                n = this.validateAdministrativeState((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("serverAddress")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("serverAddress", "PacketFrequencySyncRef");
                }
                String string = (String)objectArray[i];
                string = this.validateServerAddress((AttrList)attrListMoGenImpl, string, this.getIpAccessHostEtRef(coordinator), coordinator);
                arrayList.add(new StringParameter("serverAddress", string));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscp")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("dscp", "PacketFrequencySyncRef");
                }
                int n = (Integer)objectArray[i];
                n = this.validateDscp((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("dscp", n));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ptpDomain")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("ptpDomain", "PacketFrequencySyncRef");
                }
                int n = (Integer)objectArray[i];
                n = this.validatePtpDomain((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("ptpDomain", n));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "PacketFrequencySyncRef");
                }
                String string = (String)objectArray[i];
                string = this.validateUserLabel((AttrList)attrListMoGenImpl, string, coordinator);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("freqTuFroId")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("freqTuFroId", "PacketFrequencySyncRef");
                }
                int n = (Integer)objectArray[i];
                n = this.validateTuFroId((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("freqTuFroId", n));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PacketFrequencySyncRef");
        }
        if (arrayList.size() > 0) {
            this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getFroAttributes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.froProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private void sendNotification(String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            StringParameter stringParameter = (StringParameter)map.get("cachedIpAddress");
            if (signedIntParameter != null) {
                this.sendNotification("administrativeState", new Integer(signedIntParameter.getValue()));
            } else if (stringParameter != null) {
                this.sendNotification("cachedIpAddress", stringParameter.getValue());
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
    }

    protected abstract int findTuFroID(ManagedObject var1) throws MoAccessException;

    protected ManagedObject validateIpAccessHostEtRef(AttrList attrList, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (!(managedObject instanceof IpAccessHostEtMo)) {
            throw new IllegalMoTypeException("The provided ipAccessHostEtRef is not valid", "PacketFrequencySyncRef");
        }
        return managedObject;
    }

    protected int validateAdministrativeState(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)(EnumAdmState.VALUES_ARRAY.length - 1), (String)"PacketFrequencySyncRef");
        return n;
    }

    protected abstract String validateServerAddress(AttrList var1, String var2, ManagedObject var3, Coordinator var4) throws MoAccessException;

    protected int validateDscp(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"dscp", (int)n, (int)0, (int)63, (String)"PacketFrequencySyncRef");
        return n;
    }

    protected int validateTuFroId(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        if (n == 0) {
            throw new ConfigurationMismatchException("NO TimingUnit MO ", "PacketFrequencySyncRef");
        }
        return n;
    }

    protected abstract int validatePtpDomain(AttrList var1, int var2, Coordinator var3) throws MoAccessException;

    protected String validateUserLabel(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"PacketFrequencySyncRef");
        return string;
    }
}

