/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class ToolService {
    public static final String LDNs_KEY = "LDNs";
    public static final String MOCLASS_KEY = "MOCLASS";
    public static final String MO_PROPERTIES_CONFIG_KEY = "MOPROPERTIES_CONFIG";
    public static final String SELECTED_ATTRIBUTES_KEY = "SELECTED_ATTRIBUTES";
    private LauncherInterface myLauncher;
    private Properties mySupersedingProperties;
    private Properties myParameters;
    private String myHost;
    private Launchable myHelpServiceLaunchable;

    public ToolService(String host, LauncherInterface launcher, Launchable helpService, Properties parameters, Properties supersedingProps) {
        this.myLauncher = launcher;
        this.myParameters = parameters;
        this.mySupersedingProperties = supersedingProps;
        this.myHost = host;
        this.myHelpServiceLaunchable = helpService;
    }

    public void launchManagedElementDataProperties() {
        final Properties props = new Properties();
        props.putAll((Map<?, ?>)this.mySupersedingProperties);
        props.setProperty(LDNs_KEY, "ManagedElement=1,ManagedElementData=1");
        String selectedAttr = "docLibSystemDefined;docLibUserDefined;documentServerAddress";
        props.setProperty(SELECTED_ATTRIBUTES_KEY, selectedAttr);
        final String mopropConfig = this.myParameters.getProperty(MO_PROPERTIES_CONFIG_KEY, "");
        if (mopropConfig.length() > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ToolService.this.myLauncher.runApplication(mopropConfig, ToolService.this.myHost, props, ToolService.this.myHelpServiceLaunchable);
                    }
                    catch (Exception exep) {
                        HelpServiceLog.logger().log(Level.SEVERE, "Could not launch " + mopropConfig + "\n" + HelpServiceLog.stackToString(exep));
                    }
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        } else {
            HelpServiceLog.logger().info("Was not able to start MO Properties for ManagedElementData MO. Have no information on which configuration file to use for MO Properties.");
        }
    }
}

