/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservicestool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.nodeservices.NodeServicesFactory;
import se.ericsson.cello.emt.nodeservicestool.Configuration;
import se.ericsson.cello.emt.nodeservicestool.ConfigurationFactory;
import se.ericsson.cello.emt.nodeservicestool.MomDownloader;
import se.ericsson.cello.emt.nodeservicestool.MomDownloaderFactory;
import se.ericsson.cello.emt.nodeservicestool.NodeServicesTool;
import se.ericsson.cello.emt.nodeservicestool.view.NodeMonitorControllerFactory;
import se.ericsson.cello.emt.nodeservicestool.view.NodeMonitorView;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeConnectionEvent;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.eprops.EmasRuntimeException;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmStarterInterface;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeServicesToolImpl
implements NodeServicesTool {
    private static final EmLogger LOG = EmLogger.NODE_SERVICE;
    private NodeMonitorView myView = null;
    private LauncherInterface myLauncher = null;
    private Configuration myConfiguration = null;
    private String launchableName = "not set";
    private int myNrOfRunCalls = 0;
    private int myNrOfReuseCalls = 0;
    private String myHostName;
    private NodeConnectionListener myNodeConnectionListener = null;
    private boolean sameVersion = true;
    private Exception myMiscExcep = null;
    private Exception myMimExcep = null;
    private Exception myConnectExcep = null;
    private MimModel myMimModel = null;
    private Node myNode = null;
    private CountDownLatch runMethodIsDone;
    private CountDownLatch initNodeIsDone;
    private CountDownLatch initMimModelIsDone;
    private Object myNodeLock;
    private boolean myNodeRequestedFirstTime = true;
    private Runnable myMimModelInitializer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info("Start of mimModelInitializer", new Object[0]);
            NodeServicesToolImpl.this.myMimExcep = null;
            NodeServicesToolImpl.this.myMimModel = null;
            MomDownloader momDownloader = MomDownloaderFactory.createMomDownloader(NodeServicesToolImpl.this.myConfiguration, NodeServicesToolImpl.this.myLauncher);
            try {
                NodeServicesToolImpl.this.myMimModel = NodeServicesToolImpl.this.createMimModel(momDownloader);
            }
            catch (Exception e1) {
                String exceptionMessage = e1.getMessage();
                Throwable cause = e1.getCause();
                String severeMessage = "Failed to download/parse the MOM XML url and/or DTD url to the client cache. ";
                LOG.severe(severeMessage + " " + exceptionMessage, new Object[0]);
                try {
                    momDownloader.removeCachedMomFile();
                }
                catch (Exception e) {
                    LOG.finer("Failed removeCachedMomFile while recovering from " + cause.toString(), (Throwable)e);
                }
                String s1 = "Could not parse the locally cached MOM file. The reason for this might be that the locally\n";
                String s2 = "cached MOM file is corrupt. The locally cached MOM file is removed by the system.\n";
                String s3 = "The parse problem was " + exceptionMessage + "\n\n";
                String s4 = "Exit the Element Manager and restart it. The restart forces a new download of the MOM file\n";
                String s5 = "from the node to your local cache.\n";
                String s = s1 + s2 + s3 + s4 + s5;
                Exception e = new Exception(s, e1);
                NodeServicesToolImpl.this.myMimExcep = e;
            }
            finally {
                NodeServicesToolImpl.this.initMimModelIsDone.countDown();
                LOG.info("End of mimModelInitializer", new Object[0]);
            }
        }
    };

    public NodeServicesToolImpl() {
        LOG.info("NodeServicesToolImpl constructor", new Object[0]);
        this.runMethodIsDone = new CountDownLatch(1);
        this.initNodeIsDone = new CountDownLatch(1);
        this.initMimModelIsDone = new CountDownLatch(1);
        this.myNodeLock = new Object();
        this.myNodeConnectionListener = this;
        if (TmUtilities.isSemlaActive() && TmProperty.MIB.isSet()) {
            TmStarterInterface stubStarter = TmUtilities.getStubStarter();
            stubStarter.setStubbedNode();
        }
    }

    @Override
    public MimModel getMimModel() {
        try {
            this.initMimModelIsDone.await();
        }
        catch (InterruptedException e) {
            LOG.severe("Call to await was interupted", new Object[0]);
            throw new RuntimeException(e);
        }
        if (this.myMimModel == null) {
            LOG.severe("myMimModel is null. noOfRunCalls:" + this.myNrOfRunCalls, new Object[0]);
            if (this.myMiscExcep != null) {
                LOG.severe("A misc exception already occurred, probably due to SW error: " + this.myMiscExcep.getMessage(), new Object[0]);
                throw new RuntimeException(this.myMiscExcep);
            }
            if (this.myMimExcep != null) {
                this.reportMimException();
                throw new RuntimeException(this.myMimExcep);
            }
            LOG.severe("Managed Information Model could not be read/parsed. noOfRunCalls:" + this.myNrOfRunCalls, new Object[0]);
            throw new RuntimeException("Managed Information Model could not be read/parsed.");
        }
        return this.myMimModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode() {
        LOG.fine("Acquire exclusive access to the Node object.", new Object[0]);
        Object object = this.myNodeLock;
        synchronized (object) {
            try {
                LOG.fine("Await the initialization of the Node object", new Object[0]);
                this.initNodeIsDone.await();
            }
            catch (Exception e) {
                LOG.severe("Error occurred while waiting for the node to be initialized : " + e.getMessage(), new Object[0]);
                throw new RuntimeException(e);
            }
            if (this.myNode == null) {
                LOG.info("The node initialization failed.", new Object[0]);
                if (this.myNodeRequestedFirstTime) {
                    this.myNodeRequestedFirstTime = false;
                } else {
                    this.reInitializeNode();
                }
                if (this.myNode == null) {
                    this.reportConnectException();
                    throw new EmasRuntimeException("Node connection is not properly initialized.", null, (Throwable)this.myConnectExcep);
                }
            }
            this.myNodeRequestedFirstTime = false;
            return this.myNode;
        }
    }

    private void reInitializeNode() {
        LOG.info("About to reinitialize the node connection.", new Object[0]);
        if (this.initNodeIsDone == null || this.initNodeIsDone.getCount() == 0L) {
            this.initNodeIsDone = new CountDownLatch(1);
        }
        this.initNodeAsynchcronous();
        try {
            LOG.info("Await the reinitialization of the node connection", new Object[0]);
            this.initNodeIsDone.await();
            LOG.info("The reinitialization try of the node is done", new Object[0]);
        }
        catch (InterruptedException e) {
            LOG.severe("Await initNodeIsDone was interrupted", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public void exit() {
        if (this.myNode != null) {
            this.myNode.free();
            this.myNode.removeConnectionListener((NodeConnectionListener)this);
            this.myNode = null;
        } else {
            LOG.severe("Thread.getAllStackTraces:" + Thread.getAllStackTraces(), new Object[0]);
        }
        if (null != this.myView) {
            this.myView.closeDownGUI();
            this.myView = null;
        }
        this.myLauncher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return false;
    }

    public String toString() {
        try {
            this.runMethodIsDone.await();
        }
        catch (InterruptedException e) {
            LOG.severe("Call to await was interrupted", new Object[0]);
            throw new RuntimeException(e.getMessage());
        }
        return this.launchableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String host, Properties props, LauncherInterface launcher, Launchable parentLaunchable) {
        this.myHostName = host;
        this.myLauncher = launcher;
        ++this.myNrOfRunCalls;
        LOG.info("noOfRunCalls:" + this.myNrOfRunCalls, new Object[0]);
        if (this.myNrOfRunCalls > 1) {
            LOG.severe("run method called more than one. Error in the Launcher?", new Object[0]);
        }
        try {
            this.myConfiguration = ConfigurationFactory.createConfiguration(host, props, launcher, parentLaunchable);
            this.launchableName = this.myConfiguration.getTitle();
            this.setupModelViewControllerInfrastructure();
            this.initMimModelAsynchcronous();
            this.initNodeAsynchcronous();
        }
        catch (Exception e) {
            this.myMiscExcep = e;
            this.reportMiscException();
        }
        finally {
            this.runMethodIsDone.countDown();
            LOG.info("The run method is done.", new Object[0]);
        }
    }

    private void reportMiscException() {
        if (this.myMiscExcep != null) {
            LOG.severe("Failed to start NodeServices, e.getMessage()=" + this.myMiscExcep.getMessage(), new Object[0]);
            this.showErrorMessage("Node connection not established.", "Unexpected software error on client. It is not possible to interact with the node.", this.myMiscExcep);
        } else {
            LOG.severe("Failed to start NodeServices, myMiscExcep == null", new Object[0]);
            this.showErrorMessage("Node connection not established.", "Unexpected software error on client. It is not possible to interact with the node.");
        }
    }

    private void reportConnectException() {
        if (this.myConnectExcep != null) {
            LOG.severe("Failed to initialize the Node connection, e.getMessage()=" + this.myConnectExcep.getMessage(), new Object[0]);
            this.showErrorMessage("Node connection not established.", "Connection towards the node was not established. It is not possible to interact with the node.", this.myConnectExcep);
        } else {
            LOG.severe("Failed to initialize the Node connection, myConnectExcep == null", new Object[0]);
            this.showErrorMessage("Node connection not established.", "Connection towards the node was not established. It is not possible to interact with the node.");
        }
    }

    private void reportMimException() {
        if (this.myMimExcep != null) {
            LOG.severe("Failed to initialize the Mim Model, e.getMessage()=" + this.myMimExcep.getMessage(), new Object[0]);
            this.showErrorMessage("Node system information is not accessible.", "The system model information, the MOM, could not be read.", this.myMimExcep);
        } else {
            LOG.severe("Failed to initialize the Mim Model, myMimExcep == null", new Object[0]);
            this.showErrorMessage("Node system information is not accessible.", "The system model information, the MOM, could not be read.");
        }
    }

    private void showErrorMessage(final String mainMsg, final String msg, Exception e) {
        final Exception tmpExcep = e;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NodeServicesToolImpl.this.showErrorMessage(mainMsg, msg, tmpExcep);
                }
            });
        } else {
            MessageDialogFactory.createMessageDialog(mainMsg, msg, tmpExcep, true, null).setVisible(true);
        }
    }

    private void showErrorMessage(final String mainMsg, final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NodeServicesToolImpl.this.showErrorMessage(mainMsg, msg);
                }
            });
        } else {
            MessageDialogFactory.createMessageDialog(mainMsg, msg, true, null).setVisible(true);
        }
    }

    public void reuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        try {
            this.runMethodIsDone.await();
        }
        catch (InterruptedException e) {
            LOG.severe("Call to await was interrupted", new Object[0]);
            throw new RuntimeException(e.getMessage());
        }
        ++this.myNrOfReuseCalls;
        LOG.info("noOfReuseCalls:" + this.myNrOfReuseCalls, new Object[0]);
    }

    public void connectionLost(NodeConnectionEvent connectionEvent) {
        LOG.info("Connection lost to node", new Object[0]);
        if (this.myNode != null) {
            this.myView.connectionLost();
        }
    }

    public void connectionRestored(NodeConnectionEvent arg0) {
        LOG.info("Connection restored to the node", new Object[0]);
        if (this.myNode != null) {
            this.sameVersion = this.myLauncher.hasNESameVersion(this.myHostName, (Launchable)this);
            LOG.info("sameVersion = " + this.sameVersion, new Object[0]);
            boolean sameSecurity = this.myLauncher.hasNESameSecurityState(this.myHostName, (Launchable)this);
            LOG.info("sameSecurity = " + sameSecurity, new Object[0]);
            LOG.info("about to call myView.connectionRestored()", new Object[0]);
            this.myView.connectionRestored(this.sameVersion, sameSecurity);
        }
    }

    @Override
    public boolean isSameVersion() {
        return this.sameVersion;
    }

    private void setupModelViewControllerInfrastructure() {
        NodeMonitorControllerFactory.createController(this);
    }

    @Override
    public void addNodeMonitorView(NodeMonitorView view) {
        this.myView = view;
    }

    public LauncherInterface getLauncher() {
        return this.myLauncher;
    }

    @Override
    public Configuration getApplicationConfiguration() {
        return this.myConfiguration;
    }

    private void initMimModelAsynchcronous() {
        Runnable myMimModelInitializer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.info("Start of mimModelInitializer", new Object[0]);
                NodeServicesToolImpl.this.myMimExcep = null;
                NodeServicesToolImpl.this.myMimModel = null;
                MomDownloader momDownloader = MomDownloaderFactory.createMomDownloader(NodeServicesToolImpl.this.myConfiguration, NodeServicesToolImpl.this.myLauncher);
                try {
                    NodeServicesToolImpl.this.myMimModel = NodeServicesToolImpl.this.createMimModel(momDownloader);
                }
                catch (Exception e1) {
                    String exceptionMessage = e1.getMessage();
                    Throwable cause = e1.getCause();
                    String severeMessage = "Failed to download/parse the MOM XML url and/or DTD url to the client cache. ";
                    LOG.severe(severeMessage + " " + exceptionMessage, new Object[0]);
                    try {
                        momDownloader.removeCachedMomFile();
                    }
                    catch (Exception e) {
                        LOG.finer("Failed removeCachedMomFile while recovering from " + cause.toString(), (Throwable)e);
                    }
                    String s1 = "Could not parse the locally cached MOM file. The reason for this might be that the locally\n";
                    String s2 = "cached MOM file is corrupt. The locally cached MOM file is removed by the system.\n";
                    String s3 = "The parse problem was " + exceptionMessage + "\n\n";
                    String s4 = "Exit the Element Manager and restart it. The restart forces a new download of the MOM file\n";
                    String s5 = "from the node to your local cache.\n";
                    String s = s1 + s2 + s3 + s4 + s5;
                    Exception e = new Exception(s, e1);
                    NodeServicesToolImpl.this.myMimExcep = e;
                }
                finally {
                    NodeServicesToolImpl.this.initMimModelIsDone.countDown();
                    LOG.info("End of mimModelInitializer", new Object[0]);
                }
            }
        };
        Thread mimInitThread = new Thread(myMimModelInitializer, "mimInitThread");
        LOG.info("before mimInitThread.start()", new Object[0]);
        mimInitThread.start();
        LOG.info("after mimInitThread.start()", new Object[0]);
    }

    private MimModel createMimModel(MomDownloader momDownloader) {
        String momFilePathOnClient = momDownloader.getMomLocalFilePath();
        NodeServices tmpMimModelNodeServ = NodeServicesFactory.createNodeServices(null, momFilePathOnClient);
        MimModel mimModel = tmpMimModelNodeServ.getMimModel();
        return mimModel;
    }

    private void initNodeAsynchcronous() {
        Runnable myNodeInitializer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.info("About to init the node object.", new Object[0]);
                NodeServicesToolImpl.this.myConnectExcep = null;
                NodeServicesToolImpl.this.myNode = null;
                try {
                    NodeServices tmpNodeServForNodeConnection = NodeServicesFactory.createNodeServices(NodeServicesToolImpl.this.myConfiguration.getNodeConfig(), "dummy");
                    NodeServicesToolImpl.this.myNode = tmpNodeServForNodeConnection.getNode();
                    NodeServicesToolImpl.this.myNode.addConnectionListener(NodeServicesToolImpl.this.myNodeConnectionListener);
                }
                catch (Exception e) {
                    NodeServicesToolImpl.this.myConnectExcep = e;
                    LOG.severe("Failed to connect to the node. myConnectExcep.getMessage:" + NodeServicesToolImpl.this.myConnectExcep.getMessage(), new Object[0]);
                }
                finally {
                    NodeServicesToolImpl.this.initNodeIsDone.countDown();
                    LOG.info("end of nodeInitializer", new Object[0]);
                }
            }
        };
        Thread nodeInitThread = new Thread(myNodeInitializer, "nodeInitThread");
        LOG.info("before nodeInitThread.start()", new Object[0]);
        nodeInitThread.start();
        LOG.info("after nodeInitThread.start()", new Object[0]);
    }

    @Override
    public void closeRunningApplications(List<String> excludedApps, boolean includeReconnectabelApps) {
        List<Launchable> appsToClose = this.getApplications(excludedApps, includeReconnectabelApps);
        for (Launchable launchable : appsToClose) {
            LOG.info("about to close application:" + launchable.toString(), new Object[0]);
            launchable.exit();
        }
    }

    @Override
    public String[] getRunningApplications(List<String> excludedApps, boolean includeReconnectabelApps) {
        List<Launchable> apps = this.getApplications(excludedApps, includeReconnectabelApps);
        ArrayList<String> appNames = new ArrayList<String>(0);
        if (apps != null) {
            for (Launchable launchable : apps) {
                String appName = launchable.toString();
                if (appName == null) continue;
                appNames.add(appName);
            }
        }
        String[] appNamesArray = appNames.toArray(new String[appNames.size()]);
        return appNamesArray;
    }

    private List<Launchable> getApplications(List<String> excludedApps, boolean includeReconnectabelApps) {
        List<Launchable> filteredOnReconnectableList = this.getRunningApplications(includeReconnectabelApps);
        List<Launchable> includeList = this.excludeApplications(filteredOnReconnectableList, excludedApps);
        return includeList;
    }

    private List<Launchable> getRunningApplications(boolean includeReconnectabelApps) {
        Iterator toolsIterator = this.myLauncher.getRunningApplications().iterator();
        ArrayList<Launchable> runningAppsList = new ArrayList<Launchable>(0);
        while (toolsIterator.hasNext()) {
            Launchable tool = (Launchable)toolsIterator.next();
            if (includeReconnectabelApps || !tool.reconnect(this.myHostName, null)) {
                runningAppsList.add(tool);
                continue;
            }
            LOG.info("The following tool is ignored:" + tool.toString(), new Object[0]);
        }
        return runningAppsList;
    }

    private List<Launchable> excludeApplications(List<Launchable> applicationList, List<String> appsToExclude) {
        ArrayList<Launchable> resultList = new ArrayList<Launchable>(0);
        if (applicationList != null) {
            for (Launchable app : applicationList) {
                if (!this.matchingNameInList(app.toString(), appsToExclude)) {
                    resultList.add(app);
                    continue;
                }
                LOG.info("The following tool is excluded:" + app.toString(), new Object[0]);
            }
        }
        return resultList;
    }

    private boolean matchingNameInList(String appName, List<String> excludedApps) {
        if (appName != null && excludedApps != null) {
            for (String listItem : excludedApps) {
                if (!appName.toLowerCase().contains(listItem.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

