/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.userpreferences;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.userpreferences.storage.ifc.StorageAccess;
import se.ericsson.cello.emt.userpreferences.storage.impl.Storage;
import se.ericsson.cello.emt.userpreferences.utils.impl.UserPreferencesLog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ReusableLaunchable;

public class UserPreferenceService
implements ReusableLaunchable,
UserPreferencesI {
    private static final String FILE_NAME = "UserPreferences.dat";
    private static final String NOT_INITIATED = "UserPreferenceService not initiated.";
    private StorageAccess preferencesStorage;
    private LauncherInterface launcher;
    private CountDownLatch initialized = new CountDownLatch(1);

    public void reuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
    }

    public void exit() {
        try {
            this.preferencesStorage.savePreferences();
        }
        catch (IOException e) {
            MessageDialogFactory.createMessageDialog("User Preference saving problem", "A problem arised when your settings should be saved to file. They could not be permanently stored.", (Exception)e, false, null).setVisible(true);
            UserPreferencesLog.logger().log(Level.WARNING, "It was not possible to save to file.\n" + UserPreferencesLog.stackToString(e));
        }
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String hostName, Properties parameters) {
        return true;
    }

    public void run(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        this.launcher = launcher;
        String sep = System.getProperty("file.separator");
        String preferencesFileName = System.getProperty("user.home") + sep + "Ericsson" + sep + FILE_NAME;
        this.preferencesStorage = Storage.getInstance(preferencesFileName);
        this.initialized.countDown();
    }

    public String getPreference(String key, String defaultValue) {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            UserPreferencesLog.logger().info("UserPreferenceService not initiated. Returning default value.");
            return defaultValue;
        }
        return this.preferencesStorage.getPreference(key, defaultValue);
    }

    public void setPreference(String key, String value) {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            UserPreferencesLog.logger().info("UserPreferenceService not initiated. Could not set preference.");
            return;
        }
        this.preferencesStorage.setPreference(key, value);
    }

    public void removePreference(String preferenceKey) {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            UserPreferencesLog.logger().info("UserPreferenceService not initiated. Could not remove preference.");
            return;
        }
        this.preferencesStorage.removePreference(preferenceKey);
    }
}

