/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomException;
import se.ericsson.cello.mimparser.MomParameter;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.state.ConditionSettable;
import se.ericsson.cello.mimparser.state.DependenciesScriptSettable;
import se.ericsson.cello.mimparser.state.DependenciesSettable;
import se.ericsson.cello.mimparser.state.DeprecatedSettable;
import se.ericsson.cello.mimparser.state.DisturbancesSettable;
import se.ericsson.cello.mimparser.state.FeatureSettable;
import se.ericsson.cello.mimparser.state.FilterSettable;
import se.ericsson.cello.mimparser.state.ObsoleteSettable;
import se.ericsson.cello.mimparser.state.PreConditionSettable;
import se.ericsson.cello.mimparser.state.SideEffectsSettable;
import se.ericsson.cello.mimparser.state.SpecificationSettable;
import se.ericsson.cello.mimparser.state.TakesEffectSettable;
import se.ericsson.cello.mimparser.state.TransactionConstraintSettable;
import se.ericsson.cello.mimparser.state.VisibilitySettable;

public class MomActionImpl
extends MomBase
implements MomAction,
MomEntityResolvable,
DeprecatedSettable,
DisturbancesSettable,
TakesEffectSettable,
SideEffectsSettable,
DependenciesSettable,
PreConditionSettable,
ConditionSettable,
SpecificationSettable,
ObsoleteSettable,
VisibilitySettable,
FilterSettable,
DependenciesScriptSettable,
FeatureSettable,
TransactionConstraintSettable {
    private static final String VOID = "void";
    private static final String DESCRIPTION = "description: ";
    private static final String RAISES_EXCEPTION = "raisesException: ";
    private static final String SPACE = " ";
    private static final String NEW_LINE = "\n";
    private static final String TRUE = "true";
    private static final String TRANSACTION_REQUIRED = "transactionRequired: ";
    private static final String SPECIFICATION = "specification: ";
    private static final String CONDITION = "condition: ";
    private static final String PRECONDITION = "precondition: ";
    private static final String DEPENDENCIES = "dependencies: ";
    private static final String SIDE_EFFECTS = "sideEffects: ";
    private static final String TAKES_EFFECT = "takesEffect: ";
    private static final String LOCKBEFORE_MODIFY = "lockBeforeModify: ";
    private static final String LOCKBEFORE_EXECUTE = "lockBeforeExecute: ";
    private static final String DISTURBANCES = "disturbances: ";
    private static final String DEPRECATED = "deprecated: ";
    private static final String APPLICATION_TAG = "applicationTag: ";
    private static final String RETURN_TYPE = "returnType: ";
    private static final String RESOLUTION = "resolution: ";
    private static final String MULTIPLICATION_FACTOR = "multiplicationFactor: ";
    private static final String VISIBILITY = "visibility: ";
    private static final String OBSOLETE = "obsolete: ";
    private static final String DEPENDENCIES_SCRIPT = "dependenciesScript: ";
    private static final String FEATURE = "feature: ";
    private static final String TRANSACTION = "transactionConstraint: ";
    private static final String UNIT = "unit: ";
    private static final String FILTER = "filter";
    private static final String INTERFACEONLY = "interfaceOnly";
    private List exceptions = new ArrayList(0);
    private List parameters = new ArrayList(0);
    private MomEntity returnType;
    private DomainExtension domainExtension;
    private String transactionConstraint;
    private String deprecated;
    private String disturbances;
    private String lockBeforeModify;
    private String lockBeforeExecute;
    private String takesEffect;
    private String sideEffects;
    private String dependencies;
    private String preCondition;
    private String condition;
    private String specification;
    private boolean transactionRequired;
    private String obsolete;
    private String visibility;
    private String filter;
    private String dependenciesScript;
    private String feature;
    private String interfaceOnly;

    public MomActionImpl(String string, Attributes attributes, MimModelImpl mimModelImpl, int n) {
        super(string, attributes, mimModelImpl, n);
    }

    public MomEntity getReturnType() {
        return this.returnType;
    }

    public void setReturnType(MomEntity momEntity) {
        this.returnType = momEntity;
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtensionImpl) {
        this.domainExtension = domainExtensionImpl;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public void addParameter(MomParameter momParameter) {
        this.parameters.add(momParameter);
    }

    public Iterator getExceptions() {
        return this.exceptions.iterator();
    }

    public void addException(String string) {
        MomException momException = this.getModel().getException(string);
        if (momException == null) {
            String string2 = "Can not add exception to action=" + this.getName() + ". The referenced exception can not be found. Exception=" + string + " method=MomActionImpl.addException()";
            this.getModel().addToWarningList(string2);
        }
        this.exceptions.add(momException);
    }

    public void setResolvedEntity(MomEntity momEntity) {
        this.setReturnType(momEntity);
    }

    public void setDeprecated(String string) {
        this.deprecated = string;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getTransactionConstraint() {
        return this.transactionConstraint;
    }

    public void setTransactionConstraint(String string) {
        this.transactionConstraint = string;
    }

    public String getDisturbances() {
        return this.disturbances;
    }

    public void setDisturbances(String string) {
        this.disturbances = string;
    }

    public boolean isLockBeforeModify() {
        return TRUE.equals(this.lockBeforeModify);
    }

    public void setLockBeforeModify() {
        this.lockBeforeModify = TRUE;
    }

    public boolean isLockBeforeExecute() {
        return TRUE.equals(this.lockBeforeExecute);
    }

    public void setLockBeforeExecute() {
        this.lockBeforeExecute = TRUE;
    }

    public void setTakesEffect(String string) {
        this.takesEffect = string;
    }

    public String getTakesEffect() {
        return this.takesEffect;
    }

    public void setSideEffects(String string) {
        this.sideEffects = string;
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public void setDependencies(String string) {
        this.dependencies = string;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    public void setPreCondition(String string) {
        this.preCondition = string;
    }

    public String getPreCondition() {
        return this.preCondition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String string) {
        this.specification = string;
    }

    public boolean isTransactionRequired() {
        return this.transactionRequired;
    }

    public void setTransactionRequired() {
        this.transactionRequired = true;
    }

    public String getObsolete() {
        return this.obsolete;
    }

    public void setObsolete(String string) {
        this.obsolete = string;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String string) {
        this.visibility = string;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public String getDependenciesScript() {
        return this.dependenciesScript;
    }

    public void setDependenciesScript(String string) {
        this.dependenciesScript = string;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String string) {
        this.feature = string;
    }

    public boolean isInterfaceOnly() {
        return TRUE.equals(this.interfaceOnly);
    }

    public void setInterfaceOnly() {
        this.interfaceOnly = TRUE;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDescription() != null) {
            stringBuffer.append("description: \n" + this.getDescription() + NEW_LINE + NEW_LINE);
        }
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(this.appendActionInfo());
        return stringBuffer.toString();
    }

    private StringBuffer appendActionInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG + this.getApplicationTag() + NEW_LINE);
        }
        stringBuffer.append(this.appendReturnTypeInfo());
        stringBuffer.append(this.appendParameterInfo());
        stringBuffer.append(this.appendExceptionInfo());
        if (this.getDeprecated() != null) {
            stringBuffer.append(DEPRECATED + this.getDeprecated() + NEW_LINE);
        }
        if (this.getDisturbances() != null) {
            stringBuffer.append(DISTURBANCES + this.getDisturbances() + NEW_LINE);
        }
        if (this.isLockBeforeModify()) {
            stringBuffer.append("lockBeforeModify: true\n");
        }
        if (this.isLockBeforeExecute()) {
            stringBuffer.append("lockBeforeExecute: true\n");
        }
        if (this.getTakesEffect() != null) {
            stringBuffer.append(TAKES_EFFECT + this.getTakesEffect() + NEW_LINE);
        }
        if (this.getSideEffects() != null) {
            stringBuffer.append(SIDE_EFFECTS + this.getSideEffects() + NEW_LINE);
        }
        if (this.getDependencies() != null) {
            stringBuffer.append(DEPENDENCIES + this.getDependencies() + NEW_LINE);
        }
        if (this.getPreCondition() != null) {
            stringBuffer.append(PRECONDITION + this.getPreCondition() + NEW_LINE);
        }
        if (this.getCondition() != null) {
            stringBuffer.append(CONDITION + this.getCondition() + NEW_LINE);
        }
        if (this.getSpecification() != null) {
            stringBuffer.append(SPECIFICATION + this.getSpecification() + NEW_LINE);
        }
        if (this.isTransactionRequired()) {
            stringBuffer.append("transactionRequired: true\n");
        }
        if (this.getObsolete() != null) {
            stringBuffer.append(OBSOLETE + this.getObsolete() + NEW_LINE);
        }
        if (this.getDependenciesScript() != null) {
            stringBuffer.append(DEPENDENCIES_SCRIPT + this.getDependenciesScript() + NEW_LINE);
        }
        if (this.getTransactionConstraint() != null) {
            stringBuffer.append(TRANSACTION + this.getTransactionConstraint() + NEW_LINE);
        }
        if (this.getVisibility() != null) {
            stringBuffer.append(VISIBILITY + this.getVisibility() + NEW_LINE);
        }
        if (this.getFilter() != null) {
            stringBuffer.append(FILTER + this.getFilter() + NEW_LINE);
        }
        if (this.getFeature() != null) {
            stringBuffer.append(FEATURE + this.getFeature() + NEW_LINE);
        }
        if (this.isInterfaceOnly()) {
            stringBuffer.append("interfaceOnlytrue\n");
        }
        return stringBuffer;
    }

    private StringBuffer appendExceptionInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getExceptions();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (iterator.hasNext()) {
            MomException momException = (MomException)iterator.next();
            if (iterator.hasNext()) {
                stringBuffer2.append(momException.getName() + "," + SPACE);
                continue;
            }
            stringBuffer2.append(momException.getName());
        }
        if (stringBuffer2.length() != 0) {
            stringBuffer.append(RAISES_EXCEPTION + stringBuffer2.toString() + NEW_LINE);
        }
        return stringBuffer;
    }

    private StringBuffer appendParameterInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.getParameters();
        while (iterator.hasNext()) {
            MomParameter momParameter = (MomParameter)iterator.next();
            if (iterator.hasNext()) {
                stringBuffer2.append(momParameter.getTypeInfo() + "," + SPACE);
                continue;
            }
            stringBuffer2.append(momParameter.getTypeInfo());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("parameter: " + stringBuffer2.toString() + NEW_LINE);
        }
        return stringBuffer;
    }

    private StringBuffer appendReturnTypeInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getReturnType() != null) {
            MomEntity momEntity = this.getReturnType();
            if (momEntity instanceof MomCorbaTypeAttribute) {
                MomCorbaTypeAttribute momCorbaTypeAttribute = (MomCorbaTypeAttribute)momEntity;
                stringBuffer.append(RETURN_TYPE + momCorbaTypeAttribute.getXmlType() + NEW_LINE);
                if (momCorbaTypeAttribute.getUnit() != null) {
                    stringBuffer.append(UNIT + momCorbaTypeAttribute.getUnit() + NEW_LINE);
                }
                if (momCorbaTypeAttribute.getMultiplicationFactor() != null) {
                    stringBuffer.append(MULTIPLICATION_FACTOR + momCorbaTypeAttribute.getMultiplicationFactor() + NEW_LINE);
                }
                if (momCorbaTypeAttribute.getResolution() != null) {
                    stringBuffer.append(RESOLUTION + momCorbaTypeAttribute.getResolution() + NEW_LINE);
                }
            } else if (momEntity instanceof MomSequence) {
                MomSequence momSequence = (MomSequence)momEntity;
                stringBuffer.append(RETURN_TYPE + momSequence.getType().getXmlType() + "[] \n");
            } else if (momEntity instanceof MomEnumRef) {
                stringBuffer.append(RETURN_TYPE + momEntity.getName() + NEW_LINE);
            } else if (momEntity instanceof MomStruct) {
                stringBuffer.append(RETURN_TYPE + momEntity.getName() + NEW_LINE);
            }
        } else {
            stringBuffer.append("returnType: void\n");
        }
        return stringBuffer;
    }
}

