/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEnumMemberImpl;
import se.ericsson.cello.mimparser.model.utils.DescriptionHelper;

public class MomEnumImpl
extends MomBase
implements MomEnum {
    private static final String NEW_LINE = "\n";
    private Map myEnumMembers = new HashMap();
    private static final String APPLICATION_TAG = "applicationTag: ";
    private DomainExtension domainExtension;

    public MomEnumImpl(String string, Attributes attributes, MimModelImpl mimModelImpl, int n) {
        super(string, attributes, mimModelImpl, n);
    }

    public void addEnumMember(String string, MomEnumMemberImpl momEnumMemberImpl) {
        this.myEnumMembers.put(string, momEnumMemberImpl);
    }

    public MomEnumMemberImpl getEnumMemberCaseInsensitive(String string) {
        Iterator iterator = this.getMembers();
        while (iterator.hasNext()) {
            MomEnumMember momEnumMember = (MomEnumMember)iterator.next();
            String string2 = momEnumMember.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            string = string2;
            break;
        }
        return (MomEnumMemberImpl)this.myEnumMembers.get(string);
    }

    public Iterator getMembers() {
        Collection collection = this.myEnumMembers.values();
        EnumComparator enumComparator = new EnumComparator();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, enumComparator);
        return arrayList.iterator();
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtensionImpl) {
        this.domainExtension = domainExtensionImpl;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDescription() != null) {
            stringBuffer.append("enum ");
            stringBuffer.append(this.getName());
            stringBuffer.append(" description: ");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.getDescription());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG);
            stringBuffer.append(this.getApplicationTag());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(DescriptionHelper.getEnumDescription(this));
        return stringBuffer.toString();
    }

    private class EnumComparator
    implements Comparator {
        private EnumComparator() {
        }

        public int compare(Object object, Object object2) {
            MomEnumMemberImpl momEnumMemberImpl = (MomEnumMemberImpl)object;
            MomEnumMemberImpl momEnumMemberImpl2 = (MomEnumMemberImpl)object2;
            if (momEnumMemberImpl.getValue() != null && momEnumMemberImpl2.getValue() == null) {
                return -1;
            }
            if (momEnumMemberImpl.getValue() == null && momEnumMemberImpl2.getValue() != null) {
                return 1;
            }
            if (momEnumMemberImpl.getValue() == null && momEnumMemberImpl2.getValue() == null) {
                return momEnumMemberImpl.getName().compareTo(momEnumMemberImpl2.getName());
            }
            if (momEnumMemberImpl.getValue() < momEnumMemberImpl2.getValue()) {
                return -1;
            }
            if (momEnumMemberImpl.getValue() > momEnumMemberImpl2.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

