/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomStructMemberImpl;
import se.ericsson.cello.mimparser.state.DependenciesScriptState;
import se.ericsson.cello.mimparser.state.DependenciesState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.DisturbancesState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.FeatureState;
import se.ericsson.cello.mimparser.state.FilterState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.ObsoleteState;
import se.ericsson.cello.mimparser.state.PreConditionState;
import se.ericsson.cello.mimparser.state.SideEffectsState;
import se.ericsson.cello.mimparser.state.SpecificationState;
import se.ericsson.cello.mimparser.state.TakesEffectState;
import se.ericsson.cello.mimparser.state.VisibilityState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class StructMemberState
extends MomBaseState {
    private MomStructMemberImpl structMemberImpl;
    public static final String STRUCT_MEMBER_TAG = "structMember";

    public StructMemberState(MomStructMemberImpl momStructMemberImpl) {
        super(STRUCT_MEMBER_TAG);
        this.structMemberImpl = momStructMemberImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        super.startElement(stateMachine, string, this.structMemberImpl);
        if (string.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.structMemberImpl));
        } else if (string.equals("disturbances")) {
            stateMachine.pushState(new DisturbancesState(this.structMemberImpl));
        } else if (string.equals("takesEffect")) {
            stateMachine.pushState(new TakesEffectState(this.structMemberImpl));
        } else if (string.equals("sideEffects")) {
            stateMachine.pushState(new SideEffectsState(this.structMemberImpl));
        } else if (string.equals("precondition")) {
            stateMachine.pushState(new PreConditionState(this.structMemberImpl));
        } else if (string.equals("obsolete")) {
            stateMachine.pushState(new ObsoleteState(this.structMemberImpl));
        } else if (string.equals("visibility")) {
            stateMachine.pushState(new VisibilityState(this.structMemberImpl));
        } else if (string.equals("filter")) {
            stateMachine.pushState(new FilterState(this.structMemberImpl));
        } else if (string.equals("dependencies")) {
            stateMachine.pushState(new DependenciesState(this.structMemberImpl));
        } else if (string.equals("dependenciesScript")) {
            stateMachine.pushState(new DependenciesScriptState(this.structMemberImpl));
        } else if (string.equals("feature")) {
            stateMachine.pushState(new FeatureState(this.structMemberImpl));
        } else if (string.equals("specification")) {
            stateMachine.pushState(new SpecificationState(this.structMemberImpl));
        } else if (string.equals("domainExtension")) {
            DomainExtensionImpl domainExtensionImpl = new DomainExtensionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.structMemberImpl.setDomain(domainExtensionImpl);
            stateMachine.pushState(new DomainExtensionState(domainExtensionImpl));
        } else if (string.equals("interfaceOnly")) {
            this.structMemberImpl.setInterfaceOnly();
        }
        stateMachine.getDataTypeManager().handleDataTypes(this.structMemberImpl, string, attributes);
    }
}

