/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mao;

import java.io.FileNotFoundException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.ncli.mao.NcliCommandFileException;
import se.ericsson.cello.ncli.mao.NcliFileNotFoundException;
import se.ericsson.cello.ncli.mao.NcliMo;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.services.NCLIServices;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class NcliMoImpl
extends ManagedObjectBase
implements NcliMo {
    private MoData data;
    private static NcliMoImpl instance = null;
    private static final String NcliId = "1";
    private static final String ID = "Id";
    private static final int SHUTTINGDOWN_TIMEOUT = 1800;
    private IntegerAttribute administrativeState;
    private static final int DEFAULT_NR_OF_SESSIONS = 2;
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    private static final String NCLI_START_FAILED = "start of Ncli failed";
    private static final String NCLI_SET_FAILED = "Failed to set attribute Administrative state";
    static /* synthetic */ Class class$java$lang$Integer;

    private NcliMoImpl() throws MoNameAlreadyTakenException {
        super(MoRepository.instance().lookupType("SystemFunctions").nextMo(), "Ncli", NcliId, null);
        Log.trace(NcliMoImpl.class, "NcliMoImpl()");
    }

    public static synchronized NcliMoImpl instance() {
        Log.trace(NcliMoImpl.class, "NcliMoImpl.instance(), set NCLI configuration");
        try {
            if (instance == null) {
                instance = new NcliMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            Log.info(NcliMoImpl.class, "Create instance of Ncli mo failed", (Exception)((Object)moNameAlreadyTakenException));
        }
        return instance;
    }

    void recover(MoData moData) {
        Log.trace(NcliMoImpl.class, "recover(MoData recoveredData) recoveredData: " + moData);
        this.data = moData;
        if (this.data.getRevision() == 5100) {
            this.administrativeState = (IntegerAttribute)moData.getAttribute("administrativeState");
        } else {
            Log.info(this.getClass(), "Wrong Mo data revision for Ncli: Revision = " + this.data.getRevision());
        }
    }

    protected synchronized void registerData() {
        Log.trace(NcliMoImpl.class, "registerData()");
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                Log.trace(this.getClass(), "Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec");
                this.data = new MoData(this.getLocalDistinguishedName(), "Ncli", true, coordinator);
                this.administrativeState = new IntegerAttribute("administrativeState", true, 1);
                this.data.registerPersistentAttr((Attribute)this.administrativeState);
                this.data.setRevision(5100);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                Log.info(this.getClass(), NCLI_START_FAILED, (Exception)((Object)transactionRequiredException));
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Log.info(this.getClass(), NCLI_START_FAILED, (Exception)((Object)transactionRolledBackException));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Log.info(this.getClass(), NCLI_START_FAILED, (Exception)((Object)inactiveTransactionException));
            }
            catch (MoAccessException moAccessException) {
                Log.info(this.getClass(), NCLI_START_FAILED, (Exception)((Object)moAccessException));
            }
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        String string = "NcliId";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("administrativeState")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(string)) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                int n = NCLIServices.getControllableServer().getStatus();
                objectArray[i] = new Integer(n);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Ncli");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                n = (Integer)objectArray[i];
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? NcliMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "Ncli");
                }
                if (n != 0 && n != 1 && n != 2) {
                    throw new ValueOutOfRangeException("administrativeState", "Ncli");
                }
                if (n == 2) {
                    Log.info(class$se$ericsson$cello$ncli$mao$NcliMoImpl == null ? NcliMoImpl.class$("se.ericsson.cello.ncli.mao.NcliMoImpl") : class$se$ericsson$cello$ncli$mao$NcliMoImpl, "AdmState set to SHUTTINGDOWN");
                    NCLIServices.getControllableServer().stop(1800);
                } else if (n == 0) {
                    Log.info(class$se$ericsson$cello$ncli$mao$NcliMoImpl == null ? NcliMoImpl.class$("se.ericsson.cello.ncli.mao.NcliMoImpl") : class$se$ericsson$cello$ncli$mao$NcliMoImpl, "AdmState set to LOCKED");
                    NCLIServices.getControllableServer().stop(0);
                } else if (n == 1) {
                    Log.info(class$se$ericsson$cello$ncli$mao$NcliMoImpl == null ? NcliMoImpl.class$("se.ericsson.cello.ncli.mao.NcliMoImpl") : class$se$ericsson$cello$ncli$mao$NcliMoImpl, "AdmState set to UNLOCKED");
                    NCLIServices.getControllableServer().start();
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "Ncli");
            }
            ((IntegerAttribute)this.data.getAttribute("administrativeState")).setValue(n);
        }
    }

    public void actionExecuteCommandFile(String string, Coordinator coordinator) throws MoAccessException {
        Log.trace(NcliMoImpl.class, "actionExecuteCommandFile");
        Log.info(NcliMoImpl.class, "actionExecuteCommandFile (test version");
        try {
            NCLIServices.getCommandFileExecutor().executeCommandFileAsAction(string);
        }
        catch (NcliException ncliException) {
            throw new NcliCommandFileException(ncliException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NcliFileNotFoundException(fileNotFoundException.getMessage());
        }
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    public void setAdministrativeStateToLocked() {
        Coordinator coordinator = null;
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            coordinator = control.getCoordinator();
            this.setAdministrativeState(0, coordinator);
            control.getTerminator().commit();
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Log.info(this.getClass(), "Failed to set attribute Administrative state " + transactionRolledBackException.getMessage());
        }
        catch (MoAccessException moAccessException) {
            try {
                coordinator.rollbackOnly();
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Log.info(this.getClass(), NCLI_SET_FAILED);
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Log.info(this.getClass(), NCLI_SET_FAILED);
        }
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getType() {
        return "Ncli";
    }
}

