/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.SearchCriteria;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Transaction;

public abstract class MoSearchableCommand
extends CSCommand {
    protected SearchCriteria searchCriteria = new SearchCriteria();

    public MoSearchableCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setSearchCriteria(SearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
        this.setMoAddress(searchCriteria.getMoAddrStartPoint());
        this.setGlobalFlag(searchCriteria.isMoAddrStartPointGlobalFlag());
    }

    public SearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public Mo[] searchMos() {
        Log.trace(MoSearchableCommand.class, "searchMos()");
        Mo[] moArray = null;
        try {
            this.getLdn();
            Mo mo = this.nodeServices.getCm().getMo(this.ldn);
            this.validateMo(mo);
            if (this.searchCriteria.getFilter() == null) {
                this.searchCriteria.setFilter("");
            }
            Transaction transaction = this.transactionHandler.getCurrentTransaction();
            moArray = mo.getChildren(this.searchCriteria.getMoType(), this.searchCriteria.getFilter(), this.searchCriteria.getScope(), transaction);
            return moArray;
        }
        catch (Exception exception) {
            Log.trace(MoSearchableCommand.class, " exception occured in searchMos(). e=" + exception.getMessage());
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            return null;
        }
    }
}

