/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public abstract class CsCmdCompleter
extends BaseCompleter {
    protected static final String GLOBAL_FLAG = "-g";
    protected static final String GROUP_FLAG = "-group";
    protected boolean globalAddr = false;
    protected String moAddress = null;
    protected Completer moAddrCompleter = null;

    public CsCmdCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public void completeString(String string) {
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        this.globalAddr = false;
        this.moAddress = null;
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(CsCmdCompleter.class, "nrOfTokens=" + n);
        if (n <= 0) {
            Log.trace(CsCmdCompleter.class, "nrOfTokens == 0, this CmdCompleter should not have been called.");
            this.completedString = string;
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (!this.completeFirstToken(string2, stringTokenizer, string)) {
            this.completedString = string;
            this.completionOptionList.clear();
        }
    }

    protected boolean completeFirstToken(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CsCmdCompleter.class, ".completeFirstToken() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (!stringTokenizer.hasMoreTokens()) {
            if (string2.endsWith(" ")) {
                return this.completeMoAddress("", stringTokenizer, string2);
            }
            Log.trace(CsCmdCompleter.class, ".completeFirstToken(), this CmdCompleter should not have been called.");
            return false;
        }
        string = stringTokenizer.nextToken();
        return this.completeMoAddress(string, stringTokenizer, string2);
    }

    protected boolean completeMoAddress(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CsCmdCompleter.class, ".completeMoAddress() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (stringTokenizer.hasMoreTokens()) {
            if (string.equalsIgnoreCase(GLOBAL_FLAG)) {
                this.globalAddr = true;
                string = stringTokenizer.nextToken();
            } else {
                this.moAddress = string;
                String string3 = CompletionHelper.resolveLdnFromGroup(this.moAddress, this.nodeServices);
                if (string3 != null) {
                    this.moAddress = string3;
                }
                return false;
            }
        }
        if (string.equalsIgnoreCase(GLOBAL_FLAG) && string2.endsWith(" ")) {
            this.globalAddr = true;
            string = "";
        } else if (stringTokenizer.hasMoreTokens() || string2.endsWith(" ") && string.length() != 0) {
            this.moAddress = string;
            String string4 = CompletionHelper.resolveLdnFromGroup(this.moAddress, this.nodeServices);
            if (string4 != null) {
                this.moAddress = string4;
            }
            return false;
        }
        Completer completer = CompleterFactory.createMoAddrCompleter(this.nodeServices, this.globalAddr);
        int n = string2.lastIndexOf(string);
        String string5 = string2.substring(0, n);
        completer.completeString(string);
        this.completedString = string5.concat(completer.getCompletedString());
        this.completionOptionList = completer.getCompletionOptionList();
        return true;
    }
}

