/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;

public class MoAddressCompleter
extends BaseCompleter {
    protected static final String GLOBALFLAG = "-g";
    protected static final String PARENTMO = "..";
    protected static final String ROOTMO = "/";
    protected static final String PREVMO = "-";
    protected static final String CURRENTMO = ".";
    protected boolean globalAddr = false;
    protected ArrayList staticAddrOptionList = new ArrayList(0);

    public MoAddressCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public MoAddressCompleter(NodeServices nodeServices, boolean bl) {
        super(nodeServices);
        this.globalAddr = bl;
    }

    public void completeString(String string) {
        Log.trace(MoAddressCompleter.class, " aStringToComplete='" + string + "'");
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        this.initStaticAddrOptionList();
        if (string == null) {
            return;
        }
        if (string.endsWith(" ")) {
            this.completedString = string;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(MoAddressCompleter.class, "nrOfTokens=" + n);
        if (n <= 0) {
            if (!this.completeEmptyString(string)) {
                this.completedString = string;
                return;
            }
        } else if (n == 1) {
            String string2 = stringTokenizer.nextToken();
            if (!this.completeFirstAndOnlyToken(string2, string)) {
                this.completedString = string;
                return;
            }
        } else {
            this.completedString = string;
            return;
        }
    }

    protected void initStaticAddrOptionList() {
        this.staticAddrOptionList.clear();
        this.staticAddrOptionList.add(GLOBALFLAG);
        this.staticAddrOptionList.add(PARENTMO);
        this.staticAddrOptionList.add(ROOTMO);
        this.staticAddrOptionList.add(PREVMO);
        this.staticAddrOptionList.add(CURRENTMO);
    }

    protected boolean completeEmptyString(String string) {
        int n;
        if (this.globalAddr) {
            return this.completeGlobalAddress("", string);
        }
        Mo[] moArray = this.nodeServices.getWorkingMo().getChildren(this.nodeServices.getTransactionHandler().getNullTransaction());
        for (n = 0; n < moArray.length; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(moArray[n].getType());
            stringBuffer.append("=");
            stringBuffer.append(moArray[n].getName());
            this.completionOptionList.add(stringBuffer.toString());
        }
        this.completionOptionList.add(this.nodeServices.getRootMo().getLdn());
        n = this.staticAddrOptionList.size();
        for (int i = 0; i < n; ++i) {
            this.completionOptionList.add((String)this.staticAddrOptionList.get(i));
        }
        return true;
    }

    protected boolean completeFirstAndOnlyToken(String string, String string2) {
        if (this.globalAddr) {
            return this.completeGlobalAddress(string, string2);
        }
        if (this.completeStaticAddrOption(string)) {
            return true;
        }
        if (string.indexOf("=") == -1 && string.indexOf(",") == -1) {
            return this.completeWoMoChildrenType(string, string2);
        }
        int n = string.lastIndexOf("=");
        int n2 = string.lastIndexOf(",");
        if (n > -1 && n2 == -1 && string.toLowerCase().startsWith(this.nodeServices.getRootMo().getType().concat("=").toLowerCase())) {
            return this.completeRootMoName(string, string2);
        }
        if (n > n2) {
            return this.completeMoNameOfDn(string, string2);
        }
        return this.completeMoTypeOfDn(string, string2);
    }

    protected boolean completeStaticAddrOption(String string) {
        String string2 = string.toLowerCase();
        int n = this.staticAddrOptionList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)this.staticAddrOptionList.get(i);
            if (!string3.startsWith(string2)) continue;
            this.completionOptionList.add(string3);
        }
        if (this.completionOptionList.size() == 1) {
            this.completedString = ((String)this.completionOptionList.get(0)).concat(" ");
            this.completionOptionList.clear();
            return true;
        }
        if (this.completionOptionList.size() > 1) {
            this.completedString = CompletionHelper.getCommonStartStr(this.completionOptionList, string);
            return true;
        }
        return false;
    }

    protected boolean completeMoTypeOfDn(String string, String string2) {
        Mo mo;
        String string3;
        int n = string.lastIndexOf(",");
        if (n < 0) {
            return false;
        }
        String string4 = string3 = string.substring(0, n);
        if (!string3.startsWith(this.nodeServices.getRootMo().getLdn())) {
            string3 = this.nodeServices.getWorkingMo().getLdn().concat(",").concat(string3);
        }
        if (!(mo = this.nodeServices.getCm().getMo(string3)).exists()) {
            return false;
        }
        String string5 = string.substring(n + 1);
        Mo[] moArray = mo.getChildren(null);
        CompletionHelper.putMatchingRdnInList(string5, moArray, this.completionOptionList);
        if (this.completionOptionList.size() == 1) {
            this.completedString = string4.concat(",").concat((String)this.completionOptionList.get(0));
            String string6 = string3.concat(",").concat((String)this.completionOptionList.get(0));
            boolean bl = this.nodeServices.getCm().getMo(string6).hasChildren(this.nodeServices.getTransactionHandler().getNullTransaction());
            if (bl && string2.endsWith(string6)) {
                this.completedString = this.completedString.concat(",");
            }
            if (!bl) {
                this.completedString = this.completedString.concat(" ");
            }
            this.completionOptionList.clear();
            return true;
        }
        if (this.completionOptionList.size() > 1) {
            String string7 = CompletionHelper.getCommonStartStr(this.completionOptionList, string2);
            if (string4.length() > 0) {
                this.completedString = string4.concat(",");
            }
            this.completedString = this.completedString.concat(string7);
            return true;
        }
        if (this.completionOptionList.size() < 1) {
            return false;
        }
        return false;
    }

    protected boolean completeMoNameOfDn(String string, String string2) {
        int n = string.lastIndexOf("=");
        if (n < 0) {
            return false;
        }
        String string3 = string;
        int n2 = string3.lastIndexOf(",");
        if (n2 > -1) {
            string3 = string.substring(n2 + 1);
        }
        String string4 = this.nodeServices.getRootMo().getLdn();
        String string5 = this.nodeServices.getWorkingMo().getLdn();
        String string6 = string.substring(0, n);
        n2 = string6.lastIndexOf(",");
        String string7 = string6 = n2 > -1 ? string6.substring(0, n2) : "";
        if (string6.length() == 0) {
            string6 = string5;
        } else if (!string6.startsWith(string4)) {
            string6 = string5.concat(",").concat(string6);
        }
        Mo mo = this.nodeServices.getCm().getMo(string6);
        if (mo == null || !mo.exists()) {
            return false;
        }
        Mo[] moArray = mo.getChildren(null);
        CompletionHelper.putMatchingRdnInList(string3, moArray, this.completionOptionList);
        return this.completeMoNameOfDnOptions(string6, string7, string2);
    }

    protected boolean completeMoNameOfDnOptions(String string, String string2, String string3) {
        if (this.completionOptionList.size() == 1) {
            String string4 = (String)this.completionOptionList.get(0);
            this.completionOptionList.clear();
            if (string2.length() > 0) {
                this.completedString = string2.concat(",");
            }
            this.completedString = this.completedString.concat(string4);
            String string5 = string.concat(",").concat(string4);
            String string6 = this.getChildrenCommonStart(string5, this.completionOptionList);
            if (string6 == null) {
                this.completedString = this.completedString.concat(" ");
                this.completionOptionList.clear();
            } else if (string3.endsWith(string4)) {
                this.completedString = this.completedString.concat(",").concat(string6);
            } else {
                this.completionOptionList.clear();
            }
            return true;
        }
        if (this.completionOptionList.size() > 1) {
            String string7 = CompletionHelper.getCommonStartStr(this.completionOptionList, string3);
            if (string2.length() > 0) {
                this.completedString = string2.concat(",");
            }
            this.completedString = this.completedString.concat(string7);
            return true;
        }
        return false;
    }

    protected boolean completeWoMoChildrenType(String string, String string2) {
        Mo[] moArray = this.nodeServices.getWorkingMo().getChildren(this.nodeServices.getTransactionHandler().getNullTransaction());
        CompletionHelper.putMatchingRdnInList(string, moArray, this.completionOptionList);
        if (this.nodeServices.getRootMo().getLdn().toLowerCase().startsWith(string.toLowerCase())) {
            this.completionOptionList.add(this.nodeServices.getRootMo().getLdn());
        }
        if (this.completionOptionList.size() == 1) {
            boolean bl;
            String string3 = this.completedString = (String)this.completionOptionList.get(0);
            if (!this.completedString.startsWith(this.nodeServices.getRootMo().getLdn())) {
                string3 = this.nodeServices.getWorkingMo().getLdn().concat(",").concat(string3);
            }
            if ((bl = this.nodeServices.getCm().getMo(string3).hasChildren(this.nodeServices.getTransactionHandler().getNullTransaction())) && string2.endsWith(string3)) {
                this.completedString = this.completedString.concat(",");
            }
            if (!bl) {
                this.completedString = this.completedString.concat(" ");
            }
            this.completionOptionList.clear();
            return true;
        }
        if (this.completionOptionList.size() > 1) {
            this.completedString = CompletionHelper.getCommonStartStr(this.completionOptionList, string2);
            return true;
        }
        if (this.completionOptionList.size() < 1) {
            return false;
        }
        return false;
    }

    public static String getCommonStartStrForMo(ArrayList arrayList, String string) {
        String string2;
        Object object;
        Object object2;
        if (arrayList == null || arrayList.size() == 0 || string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = "";
        Log.trace(MoAddressCompleter.class, "MoClassname = " + string3);
        Log.trace(MoAddressCompleter.class, "valueToComplete = " + string4);
        if (string4.indexOf(",") >= 0) {
            Log.trace(MoAddressCompleter.class, "Index of comma = " + string4.indexOf(","));
            return CompletionHelper.getCommonStartStrForSubset(arrayList);
        }
        Log.trace(MoAddressCompleter.class, "Index of comma = " + string4.indexOf(","));
        int n = 0;
        int n2 = 0;
        String string6 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string6 = (String)arrayList.get(i);
            object2 = new StringTokenizer(string6, "=");
            object = ((StringTokenizer)object2).nextToken();
            object = ((StringTokenizer)object2).nextToken();
            if (CompletionHelper.startsWithUpperCase((String)object)) {
                ++n;
                continue;
            }
            ++n2;
        }
        Log.trace(MoAddressCompleter.class, "# of upperCase options = " + n);
        Log.trace(MoAddressCompleter.class, "# of lowerCase options = " + n2);
        StringBuffer stringBuffer = new StringBuffer();
        object2 = (String)arrayList.get(0);
        object = new StringTokenizer((String)object2, "=");
        String string7 = ((StringTokenizer)object).nextToken();
        String string8 = ((StringTokenizer)object).nextToken().toLowerCase();
        object2 = (string7 + "=").concat(string8);
        Log.trace(MoAddressCompleter.class, "firstOptionStr= " + (String)object2);
        for (int i = 0; i < ((String)object2).length(); ++i) {
            stringBuffer.append(((String)object2).substring(i, i + 1));
            for (int j = 0; j < arrayList.size(); ++j) {
                string2 = (String)arrayList.get(j);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                String string9 = stringTokenizer2.nextToken();
                String string10 = stringTokenizer2.nextToken().toLowerCase();
                string2 = (string9 + "=").concat(string10);
                if (string2.startsWith(stringBuffer.toString())) {
                    string5 = stringBuffer.toString();
                }
                if (string2.startsWith(stringBuffer.toString())) continue;
                string5 = stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
            }
        }
        Log.trace(MoAddressCompleter.class, "result = " + string5);
        if (CompletionHelper.startsWithUpperCase(string4)) {
            if (n > 0) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string5, "=");
                String string11 = stringTokenizer3.nextToken();
                string2 = stringTokenizer3.nextToken();
                string2 = CompletionHelper.switchStartCase(string2);
                string5 = (string11 + "=").concat(string2);
            } else if (n == 0 && n2 == 0) {
                StringTokenizer stringTokenizer4 = new StringTokenizer(string5, "=");
                String string12 = stringTokenizer4.nextToken();
                string2 = stringTokenizer4.nextToken();
                string2 = CompletionHelper.switchStartCase(string2);
                string5 = (string12 + "=").concat(string2);
            }
        }
        if (!(CompletionHelper.startsWithUpperCase(string4) || n2 > 0 || n2 == 0 && n == 0)) {
            StringTokenizer stringTokenizer5 = new StringTokenizer(string5, "=");
            String string13 = stringTokenizer5.nextToken();
            string2 = stringTokenizer5.nextToken();
            string2 = CompletionHelper.switchStartCase(string2);
            string5 = (string13 + "=").concat(string2);
        }
        Log.trace(MoAddressCompleter.class, "Modified result = " + string5);
        return string5;
    }

    protected String getChildrenCommonStart(String string, ArrayList arrayList) {
        if (string == null || arrayList == null) {
            return null;
        }
        Mo mo = null;
        mo = this.nodeServices.getCm().getMo(string);
        if (mo == null || !mo.exists()) {
            return null;
        }
        arrayList.clear();
        Mo[] moArray = null;
        moArray = mo.getChildren(null);
        if (moArray == null || moArray.length < 1) {
            return null;
        }
        CompletionHelper.putMatchingRdnInList("", moArray, arrayList);
        int n = arrayList.size();
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            String string2 = (String)arrayList.get(0);
            arrayList.clear();
            String string3 = mo.getLdn().concat(",").concat(string2);
            Mo mo2 = null;
            mo2 = this.nodeServices.getCm().getMo(string3);
            if (mo2 == null || !mo2.exists()) {
                return string2;
            }
            boolean bl = mo2.hasChildren(this.nodeServices.getTransactionHandler().getNullTransaction());
            if (!bl) {
                string2 = string2.concat(" ");
            }
            return string2;
        }
        return CompletionHelper.getCommonStartStr(arrayList, string);
    }

    protected boolean completeGlobalAddress(String string, String string2) {
        Object object;
        Log.trace(MoAddressCompleter.class, ".completeGlobalAddress(), aStringToComplete='" + string2 + "'");
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.lastIndexOf("=");
        int n2 = string.lastIndexOf(",");
        if (n2 > -1) {
            return false;
        }
        String string3 = null;
        string3 = n > -1 ? string.substring(0, n) : string;
        if (n < 0) {
            object = CompleterFactory.createMoTypeCompleter(this.nodeServices);
            object.completeString(string3);
            this.completionOptionList = object.getCompletionOptionList();
            string3 = object.getCompletedString();
            int n3 = string3.lastIndexOf(" ");
            if (n3 > 0) {
                string3 = string3.substring(0, n3);
            }
            if (this.completionOptionList.size() <= 1) {
                this.completionOptionList.clear();
            } else if (this.completionOptionList.size() > 1) {
                this.completedString = string3;
                return true;
            }
        }
        object = "";
        Mo[] moArray = this.nodeServices.getRootMo().getChildren(string3, (String)object, Scope.ALL_LEVELS, this.nodeServices.getTransactionHandler().getCurrentTransaction());
        if (moArray == null || moArray.length <= 0) {
            return false;
        }
        CompletionHelper.putMatchingRdnInList(string, moArray, this.completionOptionList);
        if (this.completionOptionList.size() == 1) {
            String string4 = (String)this.completionOptionList.get(0);
            this.completedString = string4.concat(" ");
            this.completionOptionList.clear();
            return true;
        }
        if (this.completionOptionList.size() > 1) {
            this.completedString = CompletionHelper.getCommonStartStr(this.completionOptionList, string2);
            return true;
        }
        if (this.completionOptionList.size() < 1) {
            return false;
        }
        return false;
    }

    protected boolean completeRootMoName(String string, String string2) {
        Log.trace(MoAddressCompleter.class, ".completeRootMoName(), aStringToComplete='" + string2 + "'");
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.lastIndexOf("=");
        int n2 = string.lastIndexOf(",");
        if (n == -1 || n2 > -1) {
            return false;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (!this.nodeServices.getRootMo().getType().equalsIgnoreCase(string3)) {
            return false;
        }
        if (string4.length() == 0) {
            this.completedString = this.nodeServices.getRootMo().getType().concat("=").concat(this.nodeServices.getRootMo().getName());
            this.completionOptionList.clear();
            return true;
        }
        if (this.nodeServices.getRootMo().getName().equalsIgnoreCase(string4)) {
            this.completedString = this.nodeServices.getRootMo().getType().concat("=").concat(this.nodeServices.getRootMo().getName());
            this.completedString = this.completedString.concat(",");
            CompletionHelper.putMatchingRdnInList("", this.nodeServices.getRootMo().getChildren(this.nodeServices.getTransactionHandler().getNullTransaction()), this.completionOptionList);
            return true;
        }
        return false;
    }
}

