/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs;

import java.security.Principal;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.ncli.server.command.history.CommandHistory;
import se.ericsson.cello.ncli.server.command.history.CommandHistoryImpl;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroupHandlerFactory;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroupHandling;
import se.ericsson.cello.ncli.server.configuration.ConfigurationReader;
import se.ericsson.cello.ncli.server.cs.MoAddressResolver;
import se.ericsson.cello.ncli.server.cs.MoAddressResolverImpl;
import se.ericsson.cello.ncli.server.cs.NodeFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.transaction.HardTransactionHandling;
import se.ericsson.cello.ncli.server.cs.transaction.TransactionHandling;
import se.ericsson.cello.ncli.server.cs.transaction.TransactionHandlingFactory;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.exceptions.ReadMomErrorException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.security.CSUPrincipalImpl;
import se.ericsson.cello.ncli.server.services.MemoryChecking;
import se.ericsson.cello.ncli.server.services.NCLIServices;
import se.ericsson.cello.neal.CppOamException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.security.corba.Current;

public class NodeServicesImpl
implements NodeServices {
    private Node node;
    private CmService cm;
    private MoGroupHandling moGroupHandler = MoGroupHandlerFactory.createMoGroupHandler();
    private CommandHistory commandHistory = new CommandHistoryImpl(20);
    private Mo previousWorkingMo;
    private MoAddressResolver addressResolver;
    private HardTransactionHandling txHandler = null;
    private Mo workingMo;

    public void init(String string, String string2) throws NcliException {
        try {
            this.initNealConnection(string, string2);
            this.initCs();
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, "");
        }
        this.initMimModel();
        Log.trace(NodeServicesImpl.class, "init done");
    }

    public void init() throws NcliException {
        this.init(null, null);
    }

    private void initNealConnection(String string, String string2) throws NcliException {
        if (string != null) {
            Log.trace(NodeServicesImpl.class, "initNealConnection(" + string + ")");
        } else {
            Log.trace(NodeServicesImpl.class, "initNealConnection(<no user>)");
        }
        if (CelloOrb.instance().securityActivated()) {
            Log.trace(NodeServicesImpl.class, "Security activated");
            Current current = CelloOrb.instance().getCurrent();
            Principal principal = current.getActingPrincipal();
            Log.trace(NodeServicesImpl.class, "Acting principal: " + principal.getName());
            if (string == null) {
                current.setDelegatedPrincipal(principal);
            } else {
                CSUPrincipalImpl cSUPrincipalImpl = new CSUPrincipalImpl(principal.getName(), string);
                current.setDelegatedPrincipal((Principal)((Object)cSUPrincipalImpl));
            }
            Log.trace(NodeServicesImpl.class, "Verifying delegated principal: " + current.getDelegatedPrincipal().getName());
            if (string2 != null) {
                Log.trace(NodeServicesImpl.class, "Setting audit identity " + string2);
                current.setAIC(string2);
            }
        }
        try {
            this.node = NodeFactory.createNode(this);
        }
        catch (CppOamException cppOamException) {
            throw ExceptionHandler.map(cppOamException, "Was not able to get a node reference.");
        }
        catch (NodeException nodeException) {
            Log.trace(NodeServicesImpl.class, "Could not get node reference", (Exception)((Object)nodeException));
            throw ExceptionHandler.map((Exception)((Object)nodeException), "Was not able to connect.");
        }
        if (this.node == null) {
            Log.trace(NodeServicesImpl.class, "node reference is null");
            throw new NcliException("Could not get connection to OAM services.");
        }
        Log.trace(NodeServicesImpl.class, "initNealConnection() done");
    }

    private void initCs() throws NcliException {
        Log.trace(NodeServicesImpl.class, "initCS()");
        this.setCm(this.node.getCmService());
        this.setWorkingMo(this.getRootMo());
        this.setPreviousWorkingMo(this.getRootMo());
        this.addressResolver = new MoAddressResolverImpl(this);
        this.txHandler = TransactionHandlingFactory.getHardTransactionHandler(this.cm);
        Log.trace(NodeServicesImpl.class, "end initCS");
    }

    public Mo getRootMo() {
        return this.getCm().getRootMo();
    }

    public CmService getCm() {
        return this.cm;
    }

    public FmService getFm() {
        return this.node.getFmService();
    }

    private void setCm(CmService cmService) {
        this.cm = cmService;
    }

    public Mo getWorkingMo() {
        return this.workingMo;
    }

    public void setWorkingMo(Mo mo) {
        this.setPreviousWorkingMo(this.workingMo);
        this.workingMo = mo;
    }

    public Mo getPreviousWorkingMo() {
        return this.previousWorkingMo;
    }

    public void setPreviousWorkingMo(Mo mo) {
        this.previousWorkingMo = mo;
    }

    public MoAddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void initMimModel() {
        try {
            this.getMimModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MimModel getMimModel() throws MomAwarenessNotSupportedException, MemoryNotSufficientException, ReadMomErrorException {
        return NCLIServices.getMimModel();
    }

    public MemoryChecking getMemoryChecker() {
        return NCLIServices.getMemoryChecker();
    }

    public MoGroupHandling getMoGroupHandler() {
        return this.moGroupHandler;
    }

    public CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    public TransactionHandling getTransactionHandler() {
        return this.txHandler;
    }

    public ConfigurationReader getConfiguration() {
        return NCLIServices.getConfigurationReader();
    }

    public void setCommandHistory(CommandHistory commandHistory) {
        this.commandHistory = commandHistory;
    }

    public HardTransactionHandling getHardTransactionHandler() {
        return this.txHandler;
    }
}

