/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.mom;

import java.util.Iterator;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.exceptions.ResolveFailureException;
import se.ericsson.cello.ncli.server.logging.Log;

public class MomEntityResolver {
    MimModel mimModel = null;
    MomEntity reqEntity = null;
    MomClass workingMoClass = null;

    public MomEntityResolver(NodeServices nodeServices) throws MomAwarenessNotSupportedException {
        try {
            this.mimModel = nodeServices.getMimModel();
            this.workingMoClass = this.mimModel.getClass(nodeServices.getWorkingMo().getType());
        }
        catch (Exception exception) {
            throw new MomAwarenessNotSupportedException(exception.getMessage());
        }
    }

    public MomEntity getMomEntity(String string) throws ResolveFailureException {
        Log.trace(MomEntityResolver.class, "getMomEntity(" + string + ")");
        this.reqEntity = null;
        if (this.isClass(string)) {
            return this.reqEntity;
        }
        if (this.isAttribute(string)) {
            return this.reqEntity;
        }
        if (this.isAction(string)) {
            return this.reqEntity;
        }
        if (this.isEnum(string)) {
            return this.reqEntity;
        }
        if (this.isStruct(string)) {
            return this.reqEntity;
        }
        throw new ResolveFailureException("Entity " + string + " not found");
    }

    public boolean isStruct(String string) {
        Iterator iterator = this.mimModel.getStructs();
        MomStruct momStruct = null;
        while (iterator.hasNext()) {
            momStruct = (MomStruct)iterator.next();
            if (!momStruct.getName().equalsIgnoreCase(string)) continue;
            this.reqEntity = momStruct;
            return true;
        }
        return false;
    }

    public boolean isEnum(String string) {
        Iterator iterator = this.mimModel.getEnums();
        MomEnum momEnum = null;
        while (iterator.hasNext()) {
            momEnum = (MomEnum)iterator.next();
            if (!momEnum.getName().equalsIgnoreCase(string)) continue;
            this.reqEntity = momEnum;
            return true;
        }
        return false;
    }

    boolean isAction(String string) {
        Iterator iterator = this.workingMoClass.getActions();
        MomAction momAction = null;
        while (iterator.hasNext()) {
            momAction = (MomAction)iterator.next();
            if (!momAction.getName().equalsIgnoreCase(string)) continue;
            this.reqEntity = momAction;
            return true;
        }
        return false;
    }

    boolean isAttribute(String string) {
        Iterator iterator = this.workingMoClass.getAttributes();
        MomAttribute momAttribute = null;
        while (iterator.hasNext()) {
            momAttribute = (MomAttribute)iterator.next();
            if (!momAttribute.getName().equalsIgnoreCase(string)) continue;
            this.reqEntity = momAttribute;
            return true;
        }
        return false;
    }

    public boolean isClass(String string) {
        Iterator iterator = this.mimModel.getClasses();
        MomClass momClass = null;
        while (iterator.hasNext()) {
            momClass = (MomClass)iterator.next();
            if (!momClass.getName().equalsIgnoreCase(string)) continue;
            this.reqEntity = momClass;
            return true;
        }
        return false;
    }

    public void setWorkingMoClass(MomClass momClass) {
        this.workingMoClass = momClass;
    }
}

