/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.CollectorMoNotFoundException;
import se.ericsson.cello.aueframework.collector.DataWriter;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.DataCollectorMoConstants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class DataCollectorMoDataWriter2
implements DataWriter,
DataCollectorMoConstants {
    private String identity = null;
    private ManagedObject mo = null;

    public DataCollectorMoDataWriter2(String string) {
        this.identity = string;
    }

    public void writeData(Attribute attribute, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        if (this.mo == null || this.mo.isRemoved()) {
            this.mo = this.findMo(collectorContext);
            if (this.mo == null) {
                throw new CollectorMoNotFoundException(this.identity);
            }
        }
        try {
            this.mo.setAttribute("data", (Object)attribute, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to add data to MO", moAccessException);
        }
    }

    private ManagedObject findMo(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("DataCollector");
        if (moIterator == null) {
            return null;
        }
        ManagedObject managedObject = null;
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getNamingAttributeValue().equals(this.identity)) continue;
            return managedObject;
        }
        return null;
    }
}

