/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.DataCollectorMo;
import se.ericsson.cello.aueframework.common.DataCollectorMoConstants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class DataCollectorMoImpl
extends ManagedObjectBase
implements DataCollectorMoConstants,
DataCollectorMo {
    private MoData modata = null;

    public DataCollectorMoImpl(ManagedObject managedObject, String string, Coordinator coordinator) throws MoNameAlreadyTakenException, TransactionRequiredException {
        super(managedObject, "DataCollector", string, coordinator);
        this.modata = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
    }

    public DataCollectorMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.modata = moData;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.modata.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        super.delete(coordinator);
        if (this.modata != null) {
            this.modata.delete(coordinator);
        }
    }

    public void setData(Attribute attribute, Coordinator coordinator) throws MoAccessException {
        String string = attribute.getName();
        if (this.modata.getAttribute(string) != null) {
            MessageLog.info(this.getClass(), (String)("Key " + string + " already exists, data will be overwritten."));
            this.modata.deregisterAttribute(string);
        }
        this.modata.registerPersistentAttr(attribute);
        this.modata.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public String getType() {
        return "DataCollector";
    }
}

