/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.UnsupportedMoTypeException;
import se.ericsson.cello.aueframework.converter.WrongMoDataRevisionException;

public class Assertions {
    public static void assertMoType(MoDataWrapper moDataWrapper, String string) throws UnsupportedMoTypeException {
        if (!string.equals(moDataWrapper.getMoTypeName())) {
            throw new UnsupportedMoTypeException(moDataWrapper.getMoTypeName(), string);
        }
    }

    public static void assertMoType(MoDataWrapper moDataWrapper, String[] stringArray) throws UnsupportedMoTypeException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(moDataWrapper.getMoTypeName())) continue;
            return;
        }
        throw new UnsupportedMoTypeException(moDataWrapper.getMoTypeName(), Assertions.makeString(stringArray));
    }

    public static void assertMoDataRevision(MoDataWrapper moDataWrapper, int n) throws WrongMoDataRevisionException {
        if (moDataWrapper.getRevision() != n) {
            throw new WrongMoDataRevisionException(moDataWrapper, n);
        }
    }

    public static void assertMoDataRevision(MoDataWrapper moDataWrapper, String string, int n) throws UnsupportedMoTypeException, WrongMoDataRevisionException {
        Assertions.assertMoType(moDataWrapper, string);
        Assertions.assertMoDataRevision(moDataWrapper, n);
    }

    private static String makeString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

