/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.RevisionReader;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.UpgradeHandler;
import se.ericsson.cello.aueframework.converter.UpgradePath;
import se.ericsson.cello.aueframework.converter.UpgradePathCalculator;

public class ConversionStepUpgradeHandler
implements UpgradeHandler {
    private UpgradePathCalculator calculator;
    private RevisionReader fromReader;
    private RevisionReader toReader;
    public static final String FROM_REVISION_KEY = "se.ericsson.cello.aueframework.converter.ConversionStepUpgradeHandler.FROM_REVISION_KEY";
    public static final String TO_REVISION_KEY = "se.ericsson.cello.aueframework.converter.ConversionStepUpgradeHandler.TO_REVISION_KEY";

    public ConversionStepUpgradeHandler(UpgradePathCalculator upgradePathCalculator, RevisionReader revisionReader, RevisionReader revisionReader2) {
        this.calculator = upgradePathCalculator;
        this.fromReader = revisionReader;
        this.toReader = revisionReader2;
    }

    public void upgrade(ConverterContext converterContext) throws AueException {
        String string = this.readRevision(this.fromReader, converterContext);
        converterContext.setAttribute(FROM_REVISION_KEY, string);
        String string2 = this.readRevision(this.toReader, converterContext);
        converterContext.setAttribute(TO_REVISION_KEY, string2);
        UpgradePath upgradePath = this.calculator.findUpgradePath(string, string2, converterContext);
        upgradePath.execute(converterContext);
    }

    private String readRevision(RevisionReader revisionReader, ConverterContext converterContext) throws AueException {
        TransactionWrapper transactionWrapper = converterContext.getTransactionWrapperFactory().create();
        String string = revisionReader.readRevision(transactionWrapper.getCoordinator());
        transactionWrapper.commit();
        return string;
    }
}

