/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataModifier;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.MoData;

public class MoDataModifierImpl
implements MoDataModifier {
    private String moTypeName = null;
    private int fromRevision = 0;
    private int toRevision = 0;
    private Collection actions = null;

    public MoDataModifierImpl() {
    }

    public MoDataModifierImpl(String string, int n, int n2) {
        this.setup(string, n, n2);
    }

    public void setup(String string, int n, int n2) {
        this.moTypeName = string;
        this.fromRevision = n;
        this.toRevision = n2;
        this.actions = new LinkedList();
    }

    public void add(MoDataAction moDataAction) {
        this.actions.add(moDataAction);
    }

    public void execute(ConverterContext converterContext) throws AueException {
        Iterator iterator = converterContext.getMoDataAccessor().getByType(this.moTypeName).iterator();
        MoDataWrapper moDataWrapper = null;
        MoDataAction moDataAction = null;
        TransactionWrapper transactionWrapper = null;
        while (iterator.hasNext()) {
            moDataWrapper = (MoDataWrapper)iterator.next();
            if (moDataWrapper.getRevision() != this.fromRevision) continue;
            transactionWrapper = converterContext.getTransactionWrapperFactory().create();
            Iterator iterator2 = this.actions.iterator();
            while (iterator2.hasNext()) {
                moDataAction = (MoDataAction)iterator2.next();
                moDataAction.perform(moDataWrapper, converterContext, transactionWrapper.getCoordinator());
            }
            moDataWrapper.setRevision(this.toRevision);
            moDataWrapper.handleTransaction(transactionWrapper.getCoordinator(), MoData.WRITE_ACCESS);
            transactionWrapper.commit();
        }
    }
}

