/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.ReferenceUtilities;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class ReferenceUtilitiesImpl
implements ReferenceUtilities {
    static /* synthetic */ Class class$se$ericsson$cello$moframework$ReferenceAttribute;
    static /* synthetic */ Class class$se$ericsson$cello$moframework$SequenceAttribute;

    public void updateReferences(String string, String string2, String string3, String string4, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper = null;
        Attribute attribute = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Iterator iterator = moDataAccessor.getByType(string3).iterator();
        while (iterator.hasNext()) {
            moDataWrapper = (MoDataWrapper)iterator.next();
            attribute = moDataWrapper.getAttribute(string4);
            if (attribute == null) {
                throw new AueException("Attribute " + string3 + "#" + string4 + " doesn't exist.");
            }
            if (attribute.getClass().equals(class$se$ericsson$cello$moframework$ReferenceAttribute == null ? ReferenceUtilitiesImpl.class$("se.ericsson.cello.moframework.ReferenceAttribute") : class$se$ericsson$cello$moframework$ReferenceAttribute)) {
                this.handleReferenceAttribute((ReferenceAttribute)attribute, moDataWrapper, string, string2, converterContext, coordinator);
                continue;
            }
            if (attribute.getClass().equals(class$se$ericsson$cello$moframework$SequenceAttribute == null ? ReferenceUtilitiesImpl.class$("se.ericsson.cello.moframework.SequenceAttribute") : class$se$ericsson$cello$moframework$SequenceAttribute)) {
                this.handleSequenceAttribute((SequenceAttribute)attribute, moDataWrapper, string, string2, converterContext, coordinator);
                continue;
            }
            throw new AueException("Invalid attribute type: " + attribute.getClass().getName());
        }
    }

    void handleReferenceAttribute(ReferenceAttribute referenceAttribute, MoDataWrapper moDataWrapper, String string, String string2, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        String string3 = referenceAttribute.getReferenceAsLDN();
        if (string3 != null && string3.equals(string)) {
            moDataWrapper.deregisterAttribute((Attribute)referenceAttribute);
            moDataWrapper.registerPersistentAttr((Attribute)new ReferenceAttribute(referenceAttribute.getName(), string2, referenceAttribute.isAVCNotifier()));
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
    }

    void handleSequenceAttribute(SequenceAttribute sequenceAttribute, MoDataWrapper moDataWrapper, String string, String string2, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        Attribute[] attributeArray = sequenceAttribute.getValue(null);
        String string3 = null;
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].getClass().equals(class$se$ericsson$cello$moframework$ReferenceAttribute == null ? ReferenceUtilitiesImpl.class$("se.ericsson.cello.moframework.ReferenceAttribute") : class$se$ericsson$cello$moframework$ReferenceAttribute)) {
                throw new AueException("Invalid attribute type in sequence: " + attributeArray[i].getClass().getName());
            }
            string3 = ((ReferenceAttribute)attributeArray[i]).getReferenceAsLDN();
            if (!string3.equals(string)) continue;
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            sequenceAttribute.removeElement(attributeArray[i]);
            if (string2 == null) break;
            sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string2, false));
            break;
        }
    }

    public void removeReferences(String string, String string2, String string3, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        this.updateReferences(string, null, string2, string3, converterContext, coordinator);
    }

    public MoDataWrapper changeParents(MoDataWrapper moDataWrapper, String string, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        String string2 = moDataWrapper.getLocalDistinguishedName();
        String string3 = string2.substring(0, string2.lastIndexOf(","));
        return this.changeAncestors(moDataWrapper, string3, string, converterContext, coordinator);
    }

    public MoDataWrapper changeAncestors(MoDataWrapper moDataWrapper, String string, String string2, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper2 = null;
        if (string.equals(string2)) {
            moDataWrapper2 = moDataWrapper;
        } else {
            String string3 = moDataWrapper.getLocalDistinguishedName();
            String string4 = string3.substring(string.length());
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            moDataWrapper2 = moDataAccessor.create(string2 + string4, coordinator);
            this.copyAllAttributes(moDataWrapper, moDataWrapper2);
            moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            moDataWrapper2.setRevision(moDataWrapper.getRevision());
            moDataAccessor.delete(moDataWrapper, coordinator);
        }
        return moDataWrapper2;
    }

    private void copyAllAttributes(MoDataWrapper moDataWrapper, MoDataWrapper moDataWrapper2) {
        Enumeration enumeration = moDataWrapper.getAllPersistentAttributes();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                moDataWrapper2.registerPersistentAttr(attribute);
            }
        }
    }
}

