/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.emas.sm.applications.ConfigurationVersionRestartView;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.mgr.cellomom.RestartRank;
import se.ericsson.cello.support.mgr.cellomom.RestartReason;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class ConfigurationVersionRestartController
extends AbstractApplicationController
implements ActionListener {
    private ConfigurationVersionRestartView view;
    private MOProxy cvMO;
    String selectedCV;
    private boolean error = false;
    private Transaction tid = null;

    public void init() {
        this.view = (ConfigurationVersionRestartView)this.getView();
        this.getApplication().setTitle("RESTART_NODE_TITLE", null);
        this.selectedCV = this.getParameter("CV_NAME") != null ? (String)this.getParameter("CV_NAME") : (String)this.getParameter("PARAM1");
        this.cvMO = (String)this.getParameter("LDNLIST") != null ? new MOProxy((String)this.getParameter("LDNLIST")) : new MOProxy((String)this.getParameter("PARAM2"));
        try {
            this.tid = new Transaction();
            this.view.type.setActionListener((ActionListener)this, "TYPE");
            this.view.type.setValue("WARM");
            this.view.okButton.setActionListener((ActionListener)this, "OK");
            this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
            this.tid.commit();
            this.tid.end();
        }
        catch (CSException e) {
            this.error = true;
            try {
                this.tid.rollback();
                this.tid.end();
            }
            catch (CSException ce) {
                Log.logError((String)"Unable to rollback transaction", (Throwable)ce);
            }
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
        }
        catch (SyntaxException se) {
            Log.logError((String)"Unable to set default value in view", (Throwable)se);
        }
    }

    protected void afterVisible() {
        if (this.error) {
            this.getApplication().stopApplication();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("OK")) {
            if (this.restartnode()) {
                this.getApplication().stopApplication();
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.getApplication().stopApplication();
        } else {
            Log.trace((String)(this.getClass().getName() + "wrong event: " + event.getActionCommand()));
        }
    }

    private boolean checkValues() {
        return true;
    }

    public boolean canStop() {
        return true;
    }

    private boolean restartnode() {
        Transaction tid = null;
        String result = this.view.type.getValue();
        boolean successful = true;
        try {
            tid = new Transaction();
            NameValue[] startArg = new NameValue[]{new NameValue("configurationVersionName", (Object)this.selectedCV)};
            this.cvMO.action("setStartable", startArg, tid.session);
            MOProxy rootMO = MOProxy.getRoot();
            NameValue[] args = new NameValue[3];
            if (result.equals("WARM")) {
                args[0] = new NameValue("restartRank", (Object)RestartRank.RESTART_WARM.toInteger());
            } else if (result.equals("REFRESH")) {
                args[0] = new NameValue("restartRank", (Object)RestartRank.RESTART_REFRESH.toInteger());
            } else if (result.equals("COLD")) {
                args[0] = new NameValue("restartRank", (Object)RestartRank.RESTART_COLD.toInteger());
            } else if (result.equals("COLDWTEST")) {
                args[0] = new NameValue("restartRank", (Object)RestartRank.RESTART_COLDWTEST.toInteger());
            }
            args[1] = new NameValue("restartReason", (Object)RestartReason.PLANNED_RECONFIGURATION.toInteger());
            args[2] = new NameValue("restartInfo", (Object)new String("Restart made from EMAS Software Manager"));
            rootMO.action("manualRestart", args, tid.session);
            tid.commit();
            tid.end();
        }
        catch (CSException e) {
            try {
                tid.rollback();
                tid.end();
            }
            catch (Exception be) {
                Log.logError((String)"Unable to rollback transaction", (Throwable)be);
            }
            this.reportException((Exception)((Object)e), "ERROR_BOARD_RESTART", null);
            successful = false;
        }
        return successful;
    }
}

