/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.emas.sm.applications.EmergencyStatePropertiesView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.cellomom.EmergencyStatus;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;
import se.ericsson.cello.support.proxy.Transaction;

public class EmergencyStatePropertiesController
extends AbstractApplicationController
implements ActionListener {
    private EmergencyStatePropertiesView view;
    private MOProxy licenseMo;
    private AttributeBuffer attributeCache;
    private static final String[] licenseMoAttributes = new String[]{"guiName", "emergencyStateInfo"};
    private static final NameValue[] NO_ARGS = new NameValue[0];

    public void init() {
        this.view = (EmergencyStatePropertiesView)this.getView();
        this.setButtonListeners();
        this.getApplication().setTitle("EMERGENCY_STATE_PROPERTIES", null);
        try {
            this.licenseMo = MOProxy.getRoot().getChildren(2, "Licensing", "")[0];
        }
        catch (CSException be) {
            Log.logError((String)"Error in getting the license proxy", (Throwable)be);
        }
        this.view.closeButton.setEnabled(true);
        this.readAndShowMoAttributes(true);
    }

    protected boolean canStop() {
        return true;
    }

    private void setButtonListeners() {
        this.view.closeButton.setActionListener((ActionListener)this, "CLOSE");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("CLOSE")) {
            this.getApplication().stopApplication();
        }
    }

    public void setButtonStatus() {
        this.view.closeButton.setEnabled(true);
    }

    protected boolean readAndShowMoAttributes(boolean useTransaction) {
        boolean isReadSuccessful = this.readMoAttributes(useTransaction);
        if (isReadSuccessful) {
            this.showMoAttributes();
        }
        return isReadSuccessful;
    }

    protected boolean readMoAttributes(boolean useTransaction) {
        Log.trace((String)("readMoAttributes(" + useTransaction + ")"));
        Transaction readTransaction = null;
        try {
            Object[] moValues = null;
            if (useTransaction) {
                readTransaction = new Transaction();
                moValues = this.licenseMo.getAttributes(licenseMoAttributes, readTransaction.session);
                readTransaction.commit();
                readTransaction.end();
            }
            this.attributeCache = new AttributeBuffer(licenseMoAttributes, moValues);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            try {
                readTransaction.rollback();
            }
            catch (CSException be) {
                Log.logError((String)"Error with a transaction", (Throwable)be);
            }
            return false;
        }
        return true;
    }

    protected void showMoAttributes() {
        Log.trace((String)"showMoAttributes()");
        if (this.attributeCache == null) {
            throw new IllegalStateException("attributeCache == null");
        }
        try {
            EmergencyStatus emergencyStatus = EmergencyStatus.get((Object)((Integer)((Struct)this.attributeCache.get((Object)"emergencyStateInfo")).getElementValue("state")));
            this.view.emergencyState.setValue(emergencyStatus.toString());
            this.view.timeLeft.setValue(((Integer)((Struct)this.attributeCache.get((Object)"emergencyStateInfo")).getElementValue("time")).toString());
        }
        catch (NoSuchFieldException e) {
            Log.logError((String)"No such field found", (Throwable)e);
        }
    }
}

