/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import javax.swing.Action;
import javax.swing.ImageIcon;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.mgr.cellomom.UpgradePackageState;
import se.ericsson.cello.support.mgr.cellomom.UpgradeProgressInformation;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class UpgradePackageElement
extends EmasViewElement {
    private String fileName;
    private UpgradePackageState state;
    private UpgradeProgressInformation progressInfo;
    private String administrativeData_productNumber;
    private String administrativeData_productRevision;
    private String productID;
    private String releaseDate;
    private MOProxy upgradePackage;
    private MOProxy parent;
    private String userLabel;
    private ImageIcon iconNotInstalled = null;
    private ImageIcon iconInstallExecuting = null;
    private ImageIcon iconInstallNotCompleted = null;
    private ImageIcon iconInstallCompleted = null;
    private ImageIcon iconUpgradeExecuting = null;
    private ImageIcon iconAwaitingConfirm = null;
    private ImageIcon iconUpgradeCompleted = null;
    private ImageIcon iconOnlyDeletable = null;
    private MOProxy cvMO;
    private boolean active = false;
    private boolean rebootNodeUpgradeAllowed = false;
    private boolean updateAllowed = false;
    private boolean upgradeAllowed = false;

    public UpgradePackageElement(MOComposite aMoc, Properties aProperties, EmasViewElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, aCreator);
        this.upgradePackage = aMoc.getMO("UpgradePackage");
        this.parent = this.upgradePackage.getParent();
        try {
            this.cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "", null)[0];
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_GET", null);
            Log.logError((String)"Error getting the ConfigurationVersion MO", (Throwable)e);
        }
        this.cvMO.addMOListener((MOProxy.MOListener)this);
        String iconFileNotInstalled = this.getProperty("icon.notinstalled");
        String iconFileIntallExecuting = this.getProperty("icon.intallexecuting");
        String iconFileInstallNotCompleted = this.getProperty("icon.installnotcompleted");
        String iconFileInstallCompleted = this.getProperty("icon.installcompleted");
        String iconFileUpgradeExecuting = this.getProperty("icon.upgradeexecuting");
        String iconFileAwaitingConfirm = this.getProperty("icon.awaitingconfirm");
        String iconFileUpgradeCompleted = this.getProperty("icon.upgradecompleted");
        String iconFileOnlyDeletable = this.getProperty("icon.onlydeletable");
        try {
            this.iconNotInstalled = (ImageIcon)IconHelper.createIcon((String)iconFileNotInstalled);
            this.iconInstallExecuting = (ImageIcon)IconHelper.createIcon((String)iconFileIntallExecuting);
            this.iconInstallNotCompleted = (ImageIcon)IconHelper.createIcon((String)iconFileInstallNotCompleted);
            this.iconInstallCompleted = (ImageIcon)IconHelper.createIcon((String)iconFileInstallCompleted);
            this.iconUpgradeExecuting = (ImageIcon)IconHelper.createIcon((String)iconFileUpgradeExecuting);
            this.iconAwaitingConfirm = (ImageIcon)IconHelper.createIcon((String)iconFileAwaitingConfirm);
            this.iconUpgradeCompleted = (ImageIcon)IconHelper.createIcon((String)iconFileUpgradeCompleted);
            this.iconOnlyDeletable = (ImageIcon)IconHelper.createIcon((String)iconFileOnlyDeletable);
        }
        catch (Exception e) {
            Log.logError((String)"Error creating ImageIcons from file.", (Throwable)e);
        }
        this.refreshData();
    }

    public Action[] getActions() {
        Action[] actions = super.getActions();
        try {
            Integer upState = (Integer)this.upgradePackage.getAttribute("state", null);
            this.state = UpgradePackageState.get((Object)upState);
            try {
                Struct supportedUpgradeType = (Struct)this.upgradePackage.action("readSupportedUpgradeTypesStatus", new NameValue[0], null);
                this.rebootNodeUpgradeAllowed = (Boolean)supportedUpgradeType.getElementValue("rebootNodeUpgrade");
                this.updateAllowed = (Boolean)supportedUpgradeType.getElementValue("update");
                this.upgradeAllowed = (Boolean)supportedUpgradeType.getElementValue("upgrade");
            }
            catch (NoSuchFieldException e) {
                Log.logError((String)"Error reading attribute. ", (Throwable)e);
                this.reportException(e, "", null);
            }
            catch (CSException ex) {
                this.rebootNodeUpgradeAllowed = true;
                this.updateAllowed = true;
                this.upgradeAllowed = true;
            }
        }
        catch (CSException ex) {
            Log.logError((String)"Error retrieving state", (Throwable)ex);
        }
        for (int i = 0; i < actions.length; ++i) {
            String actionName = (String)actions[i].getValue("Name");
            boolean actionEnabled = true;
            if (actionName.equals("UP_DELETE_MNU")) {
                actionEnabled = this.progressInfo != UpgradeProgressInformation.DOWNLOADING_FILES && !this.state.equals(UpgradePackageState.UPGRADE_EXECUTING) && !this.state.equals(UpgradePackageState.AWAITING_CONFIRMATION) || this.state.equals(UpgradePackageState.ONLY_DELETEABLE);
            } else if (actionName.equals("UP_UPGRADE_MNU")) {
                actionEnabled = !(!this.state.equals(UpgradePackageState.INSTALL_COMPLETED) && !this.state.equals(UpgradePackageState.UPGRADE_COMPLETED) || !this.rebootNodeUpgradeAllowed && !this.upgradeAllowed);
            } else if (actionName.equals("UP_UPDATE_MNU")) {
                actionEnabled = (this.state.equals(UpgradePackageState.INSTALL_COMPLETED) || this.state.equals(UpgradePackageState.UPGRADE_COMPLETED)) && this.updateAllowed;
            } else if (actionName.equals("UP_CONFIRM_MNU")) {
                actionEnabled = this.state.equals(UpgradePackageState.AWAITING_CONFIRMATION);
            } else if (actionName.equals("UP_INSTALL_MNU")) {
                actionEnabled = this.state.equals(UpgradePackageState.NOT_INSTALLED) || this.state.equals(UpgradePackageState.UPGRADE_COMPLETED) || this.state.equals(UpgradePackageState.INSTALL_NOT_COMPLETED) || this.state.equals(UpgradePackageState.INSTALL_COMPLETED);
            }
            actions[i].setEnabled(actionEnabled);
        }
        return actions;
    }

    public String getName() {
        return this.upgradePackage.getLastRDN();
    }

    private String getFileName() {
        String name = "";
        if (this.fileName.length() > 0) {
            int pos = this.fileName.lastIndexOf("/");
            name = pos != -1 ? this.fileName.substring(pos + 1) : this.fileName;
        }
        return name;
    }

    public Object getAttributeValue(String aName) {
        String value = null;
        if (aName.equals("ATTR_STATE")) {
            value = this.translate(this.state.toString());
        } else if (aName.equals("ATTR_FILENAME")) {
            value = this.getFileName();
        } else if (aName.equals("ATTR_ADMINISTRATIVEDATA_PRODUCT_NUMBER")) {
            value = this.administrativeData_productNumber;
        } else if (aName.equals("ATTR_ADMINISTRATIVEDATA_PRODUCT_REVISION")) {
            value = this.administrativeData_productRevision;
        } else if (aName.equals("ATTR_PRODUCT_ID")) {
            value = this.productID;
        } else if (aName.equals("ATTR_RELEASE_DATE")) {
            value = this.releaseDate;
        } else if (aName.equals("ATTR_ACTIVE_UPGRADEPACKAGE")) {
            value = "";
            if (this.active) {
                value = this.translate("UP_ACTIVE_YES");
            }
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        MOProxy currentUpgradePackage = null;
        try {
            String[] moAttributes = new String[]{"upgradeControlFilePath", "state", "administrativeData", "userLabel"};
            Object[] moValues = null;
            moValues = this.upgradePackage.getAttributes(moAttributes, null);
            AttributeBuffer bufferValues = new AttributeBuffer(moAttributes, moValues);
            this.fileName = (String)bufferValues.getAttribute("upgradeControlFilePath");
            Integer upState = (Integer)bufferValues.getAttribute("state");
            this.state = UpgradePackageState.get((Object)upState);
            Struct data = (Struct)bufferValues.getAttribute("administrativeData");
            this.administrativeData_productNumber = (String)data.getElementValue("productNumber");
            String myDate = (String)data.getElementValue("productionDate");
            this.releaseDate = new TimeConverter().formatTime(myDate);
            this.administrativeData_productRevision = (String)data.getElementValue("productRevision");
            this.productID = (String)data.getElementValue("productName");
            this.userLabel = (String)bufferValues.getAttribute("userLabel");
            currentUpgradePackage = (MOProxy)this.cvMO.getAttribute("currentUpgradePackage", null);
            this.active = false;
            if (currentUpgradePackage.equals((Object)this.upgradePackage)) {
                this.active = true;
            }
        }
        catch (CSException e) {
            Log.logError((String)"refreshData failed");
            throw e;
        }
        catch (NoSuchFieldException fieldEx) {
            Log.logError((String)"refreshData failed");
            throw new CSException("refreshData failed", (Exception)fieldEx, fieldEx.getMessage());
        }
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e1) {
            Log.logError((String)"refresh failed", (Throwable)e1);
        }
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        Object iconFile = null;
        if (this.state == UpgradePackageState.AWAITING_CONFIRMATION) {
            icon = this.iconAwaitingConfirm;
        } else if (this.state == UpgradePackageState.UPGRADE_EXECUTING) {
            icon = this.iconUpgradeExecuting;
        } else if (this.state == UpgradePackageState.UPGRADE_COMPLETED) {
            icon = this.iconUpgradeCompleted;
        } else if (this.state == UpgradePackageState.INSTALL_COMPLETED) {
            icon = this.iconInstallCompleted;
        } else if (this.state == UpgradePackageState.NOT_INSTALLED) {
            icon = this.iconNotInstalled;
        } else if (this.state == UpgradePackageState.INSTALL_EXECUTING) {
            icon = this.iconInstallExecuting;
        } else if (this.state == UpgradePackageState.INSTALL_NOT_COMPLETED) {
            icon = this.iconInstallNotCompleted;
        } else if (this.state == UpgradePackageState.ONLY_DELETEABLE) {
            icon = this.iconOnlyDeletable;
        }
        return icon;
    }

    public void attributesChanged(MOProxy aMO, NameValue[] nameValue) {
        for (int i = 0; i < nameValue.length; ++i) {
            if (nameValue[i].name.equals("state")) {
                Integer upState = (Integer)nameValue[i].value;
                this.state = UpgradePackageState.get((Object)upState);
                this.fireViewElementUpdated();
                continue;
            }
            if (nameValue[i].name.equals("userLabel")) {
                this.userLabel = (String)nameValue[i].value;
                this.fireViewElementUpdated();
                continue;
            }
            if (nameValue[i].name.equals("progressHeader")) {
                this.progressInfo = UpgradeProgressInformation.get((Object)nameValue[i].value);
                continue;
            }
            if (!nameValue[i].name.equals("currentUpgradePackage")) continue;
            this.active = false;
            if (nameValue[i].value.equals(this.upgradePackage)) {
                this.active = true;
                this.fireViewElementUpdated();
            }
            this.fireViewElementUpdated();
        }
    }
}

