/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.services;

import java.util.Hashtable;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class SubrackNameFactory
implements MOProxy.MOListener {
    private static SubrackNameFactory instance = null;
    private Hashtable subracks = new Hashtable();

    private SubrackNameFactory() {
    }

    public static SubrackNameFactory getInstance() {
        if (instance == null) {
            instance = new SubrackNameFactory();
        }
        return instance;
    }

    private void addSubrack(MOProxy subrack) {
        String[] attributes = new String[]{"cabinetPosition", "subrackPosition"};
        try {
            Object[] values = subrack.getAttributes(attributes, null);
            AttributeBuffer buffer = new AttributeBuffer(attributes, values);
            String subrackName = (String)buffer.getAttribute("cabinetPosition");
            subrackName = subrackName + (String)buffer.getAttribute("subrackPosition");
            if (subrackName.length() > 0) {
                subrackName = subrackName + ":";
            }
            subrackName = subrackName + subrack.getId();
            if (!this.subracks.containsKey(subrack)) {
                subrack.addMOListener((MOProxy.MOListener)this);
                subrack.getParent().addMOListener((MOProxy.MOListener)this);
            }
            this.subracks.put(subrack, subrackName);
        }
        catch (CSException ce) {
            Log.logError((String)"Error adding subrack to SubrackNameFactory", (Throwable)ce);
        }
    }

    private void removeSubrack(MOProxy subrack) {
        this.subracks.remove(subrack);
        subrack.getParent().removeMOListener((MOProxy.MOListener)this);
        subrack.removeMOListener((MOProxy.MOListener)this);
    }

    public void childCreated(MOProxy childMo) {
    }

    public void childDeleted(MOProxy childMo) {
        if (this.subracks.containsKey(childMo)) {
            this.removeSubrack(childMo);
        }
    }

    public void attributesChanged(MOProxy mo, NameValue[] attributes) {
        if (this.subracks.containsKey(mo)) {
            this.addSubrack(mo);
        }
    }

    public String getSubrackName(MOProxy aSubrack) {
        if (!this.subracks.containsKey(aSubrack)) {
            this.addSubrack(aSubrack);
        }
        String subrackName = (String)this.subracks.get(aSubrack);
        return subrackName;
    }
}

