/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.ArrayList;
import se.ericsson.cello.extethswitch.EthernetBridgePortMoGen;
import se.ericsson.cello.extethswitch.EthernetPortMo;
import se.ericsson.cello.extethswitch.EthernetPortMoImpl;
import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.extethswitch.PbitQueueMap;
import se.ericsson.cello.extethswitch.SwitchPortStpMoFactory;
import se.ericsson.cello.extethswitch.VlanMo;
import se.ericsson.cello.extethswitch.VlanMoImpl;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetBridgePortMoImpl
extends EthernetBridgePortMoGen {
    private static final String SWITCH_PORT_STP_IDENTITY = "1";
    private FroProxy ebpProxy = null;

    public EthernetBridgePortMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, switchPortStpMoFactory);
        this.ebpProxy = froProxy;
    }

    public EthernetBridgePortMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
        this.ebpProxy = froProxy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validatePhysicalPortRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (managedObject == null) return;
        if (managedObject.getType().equalsIgnoreCase("Lag")) {
            String string = this.getParent().getParent().getLocalDistinguishedName();
            String string2 = managedObject.getParent().getLocalDistinguishedName();
            if (!managedObject.getParent().getType().equalsIgnoreCase("PlugInUnit")) throw new ConfigurationMismatchException("physicalPortRef can be operated only under cax configuration", "EthernetBridgePort", "physicalPortRef");
            if (!ExtethswitchUtil.isCaxPlugInUnit(managedObject.getParent(), coordinator)) {
                throw new ConfigurationMismatchException("physicalPortRef can be operated only under cax configuration", "EthernetBridgePort", "physicalPortRef");
            }
            if (string.equalsIgnoreCase(string2)) return;
            String string3 = this.getLocalDistinguishedName();
            String string4 = managedObject.getLocalDistinguishedName();
            if (string3.indexOf("Slot=3") != -1) {
                if (string4.indexOf("Slot=3") != -1) return;
                throw new ConfigurationMismatchException("For EBP on Slot=3, Lag must be on Slot=3");
            }
            if (string3.indexOf("Slot=6") == -1 || string4.indexOf("Slot=6") != -1) return;
            throw new ConfigurationMismatchException("For EBP on Slot=6, Lag must be on Slot=6");
        }
        if (!managedObject.getType().equalsIgnoreCase("EthernetPort")) return;
        String string = this.getLocalDistinguishedName();
        String string5 = managedObject.getLocalDistinguishedName();
        EthernetPortMoImpl.checkPortNumber(managedObject, setRequestContext.getCoordinator(), "EthernetBridgePort", "physicalPortRef");
        if (string.indexOf("Slot=3") != -1) {
            if (string5.indexOf("Slot=3") != -1 || string5.indexOf("Slot=1") != -1) return;
            throw new ConfigurationMismatchException("For EBP on Slot=3, EthernetPort must be on Slot=3 or Slot=1");
        }
        if (string.indexOf("Slot=6") == -1 || string5.indexOf("Slot=6") != -1 || string5.indexOf("Slot=4") != -1) return;
        throw new ConfigurationMismatchException("For EBP on Slot=6, EthernetPort must be on Slot=6 or Slot=4");
    }

    public void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (ExtethswitchUtil.isSMXB(coordinator)) {
            throw new MoCanNotBeCreatedException("EthernetBridgePortMO cannot be created on node configured with SMXB");
        }
        int n = ((FroInfo)this.getParent()).getFroId(null);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("esm_fro_id", n));
        this.sendPhyPortRefType2Fro(setRequestContext);
        setRequestContext.setVariable((Object)"isCreate", (Object)Boolean.TRUE);
        this.checkExternalPort(setRequestContext);
        this.checkEgressUntagVlanRef(setRequestContext);
        this.checkUntaggedIngressVlanRef(setRequestContext);
        this.checkVlanRef(setRequestContext);
    }

    private void sendPhyPortRefType2Fro(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        Object object = setRequestContext.getAttributeFromRequest("physicalPortRef");
        if (object == null) {
            n = 0;
        } else if (object instanceof LagMo) {
            n = ((LagMoImpl)object).getFroType();
        } else if (object instanceof EthernetPortMo) {
            n = ((EthernetPortMoImpl)object).getFroType();
        } else {
            throw new InvalidReferenceException("EthernetBridgePort", object);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("physicalPortRefFroType", n));
    }

    public void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("physicalPortRef")) {
            this.sendPhyPortRefType2Fro(setRequestContext);
        }
        this.checkExternalPort(setRequestContext);
        this.checkEgressUntagVlanRef(setRequestContext);
        this.checkUntaggedIngressVlanRef(setRequestContext);
        this.checkVlanRef(setRequestContext);
    }

    private void checkExternalPort(SetRequestContext setRequestContext) throws MoAccessException {
        boolean bl;
        if (setRequestContext.isIncludedInRequest("externalPort") && !(bl = ((Boolean)setRequestContext.getAttributeFromRequest("externalPort")).booleanValue())) {
            ManagedObject[] managedObjectArray;
            VlanMoImpl vlanMoImpl = null;
            ManagedObject[] managedObjectArray2 = managedObjectArray = this.getRefSeqFromRequestOrMo("egressUntagVlanRef", setRequestContext);
            Object object = this.getRefFromRequestOrMoData("untaggedIngressVlanRef", setRequestContext);
            if (object != null) {
                if (object instanceof VlanMoImpl) {
                    vlanMoImpl = (VlanMoImpl)object;
                } else {
                    throw new WrongAttributeTypeException("untaggedIngressVlanRef is of wrong type.", "EthernetBridgePort");
                }
            }
            if (managedObjectArray2 != null && managedObjectArray2.length != 0 || vlanMoImpl != null) {
                throw new OperationNotAllowedException("egressUntagVlanRef and untaggedIngressVlanRef must be NULL, if externalPort is false.", "EthernetBridgePort");
            }
        }
    }

    private void checkEgressUntagVlanRef(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("egressUntagVlanRef")) {
            boolean bl = (Boolean)this.getRefFromRequestOrMoData("externalPort", setRequestContext);
            ManagedObject[] managedObjectArray = (ManagedObject[])setRequestContext.getAttributeFromRequest("egressUntagVlanRef");
            if (managedObjectArray != null && !bl) {
                throw new OperationNotAllowedException("EthernetBridgePort", "untaggedIngressVlanRef,egressUntagVlanRef can not be set when externalPort is set to false");
            }
            ManagedObject[] managedObjectArray2 = this.getRefSeqFromRequestOrMo("vlanRef", setRequestContext);
            EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray2, managedObjectArray, setRequestContext.getCoordinator());
        }
    }

    private void checkUntaggedIngressVlanRef(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("untaggedIngressVlanRef")) {
            boolean bl = (Boolean)this.getRefFromRequestOrMoData("externalPort", setRequestContext);
            ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("untaggedIngressVlanRef");
            if (managedObject != null && !bl) {
                throw new OperationNotAllowedException("EthernetBridgePort", "untaggedIngressVlanRef,egressUntagVlanRef can not be set when externalPort is set to false");
            }
            ManagedObject[] managedObjectArray = this.getRefSeqFromRequestOrMo("vlanRef", setRequestContext);
            EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, managedObject, setRequestContext.getCoordinator());
        }
    }

    private void checkVlanRef(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("vlanRef")) {
            ManagedObject[] managedObjectArray = (ManagedObject[])setRequestContext.getAttributeFromRequest("vlanRef");
            if (managedObjectArray.length > 256) {
                throw new ValueOutOfRangeException("vlanRef", "EthernetBridgePort");
            }
            ManagedObject[] managedObjectArray2 = this.getRefSeqFromRequestOrMo("egressUntagVlanRef", setRequestContext);
            ManagedObject managedObject = (ManagedObject)this.getRefFromRequestOrMoData("untaggedIngressVlanRef", setRequestContext);
            EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, managedObjectArray2, setRequestContext.getCoordinator());
            EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, managedObject, setRequestContext.getCoordinator());
        }
    }

    private Object getRefFromRequestOrMoData(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest(string)) {
            return setRequestContext.getAttributeFromRequest(string);
        }
        if (setRequestContext.getVariable((Object)"isCreate") != Boolean.TRUE) {
            return this.getAttribute(string, null);
        }
        return null;
    }

    private ManagedObject[] getRefSeqFromRequestOrMo(String string, SetRequestContext setRequestContext) throws MoAccessException {
        Object object = this.getRefFromRequestOrMoData(string, setRequestContext);
        if (object == null) {
            return new ManagedObject[0];
        }
        if (object instanceof ManagedObject[]) {
            return (ManagedObject[])object;
        }
        throw new WrongAttributeTypeException(string + " is of wrong type, expected ManagedObject[]", "EthernetBridgePort");
    }

    protected Object handleGetPbitQueueMap(GetRequestContext getRequestContext) throws MoAccessException {
        ArrayParameter arrayParameter = (ArrayParameter)getRequestContext.getParameter("pbitQueueMap");
        if (arrayParameter == null) {
            throw new FroRequestFailedException("EthernetBridgePort", "Missing parameter from FRO: pbitQueueMap", "getAttributes", -1);
        }
        PbitQueueMap pbitQueueMap = new PbitQueueMap(arrayParameter, "EthernetBridgePort", true);
        Struct[] structArray = pbitQueueMap.toStructs();
        Struct[] structArray2 = this.createStructAccToMom(structArray);
        return structArray2;
    }

    protected void handleSetPbitQueueMap(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (structArray.length == 0) {
            PbitQueueMap pbitQueueMap = new PbitQueueMap("EthernetBridgePort", "pbitQueueMap");
            ArrayParameter arrayParameter = pbitQueueMap.toParameter();
            setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        } else {
            PbitQueueMap pbitQueueMap = new PbitQueueMap(structArray, "EthernetBridgePort", true);
            ArrayParameter arrayParameter = pbitQueueMap.toParameter();
            setRequestContext.addParameter(this.froProxy, (Parameter)arrayParameter);
        }
    }

    public void actionSetPbitQueue(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getPbitQueueMap(coordinator);
        PbitQueueMap pbitQueueMap = new PbitQueueMap(structArray, "EthernetBridgePort", true);
        pbitQueueMap.setPbitQueue(n, n2, "EthernetBridgePort", true);
        Struct[] structArray2 = pbitQueueMap.toStructs();
        Struct[] structArray3 = this.createStructAccToMom(structArray2);
        this.setPbitQueueMap(structArray3, coordinator);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        arrayList.add(pbitQueueMap.toParameter());
        this.ebpProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.sendNotification("pbitQueueMap", pbitQueueMap.toStructs(), coordinator);
    }

    private Struct[] createStructAccToMom(Struct[] structArray) throws MoAccessException {
        String[] stringArray = new String[]{"pbit", "queue"};
        Struct[] structArray2 = new Struct[structArray.length];
        for (int i = 0; i < structArray.length; ++i) {
            Object[] objectArray = new Object[]{structArray[i].getValue("pbitQueueMapElement_pbit"), structArray[i].getValue("pbitQueueMapElement_queue")};
            structArray2[i] = new StructImpl(stringArray, objectArray);
        }
        return structArray2;
    }

    public void actionSetAllVlanRefs(ManagedObject[] managedObjectArray, ManagedObject managedObject, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        int n;
        SignedIntParameter signedIntParameter;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, managedObjectArray2, coordinator);
        EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, managedObject, coordinator);
        ManagedObject[] managedObjectArray3 = this.getVlanRef(coordinator);
        this.releaseVlanRef(managedObjectArray3, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayParameter arrayParameter = null;
        if (managedObjectArray != null) {
            arrayParameter = new ArrayParameter("vlanRef");
            signedIntParameter = null;
            int n2 = 0;
            for (n = 0; n < managedObjectArray.length; ++n) {
                n2 = ((FroInfo)managedObjectArray[n]).getFroId(coordinator);
                signedIntParameter = new SignedIntParameter("vlanRef_Member", n2);
                arrayParameter.add((Parameter)signedIntParameter);
            }
        }
        arrayList.add(arrayParameter);
        if (managedObject != null) {
            signedIntParameter = new SignedIntParameter("untaggedIngressVlanRef", ((FroInfo)managedObject).getFroId(coordinator));
            arrayList.add(signedIntParameter);
        } else {
            signedIntParameter = new SignedIntParameter("untaggedIngressVlanRef", 0);
            arrayList.add(signedIntParameter);
        }
        signedIntParameter = null;
        if (managedObjectArray2 != null) {
            signedIntParameter = new ArrayParameter("egressUntagVlanRef");
            SignedIntParameter signedIntParameter2 = null;
            n = 0;
            for (int i = 0; i < managedObjectArray2.length; ++i) {
                n = ((FroInfo)managedObjectArray2[i]).getFroId(coordinator);
                signedIntParameter2 = new SignedIntParameter("egressUntagVlanRef_Member", n);
                signedIntParameter.add((Parameter)signedIntParameter2);
            }
        }
        arrayList.add(signedIntParameter);
        if (!this.getExternalPort(coordinator)) {
            throw new OperationNotAllowedException("EthernetBridgePort", "untaggedIngressVlanRef,egressUntagVlanRef can not be set when externalPort is set to false");
        }
        this.ebpProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        this.reserveVlanRef(managedObjectArray, coordinator);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)this.data.getAttribute("vlanRef");
        Attribute[] attributeArray = new Attribute[managedObjectArray.length];
        ReferenceAttribute referenceAttribute = null;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            referenceAttribute = new ReferenceAttribute("vlanRef", true);
            referenceAttribute.setValue(managedObjectArray[i]);
            attributeArray[i] = referenceAttribute;
        }
        sequenceAttribute.setValue(attributeArray);
        ((ReferenceAttribute)this.data.getAttribute("untaggedIngressVlanRef")).setValue(managedObject);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)this.data.getAttribute("egressUntagVlanRef");
        Attribute[] attributeArray2 = new Attribute[managedObjectArray2.length];
        ReferenceAttribute referenceAttribute2 = null;
        for (int i = 0; i < managedObjectArray2.length; ++i) {
            referenceAttribute2 = new ReferenceAttribute("egressUntagVlanRef", true);
            referenceAttribute2.setValue(managedObjectArray2[i]);
            attributeArray2[i] = referenceAttribute2;
        }
        sequenceAttribute2.setValue(attributeArray2);
        NotificationSender.instance().pushAVC((ManagedObject)this, new String[]{"vlanRef", "egressUntagVlanRef", "untaggedIngressVlanRef"}, new Object[]{managedObjectArray, managedObjectArray2, managedObject}, coordinator);
    }

    private static void checkIfInVlanRef(ManagedObject[] managedObjectArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject != null) {
            EthernetBridgePortMoImpl.checkIfInVlanRef(managedObjectArray, new ManagedObject[]{managedObject}, coordinator);
        }
    }

    private void reserveVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObjectArray != null) {
            n = managedObjectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            ((Reservable)managedObjectArray[i]).reserve((ManagedObject)this, coordinator);
        }
    }

    private void releaseVlanRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObjectArray != null) {
            n = managedObjectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            ((Reservable)managedObjectArray[i]).release((ManagedObject)this, coordinator);
        }
    }

    private static void checkIfInVlanRef(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator) throws MoAccessException {
        int n;
        if (managedObjectArray2 != null && managedObjectArray2.length != 0 && managedObjectArray.length == 0) {
            throw new ValueOutOfRangeException("attributes should be members of VlanRef", "EthernetBridgePort");
        }
        int n2 = 0;
        if (managedObjectArray != null) {
            EthernetBridgePortMoImpl.checkVlanRefType(managedObjectArray);
            n2 = managedObjectArray.length;
        }
        int n3 = 0;
        if (managedObjectArray2 != null) {
            EthernetBridgePortMoImpl.checkVlanRefType(managedObjectArray2);
            n3 = managedObjectArray2.length;
        }
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(managedObjectArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            boolean bl = false;
            if (arrayList.contains(managedObjectArray2[n])) {
                bl = true;
            }
            if (bl) continue;
            throw new OperationNotAllowedException("EthernetBridgePort", "this attribute is out of vlanRef array");
        }
    }

    private static void checkVlanRefType(ManagedObject[] managedObjectArray) throws MoAccessException {
        int n = managedObjectArray.length;
        for (int i = 0; i < n; ++i) {
            if (managedObjectArray[i] instanceof VlanMo) continue;
            throw new WrongAttributeTypeException("vlanRef", "EthernetBridgePort");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getFroType() {
        return Integer.parseInt("D0D", 16);
    }

    protected void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator, String string) throws MoAccessException {
        if (string.equals("untaggedIngressVlanRef")) {
            return;
        }
        super.updateReservedMos(managedObject, managedObject2, coordinator, string);
    }

    protected void updateReservedMos(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2, Coordinator coordinator, String string) throws MoAccessException {
        if (string.equals("egressUntagVlanRef")) {
            return;
        }
        super.updateReservedMos(managedObjectArray, managedObjectArray2, coordinator, string);
    }
}

