/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.extethswitch.EthernetSwitchPortMo;
import se.ericsson.cello.extethswitch.LagMo;
import se.ericsson.cello.extethswitch.LagMoImpl;
import se.ericsson.cello.extethswitch.OperatingMode;
import se.ericsson.cello.extethswitch.PbitQueueMap;
import se.ericsson.cello.extethswitch.SwitchPortStpMo;
import se.ericsson.cello.extethswitch.SwitchPortStpMoFactory;
import se.ericsson.cello.extethswitch.SwitchPortStpMoImpl;
import se.ericsson.cello.extethswitch.VlanMembership;
import se.ericsson.cello.extethswitch.mom.EnumTrafficState;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetSwitchPortMoImpl
extends CelloMao
implements EthernetSwitchPortMo,
FroInfo {
    private static final String SWITCH_PORT_STP_ID = "1";
    private static final int INGRESS_PEAK_BITRATE_DEFAULT = 1000;
    private static final int INGRESS_PEAK_BITRATE_MIN = 1;
    private static final int INGRESS_PEAK_BITRATE_MAX = 1000;
    private static final boolean AUTO_NEGOTIATION_DEFAULT = true;
    private static final int CONFIGURED_SPEED_DUPLEX_DEFAULT = 1;
    private static final boolean AUTO_NEGOTIATION_TRUE = true;
    private static final boolean AUTO_NEGOTIATION_FALSE = false;
    private static final int CONFIGURED_SPEED_DUPLEX_MIN = 1;
    private static final int CONFIGURED_SPEED_DUPLEX_MAX = 6;
    private static final int CONFIGURED_SPEED_DUPLEX_1000_MB_HALF = 5;
    private static final int CONFIGURED_SPEED_DUPLEX_1000_MB_FULL = 6;
    private static final int PORT_NO_MIN = 1;
    private static final int PORT_NO_MAX = 7;
    private static final boolean SYSTEM_PORT_DEFAULT = false;
    private static final boolean SYSTEM_PORT_TRUE = true;
    private static final boolean SYSTEM_PORT_FALSE = false;
    private static final int LENGTH_PBIT_QUEUE_MAP = 8;
    private static final int MAX_LENGTH_VLAN_MEMBERSHIP = 256;
    private static final int UNTAGGED_INGRESS_PRIORITY_DEFAULT = 0;
    private static final int UNTAGGED_INGRESS_PRIORITY_MAX = 7;
    private static final int UNTAGGED_INGRESS_PRIORITY_MIN = 0;
    private static final int UNTAGGED_INGRESS_VID_DEFAULT = 1;
    private static final int UNTAGGED_INGRESS_VID_MAX = 4095;
    private static final int UNTAGGED_INGRESS_VID_MIN = 1;
    private static final String EXH_FRO_ID = "exhFroId";
    private static String[] lagClass = new String[]{"Lag"};
    private static final String PIU_FRO_ID = "piuFroId";
    public static final String SFP_PRODUCT_NUMBER = "sfpProductNumber";
    public static final String SFP_STATE = "sfpState";
    public static final String SFP_TYPE = "sfpType";
    private MoData data;
    private static final int MO_DATA_REVISION_6 = 6000;
    private static final int MO_DATA_REVISION_6_MOD = 6001;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_8_MOD = 8001;
    private static final int MO_DATA_REVISION_LATEST = 8001;
    private static final int MAX_NO_ETHERNET_SWITCH_PORT = 7;
    private static final String[] myAttrNames = new String[]{"administrativeState", "ingressPeakBitrate", "operatingMode", "systemPort", "untaggedIngressPriority", "untaggedIngressVid", "pbitQueueMap", "vlanMembership"};
    private FroProxy ethernetSwitchPortProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"EthernetSwitchPort", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"EthernetSwitch");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"EthernetSwitchPort", (int)7);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"EthernetSwitchPort", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"EthernetSwitchPort");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"lagRef", (AttrList)attrList, (boolean)false, (String[])lagClass, (String)"EthernetSwitchPort");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ingressPeakBitrate", (AttrList)attrList, (boolean)false, (int)1000, (int)1, (int)1000, (String)"EthernetSwitchPort");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"portNo", (AttrList)attrList, (boolean)true, (int)9999, (int)1, (int)7, (String)"EthernetSwitchPort");
        EthernetSwitchPortMoImpl.checkPortNo(managedObject, "EthernetSwitchPort", n3, coordinator);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"systemPort", (AttrList)attrList, (boolean)false, (boolean)false, (String)"EthernetSwitchPort");
        int n4 = MoAttributeValidator.checkAndGetEnumAttribute((String)"trafficState", (AttrList)attrList, (boolean)false, (int)1, (int[])EnumTrafficState.VALUES_ARRAY, (String)"EthernetSwitchPort");
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"untaggedIngressPriority", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)7, (String)"EthernetSwitchPort");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"untaggedIngressVid", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)4095, (String)"EthernetSwitchPort");
        boolean bl2 = false;
        if (n6 != 1) {
            bl2 = true;
        }
        VlanMembership vlanMembership = EthernetSwitchPortMoImpl.checkAndGetVlanMembership(attrList);
        if (n6 != 1) {
            EthernetSwitchPortMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(vlanMembership.toStructs(), n6);
        }
        Struct struct = EthernetSwitchPortMoImpl.checkAndGetOperatingMode(attrList);
        PbitQueueMap pbitQueueMap = EthernetSwitchPortMoImpl.checkAndGetPbitQueueMap(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"EthernetSwitchPort");
        SignedIntParameter signedIntParameter = new SignedIntParameter("administrativeState", n);
        arrayList.add(signedIntParameter);
        int n7 = 0;
        if (managedObject3 != null) {
            n7 = ((LagMoImpl)managedObject3).getFroId(coordinator);
        }
        arrayList.add(new UnsignedIntParameter("lagRef", (long)n7));
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("systemPort", bl);
        arrayList.add(signedIntParameter2);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter("trafficState", n4);
        arrayList.add(signedIntParameter3);
        SignedIntParameter signedIntParameter4 = new SignedIntParameter("ingressPeakBitrate", n2);
        arrayList.add(signedIntParameter4);
        SignedIntParameter signedIntParameter5 = new SignedIntParameter("portNo", n3);
        arrayList.add(signedIntParameter5);
        SignedIntParameter signedIntParameter6 = new SignedIntParameter("untaggedIngressPriority", n5);
        arrayList.add(signedIntParameter6);
        SignedIntParameter signedIntParameter7 = new SignedIntParameter("untaggedIngressVid", n6);
        arrayList.add(signedIntParameter7);
        StructParameter structParameter = EthernetSwitchPortMoImpl.makeStructParameter(struct);
        arrayList.add(structParameter);
        ArrayParameter arrayParameter = pbitQueueMap.toParameter();
        arrayList.add(arrayParameter);
        ArrayParameter arrayParameter2 = vlanMembership.toParameter();
        arrayList.add(arrayParameter2);
        int n8 = ((FroInfo)managedObject).getFroId(coordinator);
        SignedIntParameter signedIntParameter8 = new SignedIntParameter(EXH_FRO_ID, n8);
        arrayList.add(signedIntParameter8);
        int n9 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
        SignedIntParameter signedIntParameter9 = new SignedIntParameter(PIU_FRO_ID, n9);
        arrayList.add(signedIntParameter9);
        if (managedObject3 != null) {
            if (!managedObject.equals(managedObject3.getParent())) {
                throw new OperationNotAllowedException("Given EthernetSwitchPort and referred Lag have different parents.", "EthernetSwitchPort");
            }
            ManagedObject managedObject4 = ((LagMo)managedObject3).getMasterPort(coordinator);
            if (managedObject4 != null) {
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new OperatingMode(structParameter).toStruct("autoNegotiation", "configuredSpeedDuplex"), bl, new Integer(n5), new Integer(n6), new PbitQueueMap(arrayParameter).toStructs(), new VlanMembership(arrayParameter2).toStructs()};
                EthernetSwitchPortMoImpl.checkLag(objectArray, managedObject4, coordinator);
            }
        }
        return new EthernetSwitchPortMoImpl(managedObject, string, string2, managedObject3, arrayList, coordinator, froProxy, maoFroIndicationHandler, switchPortStpMoFactory);
    }

    private EthernetSwitchPortMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, SwitchPortStpMoFactory switchPortStpMoFactory) throws MoAccessException {
        super(managedObject, "EthernetSwitchPort", string, coordinator);
        this.ethernetSwitchPortProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.ethernetSwitchPortProxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("lagRef", true, managedObject2));
        if (managedObject2 != null) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(8001);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        switchPortStpMoFactory.autoCreateMo(this, SWITCH_PORT_STP_ID, coordinator);
    }

    public EthernetSwitchPortMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.ethernetSwitchPortProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8001);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("lagRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.getLagRef(coordinator);
        if (managedObject != null) {
            throw new OperationNotAllowedException("Delete not allowed because this port is in a LAG: " + managedObject.getLocalDistinguishedName(), "EthernetSwitchPort");
        }
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof SwitchPortStpMo)) continue;
            ((SwitchPortStpMoImpl)object).deleteMo(coordinator);
        }
        this.ethernetSwitchPortProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getSfpProductNumber(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(SFP_PRODUCT_NUMBER, coordinator);
    }

    public void setSfpProductNumber(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute(SFP_PRODUCT_NUMBER, string, coordinator);
    }

    public int getPortNo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("portNo", coordinator);
    }

    public int getTrafficState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("trafficState", coordinator);
    }

    public void setTrafficState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trafficState", new Integer(n), coordinator);
    }

    public int getUntaggedIngressPriority(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("untaggedIngressPriority", coordinator);
    }

    public void setUntaggedIngressPriority(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressPriority", new Integer(n), coordinator);
    }

    public int getUntaggedIngressVid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("untaggedIngressVid", coordinator);
    }

    public void setUntaggedIngressVid(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("untaggedIngressVid", new Integer(n), coordinator);
    }

    public Struct[] getVlanMembership(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("vlanMembership", coordinator);
    }

    public void setVlanMembership(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vlanMembership", structArray, coordinator);
    }

    public int getIngressPeakBitrate(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ingressPeakBitrate", coordinator);
    }

    public void setIngressPeakBitrate(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ingressPeakBitrate", new Integer(n), coordinator);
    }

    public int getActualSpeedDuplex(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("actualSpeedDuplex", coordinator);
    }

    public Struct getSfpInformation(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("sfpInformation", coordinator);
    }

    public boolean getSfpPort(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("sfpPort", coordinator);
    }

    public boolean getSystemPort(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("systemPort", coordinator);
    }

    public void setSystemPort(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("systemPort", bl, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public ManagedObject getLagRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("lagRef", coordinator);
    }

    public void setLagRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("lagRef", managedObject, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getEthernetSwitchPortId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("EthernetSwitchPortId", coordinator);
    }

    public Struct[] getPbitQueueMap(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("pbitQueueMap", coordinator);
    }

    public void setPbitQueueMap(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pbitQueueMap", structArray, coordinator);
    }

    public Struct getOperatingMode(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("operatingMode", coordinator);
    }

    public void setOperatingMode(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("operatingMode", struct, coordinator);
    }

    public int getPmIfOutMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutMulticastPkts", coordinator);
    }

    public int getPmIfOutBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutBroadcastPkts", coordinator);
    }

    public int getPmIfOutUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutUcastPkts", coordinator);
    }

    public int getPmIfInMulticastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInMulticastPkts", coordinator);
    }

    public int getPmIfInBroadcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInBroadcastPkts", coordinator);
    }

    public int getPmIfInUcastPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInUcastPkts", coordinator);
    }

    public int getPmIfOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutErrors", coordinator);
    }

    public int getPmIfInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInErrors", coordinator);
    }

    public int getPmIfOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutDiscards", coordinator);
    }

    public int getPmIfInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInDiscards", coordinator);
    }

    public int getPmIfOutOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsHi", coordinator);
    }

    public int getPmIfOutOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfOutOctetsLo", coordinator);
    }

    public int getPmIfInOctetsHi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsHi", coordinator);
    }

    public int getPmIfInOctetsLo(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIfInOctetsLo", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lagRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("lagRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sfpPort")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("sfpPort");
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("systemPort")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("systemPort");
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pbitQueueMap")) {
                map = this.getAttrFromRes(map, coordinator);
                object = new PbitQueueMap((ArrayParameter)map.get("pbitQueueMap"));
                objectArray[i] = ((PbitQueueMap)object).toStructs();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("actualSpeedDuplex")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("actualSpeedDuplex");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ingressPeakBitrate")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("ingressPeakBitrate");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operatingMode")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = this.convertStructParameter2Struct((StructParameter)map.get("operatingMode"), "autoNegotiation", "configuredSpeedDuplex");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("portNo")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("portNo");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sfpInformation")) {
                map = this.getAttrFromRes(map, coordinator);
                objectArray[i] = this.convertStructParameter2Struct((StructParameter)map.get("sfpInformation"), SFP_PRODUCT_NUMBER, SFP_STATE, SFP_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("trafficState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("untaggedIngressPriority")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("untaggedIngressPriority");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("untaggedIngressVid")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("untaggedIngressVid");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanMembership")) {
                map = this.getAttrFromRes(map, coordinator);
                object = new VlanMembership((ArrayParameter)map.get("vlanMembership"));
                objectArray[i] = ((VlanMembership)object).toStructs();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutMulticastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutMulticastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutBroadcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutBroadcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInMulticastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInMulticastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInBroadcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInBroadcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInUcastPkts")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInUcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsHi")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutOctetsHi", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfOutOctetsLo")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfOutOctetsLo", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsHi")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInOctetsHi", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfInOctetsLo")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIfInOctetsLo", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "EthernetSwitchPort");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = (ManagedObject)this.getAttribute("lagRef", coordinator);
        ManagedObject managedObject2 = managedObject == null ? null : ((LagMo)managedObject).getMasterPort(coordinator);
        boolean bl = this.equals((EthernetSwitchPortMoImpl)managedObject2);
        Object object = null;
        this.getAttributes(myAttrNames, coordinator);
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Hashtable<String, SignedIntParameter> hashtable = new Hashtable<String, SignedIntParameter>();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                n3 = n;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("trafficState")) {
                n4 = n;
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("lagRef")) continue;
            n2 = n;
        }
        if (n3 >= 0) {
            if (!objectArray[n3].getClass().equals(String.class)) {
                throw new WrongAttributeTypeException("userLabel", "EthernetSwitchPort");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[n3]), (String)"userLabel", (String)"EthernetSwitchPort", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[n3]);
            if (n3 == 0 && stringArray.length == 1) {
                return;
            }
        }
        if (n4 >= 0) {
            if (!objectArray[n4].getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("trafficState", "EthernetSwitchPort");
            }
            n = (Integer)objectArray[n4];
            if (n != 1 && n != 0) {
                throw new ValueOutOfRangeException("trafficState", "EthernetSwitchPort");
            }
            hashtable.put("trafficState", new SignedIntParameter("trafficState", n));
            this.sendNotification("trafficState", new Integer(n), coordinator);
        }
        if (n2 >= 0) {
            object = objectArray[n2];
            if (object == null) {
                if (managedObject != null) {
                    if (!((LagMoImpl)managedObject).isConfigAllowed(coordinator)) {
                        throw new OperationNotAllowedException("Set not allowed beacuse the requiredNumberOfLinks must not exceed the number of Ethernet ports in the existing LAG", "EthernetSwitchPort");
                    }
                    ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                }
                this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
            } else if (object instanceof LagMo) {
                ManagedObject managedObject3 = ((LagMo)object).getMasterPort(coordinator);
                if (!this.getParent().getFullDistinguishedName().equals(((ManagedObject)object).getParent().getFullDistinguishedName())) {
                    throw new OperationNotAllowedException("Given EthernetSwitchPort and referred Lag have different parents.", "EthernetSwitchPort");
                }
                if (((LagMoImpl)object).equals(managedObject)) {
                    if (managedObject2 != null) {
                        this.checkAndSetAttrsInExistingLag(stringArray, objectArray, managedObject, bl, hashtable, n4, coordinator);
                    } else {
                        this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
                    }
                } else {
                    if (managedObject != null) {
                        if (!((LagMoImpl)managedObject).isConfigAllowed(coordinator)) {
                            throw new OperationNotAllowedException("Set not allowed beacuse the requiredNumberOfLinks must not exceed the number of Ethernet ports in the existing LAG", "EthernetSwitchPort");
                        }
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    }
                    ((Reservable)objectArray[n2]).reserve((ManagedObject)this, coordinator);
                    if (managedObject3 != null) {
                        this.compareAttrsWithMasterPort((ManagedObject)object, stringArray, objectArray, managedObject3, coordinator);
                    }
                    this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
                }
            } else {
                throw new WrongAttributeTypeException("lagRef", "EthernetSwitchPort");
            }
        }
        if (n2 == -1) {
            this.checkAndSetAttrsInExistingLag(stringArray, objectArray, managedObject, bl, hashtable, n4, coordinator);
        }
    }

    private void checkAndSetAttrsInExistingLag(String[] stringArray, Object[] objectArray, ManagedObject managedObject, boolean bl, Hashtable hashtable, int n, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
        } else if (bl) {
            this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
            this.setAllOtherPortsInLag(stringArray, objectArray, coordinator);
        } else if (n >= 0) {
            this.setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
        } else {
            throw new OperationNotAllowedException("This EthernetSwitchPort is not the defined masterPort in Lag: " + managedObject.getLocalDistinguishedName(), "EthernetSwitchPort");
        }
    }

    void setSwitchPortAttributes(String[] stringArray, Object[] objectArray, Hashtable hashtable, Coordinator coordinator) throws MoAccessException {
        int n;
        int n2 = 0;
        boolean bl = false;
        Object var7_7 = null;
        int n3 = -1;
        VlanMembership vlanMembership = null;
        Object[] objectArray2 = this.getAttributes(myAttrNames, coordinator);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("untaggedIngressVid")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("untaggedIngressVid", "EthernetSwitchPort");
                }
                n3 = (Integer)objectArray[n];
                objectArray2[5] = (Integer)objectArray[n];
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("vlanMembership")) continue;
            if (!(objectArray[n] instanceof Struct[])) {
                throw new WrongAttributeTypeException("vlanMembership", "EthernetSwitchPort");
            }
            vlanMembership = new VlanMembership((Struct[])objectArray[n]);
            objectArray2[7] = (Struct[])objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            ArrayParameter arrayParameter;
            if (stringArray[n].equalsIgnoreCase("lagRef")) {
                arrayParameter = (ArrayParameter)objectArray[n];
                int n4 = arrayParameter == null ? 0 : ((LagMoImpl)arrayParameter).getFroId(coordinator);
                hashtable.put("lagRef", new UnsignedIntParameter("lagRef", (long)n4));
                ((ReferenceAttribute)this.data.getAttribute("lagRef")).setValue((ManagedObject)arrayParameter);
                this.sendNotification("lagRef", arrayParameter, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "EthernetSwitchPort");
                }
                n2 = (Integer)objectArray[n];
                objectArray2[0] = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n2, (int)0, (int)2, (String)"EthernetSwitchPort");
                if (n2 == 2) {
                    n2 = 0;
                }
                hashtable.put("administrativeState", new SignedIntParameter("administrativeState", n2));
                this.sendNotification("administrativeState", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("ingressPeakBitrate")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ingressPeakBitrate", "EthernetSwitchPort");
                }
                n2 = (Integer)objectArray[n];
                objectArray2[1] = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"ingressPeakBitrate", (int)n2, (int)1, (int)1000, (String)"EthernetSwitchPort");
                hashtable.put("ingressPeakBitrate", new SignedIntParameter("ingressPeakBitrate", n2));
                this.sendNotification("ingressPeakBitrate", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("operatingMode")) {
                if (!(objectArray[n] instanceof Struct)) {
                    throw new WrongAttributeTypeException("operatingMode", "EthernetSwitchPort");
                }
                arrayParameter = (Struct)objectArray[n];
                objectArray2[2] = (Struct)objectArray[n];
                EthernetSwitchPortMoImpl.checkOperatingModeRanges((Struct)arrayParameter);
                StructParameter structParameter = EthernetSwitchPortMoImpl.makeStructParameter((Struct)arrayParameter);
                hashtable.put("operatingMode", structParameter);
                this.sendNotification("operatingMode", arrayParameter, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("systemPort")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Boolean == null ? EthernetSwitchPortMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("systemPort", "EthernetSwitchPort");
                }
                boolean bl2 = (Boolean)objectArray[n];
                objectArray2[3] = (Boolean)objectArray[n];
                hashtable.put("systemPort", new SignedIntParameter("systemPort", MaoFroTypeConverter.boolean2int((boolean)bl2)));
                this.sendNotification("systemPort", bl2, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("trafficState")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("untaggedIngressPriority")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? EthernetSwitchPortMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("untaggedIngressPriority", "EthernetSwitchPort");
                }
                n2 = (Integer)objectArray[n];
                objectArray2[4] = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"untaggedIngressPriority", (int)n2, (int)0, (int)7, (String)"EthernetSwitchPort");
                hashtable.put("untaggedIngressPriority", new SignedIntParameter("untaggedIngressPriority", n2));
                this.sendNotification("untaggedIngressPriority", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("untaggedIngressVid")) {
                MoAttributeValidator.checkIntegerAttribute((String)"untaggedIngressVid", (int)n3, (int)1, (int)4095, (String)"EthernetSwitchPort");
                if (n3 != 1) {
                    if (vlanMembership == null) {
                        arrayParameter = (Struct[])this.getAttribute("vlanMembership", coordinator);
                        EthernetSwitchPortMoImpl.checkUntaggedIngressVidIsWithinVlanMembership((Struct[])arrayParameter, n3);
                    } else {
                        EthernetSwitchPortMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(vlanMembership.toStructs(), n3);
                    }
                }
                hashtable.put("untaggedIngressVid", new SignedIntParameter("untaggedIngressVid", n3));
                this.sendNotification("untaggedIngressVid", new Integer(n3), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pbitQueueMap")) {
                if (!(objectArray[n] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("pbitQueueMap", "EthernetSwitchPort");
                }
                arrayParameter = (ArrayParameter)objectArray[n];
                PbitQueueMap pbitQueueMap = new PbitQueueMap((Struct[])arrayParameter);
                objectArray2[6] = (Struct[])objectArray[n];
                hashtable.put("pbitQueueMap", pbitQueueMap.toParameter());
                this.sendNotification("pbitQueueMap", arrayParameter, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("vlanMembership")) {
                if (n3 == -1) {
                    n3 = (Integer)this.getAttribute("untaggedIngressVid", coordinator);
                }
                if (n3 != 1) {
                    EthernetSwitchPortMoImpl.checkUntaggedIngressVidIsWithinVlanMembership(vlanMembership.toStructs(), n3);
                }
                arrayParameter = vlanMembership.toParameter();
                hashtable.put("vlanMembership", arrayParameter);
                this.sendNotification("vlanMembership", vlanMembership.toStructs(), coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("userLabel") && bl) continue;
            throw new NoSuchAttributeException(stringArray[n], "EthernetSwitchPort");
        }
        if (hashtable.size() != 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(hashtable.values());
            if (arrayList != null) {
                this.ethernetSwitchPortProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
            }
        }
    }

    private void setAllOtherPortsInLag(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = ((LagMoImpl)this.getLagRef(coordinator)).getReservedBy(coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i].equals(this)) continue;
            Hashtable hashtable = new Hashtable();
            ((EthernetSwitchPortMoImpl)managedObjectArray[i]).setSwitchPortAttributes(stringArray, objectArray, hashtable, coordinator);
        }
    }

    private void compareAttrsWithMasterPort(ManagedObject managedObject, String[] stringArray, Object[] objectArray, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray2 = this.getAttributes(myAttrNames, coordinator);
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < myAttrNames.length; ++j) {
                if (!stringArray[i].equalsIgnoreCase(myAttrNames[j])) continue;
                objectArray2[j] = objectArray[i];
                continue block0;
            }
        }
        EthernetSwitchPortMoImpl.checkLag(objectArray2, managedObject2, coordinator);
    }

    public static void checkLag(Object[] objectArray, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = " cannot be compared; one or more components of this attribute in Master and/or Slave ports are mismatched.";
        Object[] objectArray2 = ((EthernetSwitchPortMoImpl)managedObject).getAttributes(myAttrNames, coordinator);
        string = myAttrNames[0];
        if (objectArray2[0] != null && objectArray[0] != null) {
            n4 = (Integer)objectArray2[0];
            if (n4 != (n3 = ((Integer)objectArray[0]).intValue())) {
                bl = false;
                stringBuffer.append("\n" + string + ": Master: " + n4 + "\tThis: " + n3);
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[1];
        if (objectArray2[1] != null && objectArray[1] != null) {
            n4 = (Integer)objectArray2[1];
            if (n4 != (n3 = ((Integer)objectArray[1]).intValue())) {
                bl = false;
                stringBuffer.append("\n" + string + ": Master: " + n4 + "\tThis: " + n3);
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[2];
        if (objectArray2[2] != null && objectArray[2] != null && ((Struct)objectArray[2]).getValue("autoNegotiation") != null && ((Struct)objectArray[2]).getValue("configuredSpeedDuplex") != null) {
            n4 = ((Boolean)((Struct)objectArray2[2]).getValue("autoNegotiation")).booleanValue() ? 1 : 0;
            n3 = (Integer)((Struct)objectArray2[2]).getValue("configuredSpeedDuplex");
            n2 = ((Boolean)((Struct)objectArray[2]).getValue("autoNegotiation")).booleanValue();
            n = (Integer)((Struct)objectArray[2]).getValue("configuredSpeedDuplex");
            if (n4 != n2 || n3 != n) {
                bl = false;
                stringBuffer.append("\n" + string + ":");
                stringBuffer.append("\nAutoNeg: Master: " + (n4 != 0) + "\tThis: " + (n2 != 0));
                stringBuffer.append("\nCfgSpDuplex: Master: " + n3 + "\tThis: " + n);
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[3];
        if (objectArray2[3] != null && objectArray[3] != null) {
            n4 = ((Boolean)objectArray2[3]).booleanValue() ? 1 : 0;
            if (n4 != (n3 = (int)(((Boolean)objectArray[3]).booleanValue() ? 1 : 0))) {
                bl = false;
                stringBuffer.append("\n" + string + ": Master: " + (n4 != 0) + "\tThis: " + (n3 != 0));
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[4];
        if (objectArray2[4] != null && objectArray[4] != null) {
            n4 = (Integer)objectArray2[4];
            if (n4 != (n3 = ((Integer)objectArray[4]).intValue())) {
                bl = false;
                stringBuffer.append("\n" + string + ": Master: " + n4 + "\tThis: " + n3);
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[5];
        if (objectArray2[5] != null && objectArray[5] != null) {
            n4 = (Integer)objectArray2[5];
            if (n4 != (n3 = ((Integer)objectArray[5]).intValue())) {
                bl = false;
                stringBuffer.append("\n" + string + ": Master: " + n4 + "\tThis: " + n3);
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[6];
        if (objectArray2[6] != null && objectArray[6] != null) {
            Struct[] structArray = (Struct[])objectArray2[6];
            Struct[] structArray2 = (Struct[])objectArray[6];
            for (n2 = 0; n2 < 8; ++n2) {
                if (structArray[n2] != null && structArray2[n2] != null && structArray2[n2].getValue("pbit") != null && structArray2[n2].getValue("queue") != null) {
                    n = (Integer)structArray[n2].getValue("pbit");
                    int n5 = (Integer)structArray[n2].getValue("queue");
                    int n6 = (Integer)structArray2[n2].getValue("pbit");
                    int n7 = (Integer)structArray2[n2].getValue("queue");
                    if (n == n6 && n5 == n7) continue;
                    bl = false;
                    if (n2 == 0) {
                        stringBuffer.append("\n" + string + ":");
                    }
                    stringBuffer.append("\nPbit: Master: " + n + "\tThis: " + n6);
                    stringBuffer.append("\nQueue: Master: " + n5 + "\tThis: " + n7);
                    continue;
                }
                bl = false;
                stringBuffer.append("\n" + string + string2);
                break;
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        string = myAttrNames[7];
        if (objectArray2[7] != null && objectArray[7] != null) {
            Struct[] structArray = (Struct[])objectArray2[7];
            Struct[] structArray3 = (Struct[])objectArray[7];
            if (structArray.length != structArray3.length) {
                bl = false;
                stringBuffer.append(" \n masterVlanMembership.length " + structArray.length + " != thisVlanMembership.length " + structArray3.length);
            } else {
                for (n2 = 0; n2 < structArray.length; ++n2) {
                    if (structArray[n2].getValue("vid").equals(structArray3[n2].getValue("vid")) && structArray[n2].getValue("egressUntag").equals(structArray3[n2].getValue("egressUntag"))) continue;
                    bl = false;
                    stringBuffer.append(" \n VlanMembership " + n2 + " vid m " + structArray[n2].getValue("vid") + " s " + structArray3[n2].getValue("vid"));
                    stringBuffer.append(" egress_untag m " + structArray[n2].getValue("egressUntag") + " s " + structArray3[n2].getValue("egressUntag"));
                }
            }
        } else {
            bl = false;
            stringBuffer.append("\n" + string + string2);
        }
        if (!bl) {
            UpgradeTrace.debug((Class)EthernetSwitchPortMoImpl.class, (int)72, (String)("checkLag is not happy! : " + stringBuffer.toString()));
            throw new OperationNotAllowedException("This port attribute(s) is not equal to masterPort in Lag: " + stringBuffer.toString(), "EthernetSwitchPort");
        }
    }

    public void actionSetPbitQueue(int n, int n2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Struct[] structArray = this.getPbitQueueMap(coordinator);
        PbitQueueMap pbitQueueMap = new PbitQueueMap(structArray);
        pbitQueueMap.setPbitQueue(n, n2);
        this.setPbitQueueMap(pbitQueueMap.toStructs(), coordinator);
    }

    public String getType() {
        return "EthernetSwitchPort";
    }

    private static PbitQueueMap checkAndGetPbitQueueMap(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("pbitQueueMap");
        if (n == -1) {
            return new PbitQueueMap();
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("pbitQueueMap", "EthernetSwitchPort");
        }
        PbitQueueMap pbitQueueMap = new PbitQueueMap((Struct[])attrList.getValue(n));
        attrList.removeElementAt(n);
        return pbitQueueMap;
    }

    private static VlanMembership checkAndGetVlanMembership(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("vlanMembership");
        if (n == -1) {
            return new VlanMembership();
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("vlanMembership", "EthernetSwitchPort");
        }
        VlanMembership vlanMembership = new VlanMembership((Struct[])attrList.getValue(n));
        attrList.removeElementAt(n);
        return vlanMembership;
    }

    private static Struct checkAndGetOperatingMode(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("operatingMode");
        if (n == -1) {
            String[] stringArray = new String[]{"autoNegotiation", "configuredSpeedDuplex"};
            Object[] objectArray = new Object[]{true, new Integer(1)};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            return structImpl;
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("operatingMode", "EthernetSwitchPort");
        }
        Struct struct = (Struct)attrList.getValue(n);
        EthernetSwitchPortMoImpl.checkOperatingModeRanges(struct);
        attrList.removeElementAt(n);
        return struct;
    }

    private static void checkOperatingModeRanges(Struct struct) throws MoAccessException {
        if (!(struct.getValue("autoNegotiation") instanceof Boolean)) {
            throw new WrongAttributeTypeException("autoNegotiation", "EthernetSwitchPort");
        }
        if (!(struct.getValue("configuredSpeedDuplex") instanceof Integer)) {
            throw new WrongAttributeTypeException("configuredSpeedDuplex", "EthernetSwitchPort");
        }
        int n = (Integer)struct.getValue("configuredSpeedDuplex");
        boolean bl = (Boolean)struct.getValue("autoNegotiation");
        if (n < 1 || n > 6) {
            throw new ValueOutOfRangeException("configuredSpeedDuplex", "EthernetSwitchPort");
        }
        if (!(n != 5 && n != 6 || bl)) {
            throw new OperationNotAllowedException("AutoNegotiation must be true if ETH_1000_MB_HALF or ETH_1000_MB_FULL is choosen", "EthernetSwitchPort");
        }
    }

    private Struct convertStructParameter2Struct(StructParameter structParameter, String string, String string2) throws MoAccessException {
        String[] stringArray = new String[]{string, string2};
        Object[] objectArray = new Object[]{MaoFroTypeConverter.int2boolean((int)((SignedIntParameter)structParameter.get(string)).getValue()), new Integer(((SignedIntParameter)structParameter.get(string2)).getValue())};
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    private Struct convertStructParameter2Struct(StructParameter structParameter, String string, String string2, String string3) throws MoAccessException {
        String[] stringArray = new String[]{string, string2, string3};
        Object[] objectArray = new Object[]{((StringParameter)structParameter.get(string)).getValue(), new Integer(((SignedIntParameter)structParameter.get(string2)).getValue()), ((StringParameter)structParameter.get(string3)).getValue()};
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    private static StructParameter makeStructParameter(Struct struct) throws MoAccessException {
        StructParameter structParameter = new StructParameter("operatingMode");
        int n = MaoFroTypeConverter.boolean2int((boolean)((Boolean)struct.getValue("autoNegotiation")));
        structParameter.add((Parameter)new SignedIntParameter("autoNegotiation", n));
        structParameter.add((Parameter)new SignedIntParameter("configuredSpeedDuplex", ((Integer)struct.getValue("configuredSpeedDuplex")).intValue()));
        return structParameter;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public int getFroType() throws MoAccessException {
        return Integer.parseInt("D01", 16);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ethernetSwitchPortProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private static void checkUntaggedIngressVidIsWithinVlanMembership(Struct[] structArray, int n) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            if ((Integer)structArray[i].getValue("vid") != n) continue;
            bl = true;
        }
        if (!bl) {
            throw new OperationNotAllowedException("UntaggedIngressVid is not part of vlanMembership.", "EthernetSwitchPort");
        }
    }

    public static void checkPortNo(ManagedObject managedObject, String string, int n, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        while (moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof EthernetSwitchPortMoImpl) || ((EthernetSwitchPortMoImpl)managedObject2).getPortNo(coordinator) != n) continue;
            throw new AttrValueNotUniqueException("PortNo is not unique", string);
        }
    }
}

