/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;

public class AlarmSuppressionAction
extends CabinetViewerAction {
    private static final String ACTION_DISPLAY_NAME_ALARM_SUPPRESSION = "Alarm Suppression";
    private final String ATTRIBUTE_ALARMSUPPRESSED = "alarmSuppressed";
    private Mo mo;
    private String ldn;
    private String msg;

    public AlarmSuppressionAction(Operable operable) {
        super(operable, ACTION_DISPLAY_NAME_ALARM_SUPPRESSION, "");
        this.init();
    }

    private void init() {
        this.ldn = this.operable.getTargetMoLdnForAlarmSuppression();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
    }

    private void suppressAlarm(boolean bl) {
        Transaction transaction = null;
        try {
            CmService cmService = this.getCmService();
            Mo mo = this.mo;
            NameValue nameValue = cmService.getNameValueFactory().create("alarmSuppressed", bl);
            transaction = cmService.createTransaction();
            mo.setAttribute(nameValue, transaction);
            transaction.commit();
        }
        catch (Exception exception) {
            if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        bl = null != string && string.contains("ON");
        this.suppressAlarm(bl);
    }

    @Override
    protected void performTheAction() {
    }

    @Override
    protected String getText() {
        return null;
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }
}

