/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.SaveLogs;
import se.ericsson.wcdma.rbs.cabinetviewer.guitestsupport.GuiTestEventTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;

public class DisplayLogs
extends JFrame {
    private static DisplayLogs theInstance = null;
    final JTabbedPane pane;
    final JPanel buttonPanel;
    static final int INITIAL_FRAME_WIDTH = 900;
    static final int INITIAL_FRAME_HEIGHT = 600;
    final SaveAction saveAction;
    final CloseAction closeAction;
    final FindAction findAction;
    final ExitAction exitAction;
    private boolean findErrorMode;
    private String currentSearchString = "";
    static final String findErrorMsg = "Could not find phrase";
    final JLabel findErrorLabel = new JLabel("Could not find phrase");
    private JTextField searchField;
    SaveLogs saveLogs;
    private CvSession cvSession = null;

    DisplayLogs(SaveLogs saveLogs) {
        this.saveLogs = saveLogs;
        this.pane = new JTabbedPane();
        this.saveAction = new SaveAction();
        this.findAction = new FindAction();
        this.closeAction = new CloseAction();
        this.exitAction = new ExitAction();
        this.buttonPanel = this.createBottomPanel();
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        JMenuBar jMenuBar = this.createMenubar();
        this.setJMenuBar(jMenuBar);
        this.positionFrame();
        this.pane.addChangeListener(new TabChangeListener(this));
        this.addWindowListener(new ExitListener());
    }

    DisplayLogs(SaveLogs saveLogs, CvSession cvSession) {
        this(saveLogs);
        this.cvSession = cvSession;
    }

    private void positionFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 600;
        int n2 = 900;
        if (n > dimension.height) {
            n = dimension.height;
        }
        if (n2 > dimension.width) {
            n2 = dimension.width;
        }
        this.setSize(n2, n);
        Dimension dimension2 = new Dimension(n2, n);
        this.setPreferredSize(dimension2);
        this.setMaximumSize(dimension2);
        this.setLocation(dimension.width / 2 - n2 / 2, dimension.height / 2 - n / 2);
    }

    public void displayLog(String string, String string2) {
        if (!this.isVisible()) {
            this.cleanupOnExit();
            this.positionFrame();
        }
        this.enableActions();
        JComponent jComponent = null;
        jComponent = System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true") ? this.createTextPanel(string2, string) : this.createTextPanel(string2);
        this.pane.add(string, jComponent);
        this.pack();
        this.setVisible(true);
        int n = this.pane.getTabCount();
        this.pane.setSelectedIndex(n - 1);
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.cvSession.getCvSessionController().sendNotification(GuiTestEventTypes.LOG_ADDED, "Adding log with title " + string);
        }
    }

    private JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Find");
        jMenuItem.setAction(this.findAction);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setAction(this.saveAction);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setAction(this.closeAction);
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.setAction(this.exitAction);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private JComponent createTextPanel(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setCaretPosition(0);
        return new JScrollPane(jTextArea);
    }

    private JComponent createTextPanel(String string, String string2) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setName(string2);
        jTextArea.setCaretPosition(0);
        return new JScrollPane(jTextArea);
    }

    private JPanel createBottomPanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Search for:");
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.createFindPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.createButtonPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createFindPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.searchField = new JTextField("", 40);
        this.searchField.getDocument().addDocumentListener(new FindTextListener(this));
        jPanel.add(this.searchField);
        JButton jButton = new JButton("Find");
        jButton.setAction(this.findAction);
        jPanel.add(jButton);
        jPanel.add(this.findErrorLabel);
        this.findErrorLabel.setVisible(false);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Save");
        jButton.setAction(this.saveAction);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.setAction(this.closeAction);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Exit");
        jButton3.setAction(this.exitAction);
        jPanel.add(jButton3);
        return jPanel;
    }

    void disableActions() {
        this.saveAction.setEnabled(false);
        this.closeAction.setEnabled(false);
        this.findAction.setEnabled(false);
    }

    private void enableActions() {
        this.saveAction.setEnabled(true);
        this.closeAction.setEnabled(true);
        this.findAction.setEnabled(true);
    }

    void cleanupOnExit() {
        this.pane.removeAll();
        this.setFindError(false);
        this.disableActions();
        this.setVisible(false);
        this.searchField.setText("");
    }

    void setFindError(boolean bl) {
        if (bl) {
            this.findErrorMode = true;
            this.searchField.setForeground(Color.RED);
            this.findErrorLabel.setVisible(true);
            this.removeAllHighLightsInCurrentTab();
        } else {
            this.findErrorMode = false;
            this.searchField.setForeground(Color.BLACK);
            this.findErrorLabel.setVisible(false);
        }
    }

    String getCurrentTabText() {
        JScrollPane jScrollPane = (JScrollPane)this.pane.getSelectedComponent();
        JViewport jViewport = jScrollPane.getViewport();
        JTextArea jTextArea = (JTextArea)jViewport.getView();
        return jTextArea.getText();
    }

    String getCurrentDefaultName() {
        int n = this.pane.getSelectedIndex();
        return this.pane.getTitleAt(n);
    }

    void removeAllHighLightsInCurrentTab() {
        int n = this.pane.getSelectedIndex();
        if (n >= 0) {
            JScrollPane jScrollPane = (JScrollPane)this.pane.getComponentAt(n);
            JTextArea jTextArea = (JTextArea)jScrollPane.getViewport().getView();
            Highlighter highlighter = jTextArea.getHighlighter();
            highlighter.removeAllHighlights();
        }
    }

    class ExitListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DisplayLogs.this.cleanupOnExit();
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayLogs.this.cleanupOnExit();
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = DisplayLogs.this.pane.getSelectedIndex();
            DisplayLogs.this.pane.remove(n);
            if (DisplayLogs.this.pane.getTabCount() < 1) {
                DisplayLogs.this.disableActions();
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = DisplayLogs.this.getCurrentTabText();
            String string2 = DisplayLogs.this.getCurrentDefaultName();
            DisplayLogs.this.saveLogs.saveTheLog(string, string2);
        }
    }

    class TabChangeListener
    implements ChangeListener {
        DisplayLogs displayLogs;

        public TabChangeListener(DisplayLogs displayLogs2) {
            this.displayLogs = displayLogs2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.displayLogs.setFindError(false);
        }
    }

    class FindTextListener
    implements DocumentListener {
        DisplayLogs displayLogs;

        public FindTextListener(DisplayLogs displayLogs2) {
            this.displayLogs = displayLogs2;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        private void handleChange() {
            if (DisplayLogs.this.findErrorMode) {
                this.displayLogs.setFindError(false);
            }
        }
    }

    class FindAction
    extends AbstractAction {
        public FindAction() {
            super("Find");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            DisplayLogs.this.removeAllHighLightsInCurrentTab();
            JScrollPane jScrollPane = (JScrollPane)DisplayLogs.this.pane.getSelectedComponent();
            JViewport jViewport = jScrollPane.getViewport();
            JTextArea jTextArea = (JTextArea)jViewport.getView();
            String string = jTextArea.getText();
            String string2 = string.toLowerCase();
            String string3 = DisplayLogs.this.searchField.getText().toLowerCase();
            if (!DisplayLogs.this.currentSearchString.equals(string3)) {
                DisplayLogs.this.setFindError(false);
            }
            DisplayLogs.this.currentSearchString = string3;
            int n2 = jTextArea.getCaretPosition();
            if (n2 >= string2.length()) {
                n2 = 0;
            }
            if ((n = string2.indexOf(DisplayLogs.this.currentSearchString, n2)) == -1 && n2 != 0) {
                n2 = 0;
                n = string2.indexOf(DisplayLogs.this.currentSearchString, n2);
            }
            if (n != -1) {
                int n3 = n + DisplayLogs.this.currentSearchString.length();
                this.highLightFoundArea(jTextArea, n, n3);
            } else {
                DisplayLogs.this.setFindError(true);
            }
        }

        private void highLightFoundArea(JTextArea jTextArea, int n, int n2) {
            Highlighter highlighter = jTextArea.getHighlighter();
            try {
                highlighter.addHighlight(n, n2, DefaultHighlighter.DefaultPainter);
                int n3 = n2;
                if (n2 - n > 1) {
                    n3 = (n2 - n) / 2 + n;
                }
                jTextArea.setCaretPosition(n3);
                jTextArea.repaint();
            }
            catch (BadLocationException badLocationException) {
                Trace.warning(this, badLocationException.getMessage() + badLocationException);
            }
        }
    }
}

