/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ManualRestart;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Restart;

public class NodeRestart
extends Restart {
    private static final String EXECUTING_CV = "Executing CV";
    protected JComboBox cvComboBox = null;
    final ManualRestart manualRestart;

    public NodeRestart(Operable operable) {
        super(operable);
        this.manualRestart = new ManualRestart(operable.getCvSession().getCvSessionController().getMainWindofFrame());
    }

    public NodeRestart() {
        this.manualRestart = new ManualRestart(null);
    }

    @Override
    protected void performTheAction() {
        if (this.isStartWithoutGui()) {
            this.manualRestart();
        } else {
            String string = (String)this.cvComboBox.getSelectedItem();
            boolean bl = this.setStartableCv(string);
            if (!bl) {
                return;
            }
            this.manualRestart();
        }
    }

    private void manualRestart() {
        Transaction transaction = null;
        try {
            Trace.observation(this, "Restart: " + this.operable.getViewableObjectName());
            transaction = this.getCmService().createTransaction();
            NameValue[] nameValueArray = null;
            nameValueArray = new NameValue[]{this.getCmService().getNameValueFactory().create("restartRank", this.manualRestart.getRank()), this.getCmService().getNameValueFactory().create("restartReason", this.manualRestart.getReason()), this.getCmService().getNameValueFactory().create("restartInfo", this.manualRestart.getInfo())};
            this.getMo().action("manualRestart", nameValueArray, transaction);
            transaction.commit();
        }
        catch (CmException cmException) {
            this.showConnectionError((Exception)((Object)cmException));
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                Trace.error(this, "Rollback failed. " + exception);
            }
        }
        catch (Exception exception) {
            this.showOperationError(exception);
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
    }

    private boolean setStartableCv(String string) {
        boolean bl = false;
        Transaction transaction = null;
        NameValue[] nameValueArray = null;
        try {
            Mo mo = this.cmService.getMo("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
            if (string.equalsIgnoreCase(EXECUTING_CV)) {
                if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("false")) {
                    transaction = this.cmService.createNullTransaction();
                }
                NameValue nameValue = mo.getAttribute("executingCv", null);
                nameValueArray = new NameValue[]{this.cmService.getNameValueFactory().create("newCV", nameValue.getStringValue())};
            } else {
                nameValueArray = new NameValue[]{this.cmService.getNameValueFactory().create("newCV", string)};
            }
            transaction = this.cmService.createTransaction();
            mo.action("setStartable", nameValueArray, transaction);
            transaction.commit();
            bl = true;
        }
        catch (CmException cmException) {
            this.showConnectionError((Exception)((Object)cmException));
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                Trace.error(this, "Rollback failed. " + exception);
            }
            bl = false;
        }
        catch (Exception exception) {
            this.showOperationError(exception);
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
            bl = false;
        }
        return bl;
    }

    @Override
    protected String getText() {
        return "Please choose the configuration version you wish to use for restarting!";
    }

    protected boolean verifyInput() {
        return this.manualRestart.verifyInput();
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.cvComboBox = new JComboBox<String>(this.getStoredConfigurationVersions());
        this.cvComboBox.setName("cvComboBox");
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.cvComboBox, gridBagConstraints);
        this.manualRestart.clear();
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.manualRestart.getPanel(), gridBagConstraints);
    }

    private String[] getStoredConfigurationVersions() {
        String[] stringArray = new String[]{""};
        try {
            CmService cmService = this.getCmService();
            Mo mo = cmService.getMo("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
            NameValue nameValue = mo.getAttribute("storedConfigurationVersions", null);
            Object object = nameValue.getValue();
            if (object instanceof Struct[]) {
                stringArray = this.extractNames((Struct[])object);
            } else if (object instanceof String[]) {
                stringArray = this.extractNames((String[])object);
            } else {
                Trace.error(this, "Unable to extract the names of CVs stored on the node");
            }
        }
        catch (Exception exception) {
            Trace.error(this, "Unable to extract the names of CVs stored on the node", exception);
        }
        return stringArray;
    }

    private String[] extractNames(Struct[] structArray) {
        String[] stringArray = new String[structArray.length + 1];
        stringArray[0] = EXECUTING_CV;
        for (int i = 0; i < structArray.length; ++i) {
            NameValue nameValue = structArray[i].getMember("Name");
            stringArray[i + 1] = (String)nameValue.getValue();
        }
        return stringArray;
    }

    private String[] extractNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = EXECUTING_CV;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("Name#");
            int n2 = stringArray[i].indexOf("~", n);
            String string = stringArray[i].substring(n, n2);
            stringArray2[i + 1] = string.substring(string.indexOf("#") + 1);
        }
        return stringArray2;
    }
}

