/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedRepaintListener;

public class LED
extends JPanel
implements LedRepaintListener {
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String YELLOW = "yellow";
    private static final String BLUE = "blue";
    private static final String NOT_AVAILABLE = "not_available";
    private static final String GRAY = "gray";
    private static final String WHITE = "white";
    private BufferedImage onImage;
    private BufferedImage offImage;
    private BufferedImage currentImage;
    private int delay = 0;
    String colorLink;
    private String colorName;
    private int statusType = -1;
    private int currentState = 0;
    private String attribute;
    private int position = 0;
    private Map<Integer, List<Integer>> blinkPatterns;
    private List currentBlinkPattern;
    private int currentBlinkPatternEntryIndex = 0;
    private static final HashMap<String, String> colorLinks = new HashMap();

    @Override
    public void doRepaintStep() {
        if (this.delay == 0) {
            this.setNextDelay();
            return;
        }
        --this.currentState;
        if (this.currentState <= 0) {
            this.currentImage = this.currentBlinkPatternEntryIndex % 2 == 0 ? this.onImage : this.offImage;
            this.setNextDelay();
            this.currentState = this.delay;
            this.repaint();
        }
    }

    public void update(int n) {
        this.statusType = n;
        if (this.getParent() != null) {
            this.setBackground(this.getParent().getBackground());
        }
        switch (n) {
            case 0: {
                this.delay = 0;
                this.colorLink = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/EmptyImage.gif";
                break;
            }
            case 1: {
                this.delay = 0;
                this.colorLink = this.getColorFromName(NOT_AVAILABLE);
                break;
            }
            case 2: {
                this.delay = 0;
                this.colorLink = this.getColorFromName(GRAY);
                break;
            }
            default: {
                this.colorLink = this.getColorFromName(this.colorName);
            }
        }
        if (this.blinkPatterns != null) {
            this.currentBlinkPattern = this.blinkPatterns.get(n);
        }
        if (this.currentBlinkPattern != null) {
            this.currentBlinkPatternEntryIndex = 0;
            this.setNextDelay();
            this.currentState = this.delay + (int)(Math.random() * 100.0);
        }
        if (this.currentBlinkPattern == null && n > 2) {
            this.delay = 0;
            this.colorLink = this.getColorFromName(WHITE);
        }
        this.offImage = this.loadImage(this.getColorFromName(GRAY));
        this.currentImage = this.onImage = this.loadImage(this.colorLink);
        this.repaint();
    }

    private BufferedImage loadImage(String string) {
        if (string == null) {
            return null;
        }
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            URL uRL = this.getClass().getResource(string);
            BufferedImage bufferedImage = ImageIO.read(uRL);
            BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (Exception exception) {
            Trace.error(this, "Unable to load image: " + string, exception);
            return null;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.currentImage != null) {
            graphics.drawImage(this.currentImage, 0, 0, this);
        }
    }

    public void dispose() {
    }

    public String getColorFromName(String string) {
        String string2 = colorLinks.get(string.toLowerCase());
        if (string2 == null) {
            string2 = colorLinks.get(WHITE);
        }
        return string2;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getStatusType() {
        return this.statusType;
    }

    private void setNextDelay() {
        if (this.currentBlinkPattern != null) {
            if (this.currentBlinkPatternEntryIndex >= this.currentBlinkPattern.size()) {
                this.currentBlinkPatternEntryIndex = 0;
            }
            this.delay = (Integer)this.currentBlinkPattern.get(this.currentBlinkPatternEntryIndex);
            this.delay /= 30;
            ++this.currentBlinkPatternEntryIndex;
        }
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColor(String string) {
        this.colorName = string;
    }

    public void setBlinkPattern(Map<Integer, List<Integer>> map) {
        this.blinkPatterns = map;
    }

    static {
        colorLinks.put(GREEN, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_green.gif");
        colorLinks.put(RED, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_red.gif");
        colorLinks.put(YELLOW, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_yellow.gif");
        colorLinks.put(BLUE, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_blue.gif");
        colorLinks.put(NOT_AVAILABLE, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/not_available.gif");
        colorLinks.put(GRAY, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_gray.gif");
        colorLinks.put(WHITE, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/led/led_white.gif");
    }

    public static class LedComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = 0;
            LED lED = (LED)object;
            LED lED2 = (LED)object2;
            int n2 = lED.getPosition();
            int n3 = lED2.getPosition();
            if (n2 > 0 && n3 > 0) {
                if (n2 > n3) {
                    n = 1;
                } else if (n2 < n3) {
                    n = -1;
                }
            }
            return n;
        }
    }
}

