/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.definitions.LedStatusTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.common.definitions.LedTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LED;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class LedGroupLegacy
extends LedGroup {
    public LedGroupLegacy() {
        this.leds = new TreeMap();
        for (LedTypes.LedTypes3000 ledTypes3000 : LedTypes.LedTypes3000.values()) {
            LED lED = new LED();
            String string = LedTypes.mimLedTypes.get((Object)ledTypes3000);
            int n = 1;
            if ("greenLed".equals(string)) {
                n = 2;
            } else if ("yellowLed".equals(string)) {
                n = 3;
            }
            lED.setPosition(n);
            lED.setColor(ledTypes3000.toString());
            lED.update(1);
            lED.setBlinkPattern(this.createBlinkPattern());
            this.leds.put(string, lED);
        }
    }

    private Map<Integer, List<Integer>> createBlinkPattern() {
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        arrayList.add(10);
        hashMap.put(2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(10);
        arrayList.add(0);
        hashMap.put(3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(2000);
        arrayList.add(2000);
        hashMap.put(4, arrayList);
        arrayList = new ArrayList();
        arrayList.add(500);
        arrayList.add(500);
        hashMap.put(5, arrayList);
        arrayList = new ArrayList();
        arrayList.add(62);
        arrayList.add(62);
        hashMap.put(6, arrayList);
        return hashMap;
    }

    @Override
    public void updateLedGroup(VoData voData) {
        this.voData = voData;
        try {
            if (this.isPiuOrAuxPiu()) {
                this.updateFromPiuOrAuxPiu();
            } else {
                this.updateFromProperty();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLedStatusColi(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : this.leds.entrySet()) {
                LED lED = (LED)entry.getValue();
                String string = lED.getColorName();
                Object v = map.get(string);
                int n = this.toStateIndex(v);
                if (n < 0 || n > 6) {
                    n = 1;
                }
                lED.update(n);
            }
        }
    }

    private int toStateIndex(Object object) {
        Integer n;
        String string;
        if (object instanceof String && LedStatusTypes.coliMimMapping.containsKey(string = (String)object) && (n = (Integer)LedStatusTypes.coliMimMapping.get(string)) != null) {
            return n;
        }
        return 1;
    }

    private void updateFromProperty() {
        Integer n = 0;
        String string = null;
        for (Map.Entry entry : this.leds.entrySet()) {
            LED lED = (LED)entry.getValue();
            String string2 = lED.getColorName();
            String string3 = LedTypes.ledTypesMoProperty.get((Object)LedTypes.LedTypes3000.getElement(string2));
            NameValue nameValue = this.voData.getPropertyValue(string3);
            if (nameValue != null) {
                string = ((List)nameValue.getValue()).get(0).toString();
                n = (Integer)this.voData.getValue(nameValue.getName(), string);
            }
            lED.update(n);
        }
    }

    private void updateFromPiuOrAuxPiu() {
        String[] stringArray = this.voData.getLdns("*PlugInUnit");
        Integer n = 0;
        for (Map.Entry entry : this.leds.entrySet()) {
            LED lED = (LED)entry.getValue();
            String string = lED.getColorName();
            String string2 = LedTypes.mimLedTypes.get((Object)LedTypes.LedTypes3000.getElement(string));
            n = (Integer)this.voData.getValue(stringArray[0], string2);
            if (n == null) continue;
            lED.update(n);
        }
    }

    private boolean isPiuOrAuxPiu() {
        String[] stringArray = this.voData.getLdns("*PlugInUnit");
        return stringArray.length > 0;
    }
}

