/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.CurrentVisualHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.HorizontalLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.NotifyUpdateManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.provider.ResourcesPathProvider;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class SectorUnitView
extends VoView
implements ResourcesPathProvider {
    private HorizontalLabel unitLabel;
    private StateOrLedPanel stateOrLedPanel;
    private ImageIcon imageIcon;
    private GridBagConstraints constraints;
    protected CurrentVisualHandler currentVisualHandlerPanel = null;

    public SectorUnitView(VoData voData, Hashtable hashtable) {
        super(voData);
        this.copyProperties(hashtable);
        String string = voData.getSpecificType();
        if (!voData.isPrefixVisible()) {
            this.setToolTipText(voData.getCustomPrefix() + " " + string);
        }
        if (string.equals("AntennaBranch")) {
            voData.setCustomLabel("");
            String string2 = ((ViewableObject)voData).getTopMo().getName();
            this.setToolTipText("Antenna Branch " + string2);
            this.setName("Antenna " + string2);
        } else if (string.equals("RRU")) {
            ArrayList arrayList = this.getSectorNumber(((ViewableObject)voData).getAttributesReport());
            String string3 = this.getToolTipTextRRU(arrayList);
            this.setToolTipText("RRU" + string3);
            if (((ViewableObject)voData).getProductName().startsWith("Radio")) {
                this.setName("Radio");
                this.setToolTipText("Radio" + string3);
            }
        } else {
            this.setName(voData.getSpecificType());
        }
        this.buildSectorUnitGui();
        if (voData.getProperty("NOTIFY_UPDATE") != null) {
            voData.addVoDataListener(new NotifyUpdateManager(this));
        }
    }

    public SectorUnitView(String string, Hashtable hashtable) {
        super(string);
        this.copyProperties(hashtable);
        this.buildSectorUnitGui();
    }

    @Override
    public void setLabel(String string) {
        this.unitLabel.setText(string);
    }

    @Override
    public void setSelectionManager(VoSelectionManager voSelectionManager) {
        super.setSelectionManager(voSelectionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setSelectionManager(voSelectionManager);
        }
    }

    @Override
    public void setLedViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setLedViewActive();
        }
    }

    @Override
    public void setStateViewActive() {
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setStateViewActive();
        }
    }

    @Override
    public void setActionManager(ActionManager actionManager) {
        super.setActionManager(actionManager);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setActionManager(actionManager);
        }
    }

    public void buildSectorUnitGui() {
        super.initialise();
        this.setLayout(new GridBagLayout());
        this.buildDefaultSectorUnitGui();
        this.createGridBagConstraints();
    }

    private void buildDefaultSectorUnitGui() {
        InfoView infoView;
        this.unitLabel = new HorizontalLabel(this.getName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.unitLabel, gridBagConstraints);
        VoData voData = this.getVoData();
        JLabel jLabel = this.createImageIconJPanel();
        if (jLabel != null) {
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 1;
            this.add((Component)jLabel, gridBagConstraints);
            this.addSubRRUImageIcon(this.getSectorNumber(((ViewableObject)voData).getAttributesReport()), gridBagConstraints);
        }
        if (voData != null && voData instanceof StateViewable && (infoView = ((StateViewable)((Object)voData)).getInfoView("stateView")) != null) {
            this.stateOrLedPanel = new StateOrLedPanel(voData, this.getToolTipText());
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.stateOrLedPanel, gridBagConstraints);
        }
    }

    /*
     * Unable to fully structure code
     */
    private JLabel createImageIconJPanel() {
        block3: {
            block6: {
                block5: {
                    block4: {
                        var1_1 = this.getVoData();
                        if (var1_1 == null) {
                            return null;
                        }
                        var2_2 = var1_1.getSpecificType();
                        var3_3 = null;
                        var4_4 = null;
                        var3_3 = var1_1.getVoLayoutDataProvider().getImageName();
                        if (var3_3 != null && !var3_3.equals("")) break block3;
                        if (var2_2.equals("AntennaBranch")) break block4;
                        if (!var2_2.equals("AntennaUnit")) break block5;
                    }
                    var3_3 = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/AntennaBranch.gif";
                    break block3;
                }
                if (!var2_2.endsWith("RET")) break block6;
                var3_3 = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/RET.gif";
                break block3;
            }
            if (var2_2.equals("ExternalTma")) ** GOTO lbl27
            if (var2_2.equals("ATMA")) {
lbl27:
                // 2 sources

                var3_3 = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/TMA.gif";
            } else {
                var3_3 = var2_2.equals("RRU") ? "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/RRU.gif" : (var2_2.equals("ASC") ? "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/AntennaSystemControl.gif" : "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/EmptyImage.gif");
            }
        }
        var4_4 = SectorUnitView.IMAGE_LOCATION_IN_VOB + var3_3;
        var5_5 = this.getClass().getResource(var3_3);
        this.imageIcon = var5_5 != null ? new ImageIcon(var5_5) : new ImageIcon(var4_4);
        var6_6 = new JLabel();
        var6_6.setIcon(this.imageIcon);
        return var6_6;
    }

    private void createGridBagConstraints() {
        this.constraints = new GridBagConstraints();
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 11;
        String string = this.getVoData().getSpecificType();
        if (string != null) {
            this.constraints.insets = string.equals("RRU") ? new Insets(14, 4, 16, 4) : new Insets(4, 4, 4, 4);
        }
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.constraints;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setBackground(color);
        }
        if (this.currentVisualHandlerPanel != null) {
            this.currentVisualHandlerPanel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.setForeground(color);
        }
        if (this.currentVisualHandlerPanel != null) {
            this.currentVisualHandlerPanel.setForeground(color);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.stateOrLedPanel != null) {
            this.stateOrLedPanel.cleanUp();
        }
    }

    public ArrayList getSectorNumber(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || "".equals(string)) {
            return arrayList;
        }
        String string2 = string.indexOf("SectorEquipmentFunctionId") != -1 ? " +SectorEquipmentFunctionId = .+" : " +SectorId = .+";
        Matcher matcher = this.pickUpString(string2, string);
        while (matcher.find()) {
            String string3 = matcher.group().toString().trim();
            String string4 = string3.substring(string3.indexOf("=") + 1).trim();
            arrayList.add(string4);
        }
        return arrayList;
    }

    public String getToolTipTextRRU(ArrayList<String> arrayList) {
        if (arrayList.size() == 0) {
            return "";
        }
        String string = ": ";
        for (String string2 : arrayList) {
            string = string + "Sector" + string2 + " ";
        }
        return string.trim();
    }

    public Matcher pickUpString(String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2);
        return matcher;
    }

    public void addSubRRUImageIcon(ArrayList<String> arrayList, GridBagConstraints gridBagConstraints) {
        int n = 0;
        while (n < arrayList.size()) {
            JLabel jLabel = this.createImageIconJPanel();
            gridBagConstraints.gridx = n++;
            this.add((Component)jLabel, gridBagConstraints);
        }
    }
}

