/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state;

import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state.StateImageJLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

public class AvailabilityStateJLabel
extends StateImageJLabel
implements VoDataListener {
    public static final int NO_STATUS = 0;
    public static final int IN_TEST = 1;
    public static final int FAILED = 2;
    public static final int POWER_OFF = 4;
    public static final int OFF_LINE = 8;
    public static final int OFF_DUTY = 16;
    public static final int DEGRADED = 64;
    public static final int NOT_INSTALLED = 128;
    public static final int LOG_FULL = 256;
    public static final int DEPENDENCY_LOCKED = 544;
    public static final int DEPENDENCY_FAILED = 1056;
    public static final int[] ORDER_OF_PRIORITY = new int[12];
    private ImageIcon imageIcon;

    public AvailabilityStateJLabel(VoData voData) {
        this(voData, -1);
    }

    public AvailabilityStateJLabel(VoData voData, int n) {
        super(voData, n);
        voData.addVoDataListener(this);
    }

    @Override
    protected void setStateMapping() {
        Map map = this.getStateMapping();
        map.put(0, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif");
        map.put(1, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(2, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(4, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(8, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(16, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(64, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(128, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(256, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailState.gif");
        map.put(544, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailStateDependencyLocked.gif");
        map.put(1056, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailStateDependencyLocked.gif");
        map.put(1024, "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AvailStateDependencyLocked.gif");
    }

    @Override
    protected void updateCurrentState(Object object) {
        int n;
        if (object == null || object instanceof Object[]) {
            return;
        }
        int n2 = n = this.getCurrentState();
        try {
            n2 = (Integer)object;
            if (n != n2) {
                this.setCurrentState(n2);
                this.createImageIcon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void createImageIcon() {
        String string = this.getFileName(this.getCurrentState());
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            this.imageIcon = new ImageIcon(uRL);
        } else {
            String string2 = IMAGE_LOCATION_IN_VOB + string;
            this.imageIcon = new ImageIcon(string2);
        }
        this.setIcon(this.imageIcon);
    }

    private String getFileName(int n) {
        if (n == -1) {
            return "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
        }
        for (int i = 0; i < ORDER_OF_PRIORITY.length; ++i) {
            int n2 = n & ORDER_OF_PRIORITY[i];
            if (n2 != ORDER_OF_PRIORITY[i]) continue;
            Object v = this.getStateMapping().get(new Integer(n2));
            if (v != null) {
                return v.toString();
            }
            return "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
        }
        return "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
    }

    private void updateToolTipText() {
        int n = this.getCurrentState();
        if (n == 0) {
            JComponent jComponent;
            VoData voData = this.getVoData();
            if (voData != null && (jComponent = (JComponent)this.getParent()) != null) {
                String string = jComponent.getToolTipText();
                this.setToolTipText(string);
            }
        } else {
            StateViewable stateViewable = (StateViewable)((Object)this.getVoData());
            Object object = stateViewable.getAvailabilityStatusString();
            if (object != null) {
                String string = object.toString();
                this.setToolTipText(string);
            }
        }
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        Object object = ((StateViewable)((Object)voData)).getAvailabilityStatus();
        this.updateCurrentState(object);
        this.updateToolTipText();
        this.repaint();
    }

    static {
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[0] = 128;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[1] = 4;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[2] = 1;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[3] = 544;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[4] = 1056;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[5] = 1024;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[6] = 2;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[7] = 8;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[8] = 64;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[9] = 16;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[10] = 256;
        AvailabilityStateJLabel.ORDER_OF_PRIORITY[11] = 0;
    }
}

