/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.provider.ResourcesPathProvider;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public abstract class StateImageJLabel
extends JLabel
implements ResourcesPathProvider {
    public static final int UNAVAILABLE = -1;
    private VoData voData;
    private int currentState = -1;
    private Map stateMapping = new HashMap();

    public StateImageJLabel(VoData voData, int n) {
        this.voData = voData;
        this.currentState = n;
        this.setStateMapping();
        this.createImageIcon();
    }

    protected VoData getVoData() {
        return this.voData;
    }

    protected Map getStateMapping() {
        return this.stateMapping;
    }

    protected int getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(int n) {
        this.currentState = n;
    }

    protected abstract void setStateMapping();

    protected void updateCurrentState(Object object) {
        if (object == null) {
            return;
        }
        Object v = this.stateMapping.get(object);
        int n = this.currentState;
        try {
            n = Integer.parseInt(v.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.currentState != n) {
            this.currentState = n;
            this.createImageIcon();
        }
    }

    protected abstract void createImageIcon();
}

