/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.util.Hashtable;
import java.util.Map;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.restrictions.Restriction;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class StructMemberExtractor
implements AttributeExtractor {
    private VoData vo;
    private String moName;
    private Restriction restriction;
    private String moAttributeName;
    private String structMemberName;
    private String structFilterMemberName = null;
    private String structFilterMemberValue = null;
    private static final String SPECIAL_MO_NAME = "AuxPlugInUnit";
    private static final String SPECIAL_MO_ATTRIBUTE_NAME = "specialIndicator";

    public StructMemberExtractor(VoData voData, String string, String string2, String string3) {
        this(voData, string, null, string2, string3);
    }

    public StructMemberExtractor(VoData voData, String string, Restriction restriction, String string2, String string3) {
        this.vo = voData;
        this.moName = string;
        this.restriction = restriction;
        this.moAttributeName = string2;
        this.structMemberName = string3;
    }

    public StructMemberExtractor(VoData voData, String string, Restriction restriction, String string2, String string3, String string4, String string5) {
        this(voData, string, restriction, string2, string3);
        this.structFilterMemberName = string4;
        this.structFilterMemberValue = string5;
    }

    @Override
    public void setVo(VoData voData) {
        this.vo = voData;
    }

    @Override
    public Object get() {
        String[] stringArray = this.vo.getLdns(this.moName);
        if (this.restriction != null && stringArray != null && stringArray.length >= 1) {
            for (String string : stringArray) {
                Hashtable<String, Object> hashtable = this.vo.getMoProperties(string);
                CachedMo cachedMo = this.vo.getCvSession().getCacheManager().getCachedMo(string);
                if (!this.restriction.isValid(cachedMo, hashtable)) continue;
                return this.getValue(string);
            }
            return null;
        }
        if (stringArray.length != 1) {
            return null;
        }
        return this.getValue(stringArray[0]);
    }

    private Object getValue(String string) {
        Object object;
        Object object2 = null;
        int n = 1;
        if (this.moAttributeName.contains("@")) {
            object = this.moAttributeName.substring(0, this.moAttributeName.indexOf("@"));
            object2 = this.vo.getValue(string, (String)object);
            n = Integer.valueOf(this.moAttributeName.substring(this.moAttributeName.indexOf("@") + 1, this.moAttributeName.length()));
            if (n < 0) {
                Trace.error(this, "Wrong defination in template: " + this.moAttributeName);
                return null;
            }
        } else {
            object2 = this.vo.getValue(string, this.moAttributeName);
        }
        if (object2 instanceof Struct) {
            object = (Struct)object2;
            NameValue nameValue = object.getMember(this.structMemberName);
            if (nameValue != null) {
                return nameValue.getValue();
            }
            return null;
        }
        if (object2 instanceof Struct[]) {
            object = (Struct[])object2;
            Object[] objectArray = new Object[((Struct[])object).length];
            NameValue nameValue = null;
            NameValue nameValue2 = null;
            if (this.structFilterMemberName == null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    nameValue = object[i].getMember(this.structMemberName);
                    if (nameValue == null) continue;
                    objectArray[i] = nameValue.getValue();
                }
                return objectArray;
            }
            int n2 = 0;
            for (int i = 0; i < ((Object)object).length; ++i) {
                nameValue2 = object[i].getMember(this.structFilterMemberName);
                if (nameValue2 == null || !((String)nameValue2.getValue()).equals(this.structFilterMemberValue) || (nameValue = object[i].getMember(this.structMemberName)) == null || ++n2 != n) continue;
                return nameValue.getValue();
            }
            if (this.moName.equals(SPECIAL_MO_NAME) && this.moAttributeName.equals(SPECIAL_MO_ATTRIBUTE_NAME)) {
                return 0;
            }
            return null;
        }
        if (object2 instanceof Map) {
            object = (Map)object2;
            return object.get(this.structMemberName);
        }
        return null;
    }

    public Object get(String string) {
        Struct struct;
        NameValue nameValue;
        Object object = this.vo.getValue(string, this.moAttributeName);
        if (object instanceof Struct && (nameValue = (struct = (Struct)object).getMember(this.structMemberName)) != null) {
            return nameValue.getValue();
        }
        return null;
    }

    @Override
    public boolean isExisting() {
        return this.vo.isExisting(this.moName);
    }

    @Override
    public String getAttributeName() {
        return this.moAttributeName;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{this.getAttributeName()};
    }

    @Override
    public String getKey() {
        return this.structMemberName;
    }

    @Override
    public String[] getKeys() {
        return new String[]{this.getKey()};
    }

    public String getMoName() {
        return this.moName;
    }

    public String getStructMemberName() {
        return this.structMemberName;
    }
}

