/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.ConnectionStatusListener;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalViewController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SectorViewerController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SectorViewerPhysicalView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StatePanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VirtualSectorContainerView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.StatusNotifListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.TechnicianPresentStatus;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.TechnicianPresentStatusListener;
import se.ericsson.wcdma.rbs.cabinetviewer.guitestsupport.GuiTestEventTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.PhysicalViewFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VibManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerModel;

public class MainWindowController
implements TreeSelectionListener,
VoSelectionListener,
ConnectionStatusListener,
TechnicianPresentStatusListener {
    private static final String SUPPORT_SYSTEM_AVAILABLE_ATTR = "supportSystemAvailable";
    private static final String TECHNICIAN_PRESENT_ATTR = "technicianPresent";
    private static final String ALARM_SUPPRESSION_ATTR = "alarmSuppressed";
    private MainWindowView mainWindowView;
    private CvSession cvSession;
    private ActionManager actionMgr;
    private PhysicalView physView = null;
    private JPanel[] summaryPanels;
    private SectorViewerController sectorViewerController;
    private TechnicianPresentStatus tpStatus;
    private ViewableObject selectedVo = null;

    public MainWindowController(CvSession cvSession, LauncherData launcherData) {
        this.cvSession = cvSession;
        VibManager vibManager = cvSession.getVibManager();
        List list = vibManager.getAllVos();
        VoRelationship voRelationship = vibManager.getTopVORelationship();
        vibManager.setMainWindowController(this);
        this.actionMgr = System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true") ? new ActionManager(launcherData, cvSession) : new ActionManager(launcherData);
        PhysicalViewFactory physicalViewFactory = new PhysicalViewFactory(this.actionMgr, cvSession);
        this.physView = physicalViewFactory.newPhysicalView(list, voRelationship);
        PhysicalViewController physicalViewController = this.physView.getController();
        physicalViewController.addVoSelectionListener(this);
        this.mainWindowView = new MainWindowView(this);
        this.enableMenuItemAlarmSuppression();
        this.mainWindowView.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Trace.observation(this, "Main Window closing...");
                MainWindowController.this.cvSession.getCvSessionController().exit();
            }
        });
        vibManager.setStatusNotifier(this.mainWindowView);
        this.mainWindowView.setStatusMessage("Processing...");
        this.mainWindowView.showStatus();
        ViewableObject viewableObject = physicalViewController.getTopVo();
        this.mainWindowView.setTitle(this.makeTitle(viewableObject));
        this.mainWindowView.setLeftPane(this.physView);
        physicalViewController.setSelection(null);
        this.requestGuiRefresh(viewableObject);
        this.mainWindowView.packAndCentralize();
        this.addListenerRecursevely(this.mainWindowView, this.actionMgr);
        cvSession.getNealManager().addConnectionListener(this);
    }

    public void setUpSectorViewer() {
        VibManager vibManager = this.cvSession.getVibManager();
        AbstractSectorViewerManager abstractSectorViewerManager = vibManager.getSectorViewerManager();
        AbstractSectorViewerModel abstractSectorViewerModel = abstractSectorViewerManager.getSectorViewerModel();
        JPanel jPanel = this.mainWindowView.getTaskbarManager().getTaskbar();
        JMenuBar jMenuBar = this.mainWindowView.getJMenuBar();
        JScrollPane jScrollPane = this.mainWindowView.getBrowserScroller();
        abstractSectorViewerModel.setGuiData(this.physView, jPanel, jMenuBar, jScrollPane);
        List<VoView> list = this.getListOfVoViewsForSectorViewer();
        abstractSectorViewerModel.matchListOfVoViews(list);
        SectorViewerPhysicalView sectorViewerPhysicalView = new SectorViewerPhysicalView(abstractSectorViewerModel);
        this.sectorViewerController = new SectorViewerController(abstractSectorViewerModel, sectorViewerPhysicalView);
        this.mainWindowView.initializeSectorViewer(sectorViewerPhysicalView);
        sectorViewerPhysicalView.setVisible(true);
    }

    public List<VoView> getListOfVoViewsForSectorViewer() {
        List<VoView> list = this.physView.getVoViews(this.physView);
        ArrayList<VoView> arrayList = new ArrayList<VoView>();
        for (int i = 0; i < list.size(); ++i) {
            VoView voView = list.get(i);
            if (!(voView instanceof StateOrLedPanel) && !(voView instanceof StatePanel) && !(voView instanceof VirtualContainerView) && !(voView instanceof VirtualSectorContainerView)) continue;
            arrayList.add(voView);
        }
        list.removeAll(arrayList);
        return list;
    }

    public SectorViewerController getSectorViewerController() {
        return this.sectorViewerController;
    }

    private void addListenerRecursevely(Component component, KeyListener keyListener) {
        component.removeKeyListener(keyListener);
        component.addKeyListener(keyListener);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == null) continue;
                this.addListenerRecursevely(componentArray[i], keyListener);
            }
        }
    }

    private void removeListenerRecursevely(Component component, KeyListener keyListener) {
        component.removeKeyListener(keyListener);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == null) continue;
                this.removeListenerRecursevely(componentArray[i], keyListener);
            }
        }
    }

    private String makeTitle(ViewableObject viewableObject) {
        String string = "ManagedElement=1";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(viewableObject.getValue(string, "productName"));
        stringBuffer.append(" ");
        stringBuffer.append(viewableObject.getValue(string, "userLabel"));
        stringBuffer.append(" - ");
        stringBuffer.append(this.removePortFromIp(this.cvSession.getIpAddress()));
        stringBuffer.append(" - ");
        stringBuffer.append("Cabinet Viewer");
        return stringBuffer.toString();
    }

    private String removePortFromIp(String string) {
        int n = string.lastIndexOf(":");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public void show() {
        this.mainWindowView.packAndCentralize();
        this.getPhysicalView().setLedViewActive();
        this.mainWindowView.repaint();
        this.mainWindowView.setVisible(true);
        this.mainWindowView.setState(0);
    }

    public void hide() {
        this.mainWindowView.setVisible(false);
    }

    public void exit() {
        if (this.tpStatus != null) {
            this.tpStatus.stop();
        }
        this.removeListenerRecursevely(this.mainWindowView, this.actionMgr);
        if (this.mainWindowView.getAlarmList() != null) {
            this.mainWindowView.getAlarmList().AlarmListApplicationRemoveEmNotificationListener();
        }
        this.mainWindowView.stop();
        this.mainWindowView.dispose();
        this.physView.cleanUp();
        this.actionMgr.stop();
        this.cvSession = null;
    }

    public ActionManager getActionManager() {
        return this.actionMgr;
    }

    public PhysicalView getPhysicalView() {
        return this.physView;
    }

    public CvSession getCvSession() {
        return this.cvSession;
    }

    public StatusNotifListener getStatusNotifier() {
        return this.mainWindowView;
    }

    @Override
    public void connectionLost() {
        this.mainWindowView.showConnected(false);
    }

    @Override
    public void reconnected() {
        this.mainWindowView.showConnected(true);
        this.getTopVo().refresh();
        if (this.tpStatus != null) {
            this.tpStatus.startThread();
        }
    }

    public void requestGuiRefresh(ViewableObject viewableObject) {
        if (this.physView == null) {
            Trace.warning(this, "Ignored requestGuiRefresh() - the phyView was null!");
            return;
        }
        PhysicalViewController physicalViewController = this.physView.getController();
        if (physicalViewController == null) {
            Trace.warning(this, "Ignored requestGuiRefresh() - the physController was null!");
            return;
        }
        if (physicalViewController.isSelected(viewableObject)) {
            this.refreshGui(viewableObject);
        }
    }

    public void setSelected(String string) {
        ViewableObject viewableObject = this.cvSession.getVibManager().getVo(string);
        if (viewableObject != null) {
            this.selectionChanged(viewableObject);
            this.physView.getController().setSelection(viewableObject);
        }
    }

    @Override
    public void selectionChanged(VoData voData) {
        ViewableObject viewableObject = (ViewableObject)voData;
        this.cvSession.getVibManager().prioritiseCaching(viewableObject);
        this.refreshGui(viewableObject);
        this.selectedVo = viewableObject;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            Trace.warning(this, "getNewLeadSelectionPath() returned null");
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof ViewableObject) {
                ViewableObject viewableObject = (ViewableObject)object2;
                this.cvSession.getVibManager().prioritiseCaching(viewableObject);
                this.refreshGui(viewableObject);
            } else {
                Trace.error(this, "Selected userObject was not a ViewableObject" + object2);
            }
        } else {
            Trace.error(this, "Selection was not a DefaultMutableTreeNode" + object);
        }
    }

    public JPanel[] getSummaryPanels() {
        return this.summaryPanels;
    }

    public void setSummaryPanels(JPanel[] jPanelArray) {
        if (jPanelArray != null) {
            this.summaryPanels = jPanelArray;
        }
        this.refreshGui(this.getTopVo());
        this.mainWindowView.packAndCentralize();
    }

    protected ViewableObject getTopVo() {
        PhysicalViewController physicalViewController = this.physView.getController();
        return physicalViewController.getTopVo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGui(final ViewableObject viewableObject) {
        MainWindowController mainWindowController = this;
        synchronized (mainWindowController) {
            this.actionMgr.updateActions(viewableObject);
            this.mainWindowView.updateToolbar();
            Component component = this.makeSummaryComponent(viewableObject);
            Component component2 = this.makeDetailsComponent(viewableObject);
            final Component[] componentArray = new Component[]{component, component2};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindowController.this.mainWindowView.setRightPane(componentArray, viewableObject.getLatestRefreshTime());
                    if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                        MainWindowController.this.getCvSession().getCvSessionController().sendNotification(GuiTestEventTypes.RIGHT_PANEL_UPDATED, "Right panel has been updated");
                    }
                }
            });
        }
    }

    public JFrame getMainWindow() {
        return this.mainWindowView;
    }

    protected Boolean supportsTechnicianPresent() {
        Boolean bl;
        CachedMo cachedMo = this.getCachedTechnicianPresentMo();
        if (cachedMo != null && (bl = (Boolean)cachedMo.getAttribute(SUPPORT_SYSTEM_AVAILABLE_ATTR)) != null && bl.booleanValue()) {
            return true;
        }
        return false;
    }

    protected Boolean supportsAlarmSuppressed() {
        Boolean bl;
        CachedMo cachedMo = this.getCachedAlarmSuppressedMo();
        if (cachedMo != null && (bl = (Boolean)cachedMo.getAttribute(SUPPORT_SYSTEM_AVAILABLE_ATTR)) != null && bl.booleanValue()) {
            return true;
        }
        return false;
    }

    protected Boolean getTechnicianPresentAttributeValue() {
        Object object;
        CachedMo cachedMo = this.getCachedTechnicianPresentMo();
        if (cachedMo != null && (object = cachedMo.getAttribute(TECHNICIAN_PRESENT_ATTR)) != null) {
            Boolean bl;
            if (object instanceof Boolean && (bl = (Boolean)object).booleanValue()) {
                return true;
            }
            return false;
        }
        return null;
    }

    private CachedMo getCachedTechnicianPresentMo() {
        CacheManager cacheManager;
        String string;
        CachedMo cachedMo = null;
        ViewableObject viewableObject = this.getPhysicalView().getController().findCabinetRbsVo();
        if (viewableObject != null && (string = viewableObject.getTargetMoLdnForTechnicianPresent()) != null && (cacheManager = this.cvSession.getCacheManager()) != null) {
            cachedMo = cacheManager.getCachedMo(string);
        }
        return cachedMo;
    }

    private CachedMo getCachedAlarmSuppressedMo() {
        CacheManager cacheManager;
        String string;
        CachedMo cachedMo = null;
        ViewableObject viewableObject = this.getPhysicalView().getController().findCabinetRbsVo();
        if (viewableObject != null && (string = viewableObject.getTargetMoLdnForAlarmSuppression()) != null && (cacheManager = this.cvSession.getCacheManager()) != null) {
            cachedMo = cacheManager.getCachedMo(string);
        }
        return cachedMo;
    }

    protected Boolean isTechnicianPresent() {
        Boolean bl;
        NameValue nameValue;
        Object object;
        Mo mo;
        CmService cmService;
        String string;
        ViewableObject viewableObject = this.getPhysicalView().getController().findCabinetRbsVo();
        if (viewableObject != null && (string = viewableObject.getTargetMoLdnForTechnicianPresent()) != null && (cmService = viewableObject.getCvSession().getNealManager().getCmService()) != null && (mo = cmService.getMo(string)) != null && (object = (nameValue = mo.getAttribute(TECHNICIAN_PRESENT_ATTR, null)).getValue()) != null && object instanceof Boolean && (bl = (Boolean)object).booleanValue()) {
            return true;
        }
        return false;
    }

    protected void enableMenuItemAlarmSuppression() {
        NameValue nameValue;
        Object object;
        Mo mo;
        CmService cmService;
        String string;
        ViewableObject viewableObject = this.getPhysicalView().getController().findCabinetRbsVo();
        boolean bl = false;
        if (null != viewableObject && null != (string = viewableObject.getTargetMoLdnForAlarmSuppression()) && null != (cmService = viewableObject.getCvSession().getNealManager().getCmService()) && null != (mo = cmService.getMo(string)) && null != (object = (nameValue = mo.getAttribute(ALARM_SUPPRESSION_ATTR, null)).getValue()) && object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        }
        if (bl) {
            this.mainWindowView.getItemAlarmSuppressionON().setEnabled(false);
            this.mainWindowView.getItemAlarmSuppressionOFF().setEnabled(true);
        } else {
            this.mainWindowView.getItemAlarmSuppressionON().setEnabled(true);
            this.mainWindowView.getItemAlarmSuppressionOFF().setEnabled(false);
        }
    }

    protected void startTechnicianPresentValuePolling() {
        ViewableObject viewableObject = this.getPhysicalView().getController().findCabinetRbsVo();
        this.tpStatus = new TechnicianPresentStatus(viewableObject);
        this.tpStatus.addTechnicianPresentValueListener(this);
    }

    protected void updateTpStatus(boolean bl) {
        if (this.tpStatus != null) {
            this.tpStatus.updateSavedTpValue(bl);
        }
        this.technicianPresentValueChanged(bl);
    }

    @Override
    public void technicianPresentValueChanged(boolean bl) {
        if (this.mainWindowView != null) {
            this.mainWindowView.setTechnicianPresent(bl);
            this.mainWindowView.enableClearTechnicianPresent(bl);
            this.selectedVo.forcedRefresh();
        }
    }

    private Component makeSummaryComponent(ViewableObject viewableObject) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("Summary");
        if (this.summaryPanels == null) {
            return jPanel;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        for (int i = 0; i < this.summaryPanels.length; ++i) {
            if (this.summaryPanels[i] instanceof InfoPanel) {
                ((InfoPanel)((Object)this.summaryPanels[i])).update(viewableObject);
                if (!((InfoPanel)((Object)this.summaryPanels[i])).isApplicable()) continue;
                jPanel.add((Component)this.summaryPanels[i], gridBagConstraints);
                ++gridBagConstraints.gridy;
                continue;
            }
            jPanel.add((Component)this.summaryPanels[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 100.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private Component makeDetailsComponent(ViewableObject viewableObject) {
        String string = viewableObject.getAttributesReport();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setEditable(false);
        jTextArea.setSelectionStart(0);
        jTextArea.setSelectionEnd(0);
        jTextArea.setName("Details");
        return jTextArea;
    }
}

