/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.CommandHandlingSession;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.ProgressWindowListener;

public class ProgressWindow
extends JFrame
implements ActionListener {
    public static final int MY_WIDTH = 300;
    public static final int MY_HEIGHT = 120;
    public static final String CANCEL = "Cancel";
    public static final String WINDOW_CLOSING = "WindowClosing";
    private String coliLdn;
    private List listeners = new ArrayList();
    private boolean hasProgressStopped = false;
    JProgressBar pbar;
    private CommandHandlingSession session;

    public ProgressWindow(String string, String string2, String string3) {
        super(string2);
        this.coliLdn = string;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProgressWindow.this.actionPerformed(new ActionEvent(windowEvent, 1, ProgressWindow.WINDOW_CLOSING));
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new JLabel(string3), "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.pbar = new JProgressBar();
        this.pbar.setIndeterminate(true);
        jPanel.add((Component)this.pbar, "North");
        jPanel.add((Component)new JLabel("Press Cancel button to abort the operation.\n"), "Center");
        JButton jButton = new JButton(CANCEL);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressWindow.this.actionPerformed(actionEvent);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        container.add((Component)jPanel, "Center");
        this.setSize(300, 120);
        this.calculateScreenSize();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        this.repaint();
    }

    private void calculateScreenSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        if (dimension2.width < dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height < dimension.height) {
            dimension.height = dimension2.height;
        }
        n = (dimension2.width - dimension.width) / 2;
        n2 = (dimension2.height - dimension.height) / 2;
        this.setLocation(n, n2);
    }

    public void addProgressWindowListener(ProgressWindowListener progressWindowListener) {
        this.listeners.add(progressWindowListener);
    }

    public String getColiLdn() {
        return this.coliLdn;
    }

    public void setCommandHandlingSession(CommandHandlingSession commandHandlingSession) {
        this.session = commandHandlingSession;
    }

    public CommandHandlingSession getCommandHandlingSession() {
        return this.session;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && (string.equals(CANCEL) || string.equals(WINDOW_CLOSING))) {
            this.stopProgressWindow();
            this.fireProgressActionPerformed(actionEvent);
        }
    }

    public void stopProgressWindow() {
        this.dispose();
        this.hasProgressStopped = true;
    }

    private void fireProgressActionPerformed(ActionEvent actionEvent) {
        if (this.listeners != null) {
            for (ProgressWindowListener progressWindowListener : this.listeners) {
                progressWindowListener.progressActionPerformed(this, actionEvent);
            }
        }
    }

    public boolean hasProgressStopped() {
        return this.hasProgressStopped;
    }
}

