/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SectorViewerController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.provider.ResourcesPathProvider;

public class TaskbarManager {
    public static final String VOB_PATH = ResourcesPathProvider.IMAGE_LOCATION_IN_VOB;
    public static final String EMPTY_IMAGE_NAME = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/EmptyImage50x30.gif";
    public static final String LEGEND_IMAGE_NAME = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/SectorViewerLegend.png";
    public static final String LEGEND_IMAGE_TOOL_TIP = "Colors set on branches and cascaded units";
    public static final String LEGEND_IMAGE_NAME_LTE = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/SectorViewerLegendLte.png";
    public static final String LEGEND_IMAGE_TOOL_TIP_LTE = "Color set on cascaded units";
    public static final String STATE_VIEW = "State view";
    public static final String LED_VIEW = "Led view";
    public static final String NO_SECTOR_SELECTED = " - ";
    public static final String BRANCH_MENU_DISABLED = "A Sector needs to be selected for the branch menu to be activated";
    public static final String SECTOR_VIEW_NOT_SUPPORTED = "Sector viewer is NOT supported together with LED view";
    private JPanel switchPanel;
    private JPanel panel;
    private MainWindowController controller;
    JComboBox jComboBox;
    JLabel viewLabel;
    private JComboBox sectorComboBox;
    private String selectedSector;
    private JComboBox branchComboBox;
    String selectedBranch;
    private Vector<String> branchList = new Vector();
    private boolean branchesExist = false;

    public TaskbarManager(MainWindowController mainWindowController) {
        this.controller = mainWindowController;
        this.panel = new JPanel(new BorderLayout());
        this.createLedStateComboBoxView();
    }

    public JPanel getTaskbar() {
        return this.panel;
    }

    private void createLedStateComboBoxView() {
        this.switchPanel = new JPanel();
        this.jComboBox = new JComboBox();
        this.jComboBox.setName("View");
        this.jComboBox.addItem(LED_VIEW);
        this.jComboBox.addItem(STATE_VIEW);
        this.jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                Trace.observation(this, string + " is selected by the user");
                if (string.equals(TaskbarManager.STATE_VIEW)) {
                    TaskbarManager.this.setSectorMenuToEnabled();
                    TaskbarManager.this.controller.getPhysicalView().setStateViewActive();
                } else {
                    TaskbarManager.this.setSectorMenuToDisabled();
                    TaskbarManager.this.controller.getPhysicalView().setLedViewActive();
                }
            }
        });
        if (!this.controller.getCvSession().getVibManager().isStateViewAvailable()) {
            this.jComboBox.removeItem(STATE_VIEW);
        }
        this.viewLabel = new JLabel("  View: ");
        this.switchPanel.add(this.viewLabel);
        this.switchPanel.add(this.jComboBox);
        this.panel.add((Component)this.switchPanel, "West");
    }

    protected final void setSectorMenuToEnabled() {
        this.sectorComboBox.setEnabled(true);
        this.sectorComboBox.setToolTipText(null);
    }

    protected final void setSectorMenuToDisabled() {
        if (this.sectorComboBox != null) {
            this.selectedSector = (String)this.sectorComboBox.getSelectedItem();
            if (!this.selectedSector.equals(NO_SECTOR_SELECTED)) {
                this.sectorComboBox.setSelectedItem(NO_SECTOR_SELECTED);
            }
            this.sectorComboBox.setEnabled(false);
            this.sectorComboBox.setToolTipText(SECTOR_VIEW_NOT_SUPPORTED);
        } else {
            Trace.error(this, "Could not disable Sector menu since it is not initiated");
        }
    }

    public void createSectorMenu() {
        JLabel jLabel;
        Serializable serializable;
        SectorViewerController sectorViewerController = this.controller.getSectorViewerController();
        String[] stringArray = sectorViewerController.getSectorNames();
        if (stringArray == null) {
            return;
        }
        if (stringArray.length >= 1) {
            serializable = this.createImageIcon(EMPTY_IMAGE_NAME);
            this.switchPanel.add((Component)serializable);
        }
        this.switchPanel.add(new JLabel("Sector:"));
        this.branchesExist = this.checkIfBranchesExist(stringArray);
        serializable = new Vector();
        ((Vector)serializable).add(NO_SECTOR_SELECTED);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            ((Vector)serializable).add(string);
        }
        this.sectorComboBox = new JComboBox(serializable);
        this.sectorComboBox.setName("Sector");
        this.sectorComboBox.setEnabled(false);
        this.sectorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TaskbarManager.this.selectedSector;
                TaskbarManager.this.selectedSector = (String)TaskbarManager.this.sectorComboBox.getSelectedItem();
                if (TaskbarManager.this.selectedSector.equals(TaskbarManager.NO_SECTOR_SELECTED)) {
                    TaskbarManager.this.controller.getSectorViewerController().setShowSectorView(string, false);
                    if (TaskbarManager.this.branchesExist) {
                        TaskbarManager.this.disableBranchMenu();
                    }
                } else {
                    TaskbarManager.this.controller.getSectorViewerController().setShowSectorView(string, false);
                    TaskbarManager.this.controller.getSectorViewerController().setShowSectorView(TaskbarManager.this.selectedSector, true);
                    if (TaskbarManager.this.branchesExist) {
                        TaskbarManager.this.activateBranchMenu();
                    }
                }
                SectorViewerController sectorViewerController = TaskbarManager.this.controller.getSectorViewerController();
                boolean bl = sectorViewerController.isSectorViewerActive();
                sectorViewerController.getSectorViewerPhysicalView().setVisible(bl);
            }
        });
        this.switchPanel.add(this.sectorComboBox);
        if (this.branchesExist) {
            this.createBranchMenu();
            jLabel = this.createImageIcon(LEGEND_IMAGE_NAME);
            jLabel.setToolTipText(LEGEND_IMAGE_TOOL_TIP);
        } else {
            jLabel = this.createImageIcon(LEGEND_IMAGE_NAME_LTE);
            jLabel.setToolTipText(LEGEND_IMAGE_TOOL_TIP_LTE);
        }
        this.switchPanel.add(jLabel);
    }

    private boolean checkIfBranchesExist(String[] stringArray) {
        SectorViewerController sectorViewerController = this.controller.getSectorViewerController();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            List<String> list = sectorViewerController.getSectorBranchNames(string);
            if (list == null || list.isEmpty() || list.get(0).equals("")) continue;
            return true;
        }
        return false;
    }

    public void createBranchMenu() {
        this.switchPanel.add(new JLabel(" Branch:"));
        this.branchList.add(NO_SECTOR_SELECTED);
        this.branchComboBox = new JComboBox<String>(this.branchList);
        this.branchComboBox.setName("Branch");
        this.branchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskbarManager.this.selectedBranch = (String)TaskbarManager.this.branchComboBox.getSelectedItem();
                TaskbarManager.this.controller.getSectorViewerController().setShowSectorBranch(TaskbarManager.this.selectedSector, TaskbarManager.this.selectedBranch);
            }
        });
        this.disableBranchMenu();
        this.switchPanel.add(this.branchComboBox);
    }

    private void activateBranchMenu() {
        SectorViewerController sectorViewerController = this.controller.getSectorViewerController();
        List<String> list = sectorViewerController.getSectorBranchNames(this.selectedSector);
        if (list != null && !list.isEmpty() && !list.get(0).equals("")) {
            this.branchList.removeAllElements();
            for (String string : list) {
                this.branchList.add(string.toString());
            }
            this.branchComboBox.setEnabled(true);
            this.branchComboBox.setToolTipText(null);
            this.branchComboBox.setSelectedItem(this.branchList.get(0));
            this.branchComboBox.repaint();
        }
    }

    protected void disableBranchMenu() {
        this.branchList.removeAllElements();
        this.branchList.add(NO_SECTOR_SELECTED);
        this.branchComboBox.setSelectedItem(this.branchList.get(0));
        this.branchComboBox.repaint();
        this.branchComboBox.setEnabled(false);
        this.branchComboBox.setToolTipText(BRANCH_MENU_DISABLED);
    }

    private JLabel createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        ImageIcon imageIcon = null;
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(VOB_PATH + string);
        return new JLabel(imageIcon);
    }
}

