/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.launch;

import java.util.Properties;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.ProgressUpdaterInterface;
import se.ericsson.security.launcher.ReusableLaunchable;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSessionController;

public class CabinetViewerApplication
implements Launchable,
ReusableLaunchable,
ProgressUpdaterInterface {
    private static int sessionNumber = 0;
    private CvSessionController controller;
    private LauncherData launcherData;
    private ProgressListenerInterface progressListenerInterface = null;
    private static final String CABV_NAME = "Cabinet Viewer";

    public void run(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        int n = 0;
        String string2 = System.getProperty("accessLevel");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        this.launcherData = new LauncherData(string, launcherInterface, properties, this);
        Trace.observation(this, "Launching cabinet viewer towards: " + this.launcherData.ipAddress);
        Trace.readConfiguration();
        this.controller = new CvSessionController(++sessionNumber, this.launcherData, n, this.progressListenerInterface);
    }

    public boolean reconnect(String string, Properties properties) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            Trace.observation(this, "Invalid (null or empty) host name at reconnect");
            bl = false;
        } else if (!this.launcherData.launcher.hasNESameSecurityState(string, (Launchable)this) || !this.launcherData.launcher.hasNESameVersion(string, (Launchable)this)) {
            bl = false;
        }
        return bl;
    }

    public void exit() {
        Trace.observation(this, "Exiting cabinet viewer");
        this.controller.exit();
        this.launcherData.launcher.onExit((Launchable)this);
        this.launcherData = null;
        this.progressListenerInterface = null;
    }

    public void setProgressListener(ProgressListenerInterface progressListenerInterface) {
        this.progressListenerInterface = progressListenerInterface;
    }

    public String toString() {
        return CABV_NAME;
    }

    public void reuse(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        Trace.observation(this, "Reuse Cabinet Viewer on " + string);
    }
}

