/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.DynamicMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.vim.VimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.DomContainer;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.EquipmentConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.RbsTemplateConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.StateViewConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.TemplateConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.ValueConverterConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelLoader;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelLoaderImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.loader.VimModelSummaryLoaderImpl;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelLoadingException;

public class VimModelXml
extends VimModel
implements Runnable {
    private static final int MAX_JAR_LOAD_ATTEMPTS = 2;
    private VimModelLoader vimModelLoader;
    private DynamicMimModel mimModel;
    private Hashtable valueConvertersHash = new Hashtable();
    private Hashtable stateViewHash;
    private Thread myThread;
    private boolean loadingCompleted = false;
    private boolean loadingStateViewCompleted = false;
    private Exception loadingException;
    private VimModelSummaryLoaderImpl vimModelSummaryLoader;
    private List<VoTemplate> voTemplatesForSectorViewer = null;
    private boolean loadingSectorViewerCompleted = false;
    private LauncherData launcherData;
    private boolean isMultiConfig = false;
    private List productNames = null;
    private final String CABINET_TEMPLATE = "CabinetTemplate";
    private final String MULTI_CABINET_TEMPLATE = "MultiCabinetTemplate";
    private final String SUBRACK_TEMPLATE = "SubrackTemplate";
    private final String SECTOR_ANTENNA_UNIT_WITH_PARENT_TEMPLATE = "SectorAntennaUnitWithParentTemplate";
    private final String SECTOR_ANTENNA_UNIT_WITH_PARENT_FOR_MULTI_CABINET_TEMPLATE = "SectorAntennaUnitWithParentForMultiCabinetTemplate";
    private final String SECTOR_ANTENNA_UNIT_TEMPLATE = "SectorAntennaUnitTemplate";
    private final String SECTOR_ANTENNA_UNIT_FOR_MULTI_CABINET_TEMPLATE = "SectorAntennaUnitForMultiCabinetTemplate";

    public VimModelXml(LauncherData launcherData) {
        this.init(launcherData);
    }

    public VimModelXml(LauncherData launcherData, List list) {
        this.productNames = list;
        this.isMultiConfig = true;
        this.init(launcherData);
    }

    private void init(LauncherData launcherData) {
        this.launcherData = launcherData;
        this.mimModel = new DynamicMimModel(launcherData);
        this.setMimModel(this.mimModel);
        this.vimModelLoader = new VimModelLoaderImpl();
    }

    @Override
    public void load() {
        this.myThread = new Thread((Runnable)this, "VimModelXml");
        this.myThread.start();
    }

    @Override
    public boolean waitForLoadingComplete() throws InterruptedException {
        if (this.myThread == null) {
            return true;
        }
        this.myThread.join();
        return this.loadingCompleted;
    }

    @Override
    public Exception getLoadingError() {
        return this.loadingException;
    }

    protected void setLoadingError(Exception exception) {
        this.loadingException = exception;
    }

    @Override
    public Hashtable getStateViewHash() {
        return this.stateViewHash;
    }

    @Override
    public List<VoTemplate> getVoTemplatesForSectorViewer() {
        return this.voTemplatesForSectorViewer;
    }

    @Override
    public void loadSummary() {
        this.vimModelSummaryLoader = new VimModelSummaryLoaderImpl(this.vimModelLoader, this.valueConvertersHash, this.isMultiConfig);
        this.vimModelSummaryLoader.loadSummary();
    }

    @Override
    public boolean waitForLoadingOfSummaryComplete() throws InterruptedException {
        if (this.vimModelSummaryLoader == null) {
            return true;
        }
        return this.vimModelSummaryLoader.waitForLoadingOfSummaryComplete();
    }

    @Override
    public Exception getLoadingErrorForSummary() {
        if (this.vimModelSummaryLoader == null) {
            return null;
        }
        return this.vimModelSummaryLoader.getLoadingErrorForSummary();
    }

    @Override
    public JPanel[] getSummaryPanels() {
        if (this.vimModelSummaryLoader == null) {
            return null;
        }
        return this.vimModelSummaryLoader.getSummaryPanels();
    }

    @Override
    public void run() {
        this.loadingCompleted = false;
        String string = null;
        boolean bl = false;
        bl = this.loadJarFile();
        if (!bl) {
            return;
        }
        try {
            this.vimModelLoader.loadAllSchemaFiles();
            DomContainer domContainer = this.vimModelLoader.loadAllTemplates();
            string = "se/ericsson/wcdma/rbs/cabinetviewer/model/Equipment.xml";
            Node node = this.vimModelLoader.loadEquipment();
            this.createVoTemplatesFromEquipment(node, domContainer);
            if (this.isMultiConfig) {
                for (int i = 0; i < this.productNames.size(); ++i) {
                    this.loadAndParseRbsTemplate(this.productNames.get(i).toString());
                }
            } else {
                this.loadAndParseRbsTemplate(this.getRbsProductName());
            }
            this.loadStateViewModel();
            this.loadSectorViewerModel();
            this.loadingCompleted = true;
        }
        catch (MalformedURLException malformedURLException) {
            this.setLoadingError(malformedURLException);
        }
        catch (SAXException sAXException) {
            String string2 = this.vimModelLoader.getModelPath();
            this.setLoadingError(new ModelException("Error loading xml file " + string + " from jar file " + string2, sAXException));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.setLoadingError(parserConfigurationException);
        }
        catch (ModelException modelException) {
            this.setLoadingError(modelException);
        }
        catch (Exception exception) {
            this.setLoadingError(exception);
        }
    }

    private boolean loadJarFile() {
        for (int i = 0; i < 2; ++i) {
            try {
                this.vimModelLoader.loadJarFile(this.launcherData);
                return true;
            }
            catch (IOException iOException) {
                String string = this.vimModelLoader.getModelPath();
                this.setLoadingError(new ModelLoadingException("Unable to load jar file from: " + string, iOException));
                Trace.error(this, "Failed to load jar file: " + string, iOException);
                return false;
            }
            catch (LauncherException launcherException) {
                this.setLoadingError(new ModelLoadingException("LauncherException while loading jar file. ", launcherException));
                Trace.error(this, "LauncherException while loading jar file. ", launcherException);
                continue;
            }
        }
        return false;
    }

    private void loadStateViewModel() {
        String string = null;
        try {
            string = "se/ericsson/wcdma/rbs/cabinetviewer/model/ValueConverter.xml";
            this.valueConvertersHash = this.loadValueConverters();
            string = "se/ericsson/wcdma/rbs/cabinetviewer/model/StateView.xml";
            this.stateViewHash = this.loadStateView(this.valueConvertersHash);
            this.loadingStateViewCompleted = true;
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to load xml file " + string, exception);
        }
    }

    private void loadSectorViewerModel() {
        try {
            DomContainer domContainer = this.vimModelLoader.loadSectorViewerTemplates();
            this.mimModel.setRbsType(this.vimModelLoader.getRbsProductName());
            this.voTemplatesForSectorViewer = this.createVoTemplatesForSectorViewer(domContainer);
            this.loadingSectorViewerCompleted = true;
        }
        catch (Exception exception) {
            Trace.warning(this, "Unable to load xml files for Sector Viewer.", exception);
        }
    }

    @Override
    public boolean isStateViewAvailable() {
        return this.loadingStateViewCompleted;
    }

    @Override
    public boolean isSectorViewAvailable() {
        return this.loadingSectorViewerCompleted;
    }

    protected void loadAndParseRbsTemplate(String string) throws Exception {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            string2 = "DefaultRbs";
            this.setRbsProductName(string2);
            this.mimModel.setRbsType(string2);
        }
        Node node = null;
        node = this.vimModelLoader.loadRbsTemplate(string2);
        string2 = this.isMultiConfig ? "MultiRbs" : this.vimModelLoader.getRbsProductName();
        if (!string2.equals("DefaultRbs")) {
            this.setRbsProductName(string2);
            this.mimModel.setRbsType(string2);
            this.vimModelLoader.setRbsProductName(string2);
        }
        try {
            this.parseRbsTemplate(string2, node);
        }
        catch (ModelException modelException) {
            if (string2.equals("DefaultRbs")) {
                this.logRbsTemplateWarning(string2, modelException.getMessage(), modelException);
                throw modelException;
            }
            this.logRbsTemplateWarning(string2, "The DefaultRbsTemplate will be used instead. " + modelException.getMessage(), modelException);
            this.loadAndParseRbsTemplate("DefaultRbs");
        }
    }

    protected void logRbsTemplateWarning(String string, String string2, Exception exception) {
        Trace.warning(this, "The rbsTemplate for \"" + string + "\" contains an error. " + string2, exception);
    }

    protected void parseRbsTemplate(String string, Node node) {
        RbsTemplateConverter rbsTemplateConverter = new RbsTemplateConverter();
        Hashtable hashtable = new Hashtable();
        rbsTemplateConverter.load(hashtable, node, this.isMultiConfig);
        VoRelationship voRelationship = rbsTemplateConverter.getVoRelationShip();
        if (this.topVoRelationship == null) {
            this.topVoRelationship = voRelationship;
            this.addRbs(string, this.topVoRelationship);
        } else {
            this.topVoRelationship.addChildRelationshipForMultiCabinet(voRelationship);
            this.addRbs(string, this.topVoRelationship);
        }
    }

    protected List createVoTemplatesForSectorViewer(DomContainer domContainer) {
        ArrayList<VoTemplate> arrayList = new ArrayList<VoTemplate>();
        TemplateConverter templateConverter = new TemplateConverter(this.mimModel);
        List<String> list = domContainer.getAllNamesOfXml();
        for (String string : list) {
            Hashtable hashtable = new Hashtable();
            Document document = domContainer.getDocument(string);
            templateConverter.load(hashtable, document);
            VoTemplate voTemplate = null;
            try {
                voTemplate = templateConverter.createVoTemplate(null);
                arrayList.add(voTemplate);
            }
            catch (ModelLoadingException modelLoadingException) {
                Trace.observation(this, "Template file \"" + string + "\" was NOT loaded. " + modelLoadingException.getMessage());
            }
        }
        return arrayList;
    }

    protected void createVoTemplatesFromEquipment(Node node, DomContainer domContainer) {
        Object object;
        Object object2;
        EquipmentConverter equipmentConverter = new EquipmentConverter(this.mimModel, domContainer);
        Hashtable hashtable = new Hashtable();
        equipmentConverter.load(hashtable, node);
        List<VoTemplate> list = equipmentConverter.getVoTemplatesToUse();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (VoTemplate)object2.next();
                if (this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("CabinetTemplate") || !this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("MultiCabinetTemplate") || this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("SectorAntennaUnitWithParentTemplate") || !this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("SectorAntennaUnitWithParentForMultiCabinetTemplate") || this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("SectorAntennaUnitTemplate") || !this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("SectorAntennaUnitForMultiCabinetTemplate") || this.isMultiConfig && ((VoTemplate)object).getNameOfXML().equals("SubrackTemplate")) continue;
                this.addVoTemplate((VoTemplate)object);
            }
        }
        if ((object2 = equipmentConverter.getFallbackVoTemplates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                VoTemplate voTemplate = (VoTemplate)object.next();
                this.setFallbackVoTemplate(voTemplate.getMoType(), voTemplate);
            }
        }
    }

    protected Hashtable loadValueConverters() throws IOException, ParserConfigurationException, SAXException {
        Node node = this.vimModelLoader.loadValueConverters();
        ValueConverterConverter valueConverterConverter = new ValueConverterConverter();
        valueConverterConverter.load(null, node);
        Hashtable hashtable = valueConverterConverter.createValueConverters();
        return hashtable;
    }

    protected Hashtable loadStateView(Hashtable hashtable) throws IOException, ParserConfigurationException, SAXException {
        Node node = this.vimModelLoader.loadStateView();
        StateViewConverter stateViewConverter = new StateViewConverter();
        stateViewConverter.load(null, node);
        Hashtable hashtable2 = stateViewConverter.createStateView(hashtable);
        return hashtable2;
    }
}

