/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.AndCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.EqualsCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.NotCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.OrCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.StringCompareCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AbstractCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AndElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.EqualsElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.NotElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.StringCompareElement;

public class OrElement
extends AbstractCondition {
    boolean result = true;
    private AndElement andElement;
    private OrElement orElement;
    private List<NotElement> notElements = new ArrayList<NotElement>();
    private List<EqualsElement> equalsElements = new ArrayList<EqualsElement>();
    private List<StringCompareElement> stringCompareElements = new ArrayList<StringCompareElement>();

    public OrElement(Hashtable hashtable, Node node) {
        super(hashtable);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!this.isValidNodeName(string)) continue;
            if (string.equals("and")) {
                this.andElement = new AndElement(hashtable, node2);
                continue;
            }
            if (string.equals("or")) {
                this.orElement = new OrElement(hashtable, node2);
                continue;
            }
            if (string.equals("not")) {
                this.notElements.add(new NotElement(hashtable, node2));
                continue;
            }
            if (string.equals("equals")) {
                this.equalsElements.add(new EqualsElement(hashtable, node2));
                continue;
            }
            if (string.equals("contains")) {
                this.stringCompareElements.add(new StringCompareElement(hashtable, node2, "contains"));
                continue;
            }
            if (string.equals("startsWith")) {
                this.stringCompareElements.add(new StringCompareElement(hashtable, node2, "startsWith"));
                continue;
            }
            if (!string.equals("endsWith")) continue;
            this.stringCompareElements.add(new StringCompareElement(hashtable, node2, "endsWith"));
        }
    }

    @Override
    public boolean evaluate() {
        this.result = false;
        if (this.andElement != null) {
            this.result = this.andElement.evaluate();
        }
        if (this.orElement != null) {
            boolean bl = this.result = this.result || this.orElement.evaluate();
        }
        if (this.notElements != null && !this.notElements.isEmpty()) {
            for (NotElement abstractCondition : this.notElements) {
                this.result = this.result || abstractCondition.evaluate();
            }
        }
        if (this.equalsElements != null && !this.equalsElements.isEmpty()) {
            for (EqualsElement equalsElement : this.equalsElements) {
                this.result = this.result || equalsElement.evaluate();
            }
        }
        if (this.stringCompareElements != null && !this.stringCompareElements.isEmpty()) {
            for (StringCompareElement stringCompareElement : this.stringCompareElements) {
                this.result = this.result || stringCompareElement.evaluate();
            }
        }
        return this.result;
    }

    @Override
    protected OrCondition createCondition() {
        AndCondition andCondition = null;
        if (this.andElement != null) {
            andCondition = this.andElement.createCondition();
        }
        OrCondition orCondition = null;
        if (this.orElement != null) {
            orCondition = this.orElement.createCondition();
        }
        ArrayList<NotCondition> arrayList2 = new ArrayList<NotCondition>();
        for (NotElement arrayList3 : this.notElements) {
            NotCondition notCondition = arrayList3.createCondition();
            arrayList2.add(notCondition);
        }
        ArrayList arrayList4 = new ArrayList();
        for (EqualsElement equalsElement : this.equalsElements) {
            EqualsCondition equalsCondition = equalsElement.createCondition();
            arrayList4.add(equalsCondition);
        }
        ArrayList<StringCompareCondition> arrayList = new ArrayList<StringCompareCondition>();
        for (StringCompareElement stringCompareElement : this.stringCompareElements) {
            StringCompareCondition stringCompareCondition = stringCompareElement.createCondition();
            arrayList.add(stringCompareCondition);
        }
        OrCondition orCondition2 = new OrCondition(andCondition, orCondition, arrayList2, arrayList4, arrayList);
        return orCondition2;
    }
}

