/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property;

import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.dynamicproperty.StringCompareCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AbstractCondition;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class StringCompareElement
extends AbstractCondition {
    private String type;
    boolean result = false;
    private String var;
    private String str;

    public StringCompareElement(Hashtable hashtable, Node node, String string) {
        super(hashtable);
        this.type = string;
        if (string == null) {
            throw new ModelException("Can not handle this type of String comparision!");
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (!this.isValidNodeName(string2)) continue;
            if (string2.equals("var")) {
                this.var = Helper.getDataInFirstTextNode(this.getParams(), node2);
                continue;
            }
            if (!string2.equals("string")) continue;
            this.str = Helper.getDataInFirstTextNode(this.getParams(), node2);
        }
    }

    @Override
    public boolean evaluate() {
        this.result = false;
        if (this.var == null) {
            Trace.warning(this, " Variable \"null\" NOT found among variables/parameters in Hashtable");
            return false;
        }
        Object v = this.getParams().get(this.var);
        if (v == null) {
            Trace.warning(this, " Variable " + this.var + " NOT found among variables/parameters in Hashtable");
            return false;
        }
        if (!(v instanceof String)) {
            Trace.warning(this, " Variable " + this.var + " must be a String");
            return false;
        }
        String string = (String)v;
        if (this.type.equals("equals") && string.equals(this.str)) {
            this.result = true;
        } else if (this.type.equals("contains") && string.indexOf(this.str) >= 0) {
            this.result = true;
        } else if (this.type.equals("startsWith") && string.startsWith(this.str)) {
            this.result = true;
        } else if (this.type.equals("endsWith") && string.endsWith(this.str)) {
            this.result = true;
        }
        return this.result;
    }

    @Override
    protected StringCompareCondition createCondition() {
        StringCompareCondition.COMPARISON cOMPARISON = null;
        if (this.type.equals("equals")) {
            cOMPARISON = StringCompareCondition.COMPARISON.EQUALS;
        } else if (this.type.equals("contains")) {
            cOMPARISON = StringCompareCondition.COMPARISON.CONTAINS;
        } else if (this.type.equals("startsWith")) {
            cOMPARISON = StringCompareCondition.COMPARISON.STARTS_WITH;
        } else if (this.type.equals("endsWith")) {
            cOMPARISON = StringCompareCondition.COMPARISON.ENDS_WITH;
        }
        return new StringCompareCondition(this.var, this.str, cOMPARISON);
    }
}

