/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.FormPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.InfoPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.ViewFormPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.AbstractSummary;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.FormItemElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class FormPanelElement
extends AbstractSummary {
    private String name;
    private String sortingMoType;
    private List<String> requiredMoElements = new ArrayList<String>();
    private List<String> dissallowedMoElements = new ArrayList<String>();
    private List<FormItemElement> itemElements = new ArrayList<FormItemElement>();
    private String useInfoView = null;
    private boolean isOptional = false;

    public FormPanelElement(Node node, boolean bl) {
        super(node);
        this.name = super.getAttribute("name");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("sortingMoType")) {
                this.sortingMoType = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (string.equals("requiredMo")) {
                this.requiredMoElements.add(Helper.getDataInFirstTextNode(null, node2));
                continue;
            }
            if (string.equals("dissallowedMo")) {
                this.dissallowedMoElements.add(Helper.getDataInFirstTextNode(null, node2));
                continue;
            }
            if (string.equals("item")) {
                if (bl && "SINGLE_CABINET".equals(this.sortingMoType) || !bl && "MULTI_CABINET".equals(this.sortingMoType)) continue;
                this.itemElements.add(new FormItemElement(node2));
                continue;
            }
            if (string.equals("useInfoView")) {
                this.useInfoView = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (!string.equals("optional")) continue;
            this.isOptional = true;
        }
    }

    protected InfoPanel getInfoPanel(Hashtable hashtable) {
        if (this.useInfoView != null) {
            return new ViewFormPanel(this.useInfoView);
        }
        FormPanel formPanel = new FormPanel(this.name);
        if (this.isOptional) {
            formPanel.setOptional(this.isOptional);
        }
        for (String object : this.requiredMoElements) {
            formPanel.addRequiredMo(object);
        }
        for (String string : this.dissallowedMoElements) {
            formPanel.addDisallowedMo(string);
        }
        for (FormItemElement formItemElement : this.itemElements) {
            formItemElement.addFormPanelItems(formPanel, hashtable);
        }
        return formPanel;
    }
}

