/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.energymeasurement;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;

public class EnergyMeasurementMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = EnergyMeasurementMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE = "EnergyMeasurement";
    private static final String UNIT_TYPE = "unitType";
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";

    public EnergyMeasurementMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        String string2;
        Object object;
        Object object2;
        Object object3;
        MoRepositoryWrapper moRepositoryWrapper = genericMaoContext.getMoRepositoryWrapper();
        logger.traceEnter(THIS_CLASS, "EnergyMeasurementMaoImpl() - constructor");
        EquipmentSupportFunctionMaoImpl equipmentSupportFunctionMaoImpl = (EquipmentSupportFunctionMaoImpl)this.getParent();
        Boolean bl = (Boolean)equipmentSupportFunctionMaoImpl.getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator);
        if (!bl.booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        int n2 = attrList.indexOf("energyMeterListRef");
        if (n2 >= 0) {
            boolean bl2 = false;
            boolean bl3 = false;
            object3 = (ManagedObject[])attrList.getValue(n2);
            for (int i = 0; i < ((ManagedObject[])object3).length; ++i) {
                String string3;
                object2 = moRepositoryWrapper.lookupType("HwUnit");
                string2 = this.searchLdnOnHwUnitMoList((MoIterator)object2, (String)(object = object3[i].getLocalDistinguishedName()), coordinator);
                if (string2.equals("")) {
                    string3 = "HwUnit from energyMeterListRef attribute: (" + (String)object + ") not found in Managed Object database.";
                    logger.traceGeneral(THIS_CLASS, string3);
                    throw new ProcessingFailureException(string3);
                }
                if (string2.equals("EMU") || string2.equals("PSU")) {
                    bl2 = true;
                } else if (string2.equals("PDU")) {
                    bl3 = true;
                } else {
                    string3 = "HwUnit MO (" + (String)object + ") cannot be used for creating EnergyMeasurement. Valid HwUnits for EnergyMeasurement are EMU, PSU or PDU.";
                    logger.traceGeneral(THIS_CLASS, string3);
                    throw new ProcessingFailureException(string3);
                }
                if (bl2 && bl3) {
                    logger.traceGeneral(THIS_CLASS, "Provided HwUnit MOs cannot be used for creating EnergyMeasurement. PDU cannot be added together with PSU nor EMU.");
                    throw new ProcessingFailureException("Provided HwUnit MOs cannot be used for creating EnergyMeasurement. PDU cannot be added together with PSU nor EMU.");
                }
                if (bl3 && (string3 = moRepositoryWrapper.lookup((String)object + ",EnergyMeter=1")) == null) {
                    logger.traceGeneral(THIS_CLASS, "Provided PDU cannot be used, as it is not an ECM type.");
                    throw new ProcessingFailureException("Provided PDU cannot be used, as it is not an ECM type.");
                }
                logger.info(THIS_CLASS, "Adding " + (String)object + " to energyMeasurement.");
            }
        }
        String string4 = (String)attrList.getValue(attrList.indexOf("startTime"));
        String string5 = (String)attrList.getValue(attrList.indexOf("stopTime"));
        object3 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ((DateFormat)object3).setLenient(false);
        Date date = new Date();
        object2 = new Date();
        object = new Date();
        if (string4.length() > 0) {
            try {
                object2 = ((DateFormat)object3).parse(string4);
            }
            catch (ParseException parseException) {
                throw new ProcessingFailureException("StartTime incorrectly formated or invalid date, correct format is: yyyy-MM-dd HH:mm");
            }
        } else {
            string2 = ((DateFormat)object3).format(date);
            this.setRestrictedAttribute("startTime", string2, coordinator);
            object2 = date;
        }
        if (string4.length() > 0 && ((Date)object2).compareTo(date) < 0) {
            throw new ProcessingFailureException("StartTime must be in the future or left default");
        }
        if (string5.length() > 0) {
            try {
                object = ((DateFormat)object3).parse(string5);
            }
            catch (ParseException parseException) {
                throw new ProcessingFailureException("StopTime incorrectly formated or invalid date, correct format is: yyyy-MM-dd HH:mm");
            }
        }
        if (string5.length() > 0 && ((Date)object).compareTo(date) < 0) {
            throw new ProcessingFailureException("StopTime must be in the future or left blank");
        }
        if (string4.length() > 0 && string5.length() > 0 && ((Date)object2).compareTo((Date)object) > 0) {
            throw new ProcessingFailureException("StartTime must be before stopStime");
        }
        logger.traceReturn(THIS_CLASS, "EnergyMeasurementMaoImpl() - constructor");
    }

    public EnergyMeasurementMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "preSet()");
        return object;
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate");
        super.postCreate(attrList, coordinator);
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private String searchLdnOnHwUnitMoList(MoIterator moIterator, String string, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getLocalDistinguishedName().equals(string)) continue;
            return managedObject.getAttribute(UNIT_TYPE, coordinator).toString();
        }
        return "";
    }
}

