/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.externalnode;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;

public class ExternalNodeMaoImpl
extends GenericMao {
    private static final String MO_TYPE = "ExternalNode";
    private static final String MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String MO_TYPE_ECPORT = "EcPort";
    private static final String MO_TYPE_ECBUS = "EcBus";
    private static final String MO_TYPE_AUXPIU = "AuxPlugInUnit";
    private static final String ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF = "equipmentSupportFunctionRef";
    private static final String ATTRIBUTE_INFORMATION_ONLY = "informationOnly";
    private static final String ATTRIBUTE_INCI_CONNECTOR_REF = "inciConnectorRef";
    private static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String ATTRIBUTE_ECBUSREF = "ecBusRef";
    private static final Class THIS_CLASS = ExternalNodeMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    boolean isEcPortDeleted = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExternalNodeMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ExternalNodeMaoImpl() - constructor");
        int n2 = attrList.indexOf(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF);
        ManagedObject managedObject2 = (ManagedObject)attrList.getValue(n2);
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
        if (managedObject2 == null) {
            if (moIterator.size() != 1) throw new SupportSystemConfigurationFailedException("EquipmentSupportFunctionRef is empty", "System is unable to determine which equipmentSupportFunctionRef.");
            managedObject2 = moIterator.nextMo();
            this.setAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, managedObject2, coordinator);
        } else {
            Boolean bl = (Boolean)managedObject2.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            this.checkAndCorrectInformationOnly(bl, coordinator);
        }
        for (int i = 0; i < attrList.size(); ++i) {
            Boolean bl = (Boolean)managedObject2.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            if (!ATTRIBUTE_INCI_CONNECTOR_REF.equalsIgnoreCase(attrList.getName(i))) continue;
            this.validateInciConnectorRef((ManagedObject)attrList.getValue(i), bl, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "ExternalNodeMaoImpl() - constructor");
    }

    public ExternalNodeMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        ManagedObject managedObject;
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF)) {
            object = this.preSetEquipmentSupportFunctionRef((ManagedObject)object, coordinator);
            ManagedObject managedObject2 = (ManagedObject)object;
            Boolean bl = (Boolean)managedObject2.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            this.validateInciConnectorRef(bl, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_INCI_CONNECTOR_REF) && !this.isEcPortDeleted && (managedObject = (ManagedObject)this.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) != null) {
            Boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
            this.validateInciConnectorRef((ManagedObject)object, bl, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void validateInciConnectorRef(boolean bl, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)this.getAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, coordinator);
        this.validateInciConnectorRef(managedObject, bl, coordinator);
    }

    private void validateInciConnectorRef(ManagedObject managedObject, boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateInciConnectorRef()");
        if (managedObject == null) {
            ManagedObject managedObject2;
            ManagedObject managedObject3;
            MoIterator moIterator = this.getChildren();
            if (bl && moIterator.hasMoreElements() && (managedObject3 = (ManagedObject)(managedObject2 = moIterator.nextMo()).getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) != null) {
                String string = "Not allowed to set inciConnectorRef to empty or other EcBus than referred by EcPort::ecBusRef.";
                logger.traceGeneral(THIS_CLASS, string);
                throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string);
            }
        } else {
            ManagedObject managedObject4;
            ManagedObject managedObject5;
            String string = managedObject.getType();
            if (!(string.equalsIgnoreCase(MO_TYPE) || string.equalsIgnoreCase(MO_TYPE_ECBUS) || string.equalsIgnoreCase(MO_TYPE_AUXPIU))) {
                String string2 = "inciConnectorRef can only be set to the following MO types: AuxPlugInUnit, EcBus or ExternalNode";
                logger.traceGeneral(THIS_CLASS, string2);
                throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string2);
            }
            if (bl && string.equalsIgnoreCase(MO_TYPE)) {
                String string3 = "Not allowed to set inciConnectorRef to an ExternalNode when primary role.";
                logger.traceGeneral(THIS_CLASS, string3);
                throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string3);
            }
            MoIterator moIterator = this.getChildren();
            if (bl && moIterator != null && moIterator.hasMoreElements() && (managedObject5 = (ManagedObject)(managedObject4 = moIterator.nextMo()).getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) != null && string.equalsIgnoreCase(MO_TYPE_ECBUS) && managedObject5 != managedObject) {
                String string4 = "Not allowed to set inciConnectorRef to empty or other EcBus than referred by EcPort::ecBusRef.";
                logger.traceGeneral(THIS_CLASS, string4);
                throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string4);
            }
            if (!string.equalsIgnoreCase(MO_TYPE)) {
                managedObject4 = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE);
                while (managedObject4 != null && managedObject4.hasMoreElements()) {
                    ManagedObject managedObject6;
                    managedObject5 = managedObject4.nextMo();
                    if (managedObject5 == this || managedObject != (managedObject6 = (ManagedObject)managedObject5.getAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, coordinator))) continue;
                    if (string.equalsIgnoreCase(MO_TYPE_AUXPIU)) {
                        String string5 = "Multiple references to the same AuxPluginUnit from ExternalNodes not allowed.";
                        logger.traceGeneral(THIS_CLASS, string5);
                        throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string5);
                    }
                    if (bl || !string.equalsIgnoreCase(MO_TYPE_ECBUS)) continue;
                    String string6 = "Multiple references to the same EcBus from ExternalNodes not allowed when secondary role.";
                    logger.traceGeneral(THIS_CLASS, string6);
                    throw new ValueOutOfRangeException(ATTRIBUTE_INCI_CONNECTOR_REF, MO_TYPE, string6);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "validateInciConnectorRef()");
    }

    private Object preSetEquipmentSupportFunctionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetEquipmentSupportFunctionRef()");
        managedObject = this.validateOrCorrectEquipmentSupportFunctionRef(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "preSetEquipmentSupportFunctionRef()");
        return managedObject;
    }

    private ManagedObject validateOrCorrectEquipmentSupportFunctionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateOrCorrectEquipmentSupportFunctionRef()");
        if (managedObject == null || !managedObject.getType().equals(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION)) {
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION);
            if (moIterator.size() == 1) {
                logger.traceDebug(THIS_CLASS, "Correcting esfRef to the only ESF");
                managedObject = moIterator.nextMo();
            } else {
                boolean bl = false;
                MoIterator moIterator2 = this.getChildren();
                while (moIterator2 != null && moIterator2.hasMoreElements()) {
                    ManagedObject managedObject2;
                    ManagedObject managedObject3;
                    ManagedObject managedObject4 = moIterator2.nextMo();
                    if (!MO_TYPE_ECPORT.equals(managedObject4.getType()) || (managedObject3 = (ManagedObject)managedObject4.getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) == null || (managedObject2 = (ManagedObject)managedObject3.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) == null) continue;
                    logger.traceDebug(THIS_CLASS, "Correcting esfRef to the ESF found via EcPort -> EcBus");
                    managedObject = managedObject2;
                    bl = true;
                    break;
                }
                if (!bl) {
                    logger.traceGeneral(THIS_CLASS, "equipmentSupportFunctionRef is empty");
                    throw new SupportSystemConfigurationFailedException("equipmentSupportFunctionRef is empty");
                }
            }
        } else if (managedObject != null && managedObject.getType().equals(MO_TYPE_EQUIPMENT_SUPPORT_FUNCTION)) {
            MoIterator moIterator = this.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject5;
                ManagedObject managedObject6;
                ManagedObject managedObject7 = moIterator.nextMo();
                if (!MO_TYPE_ECPORT.equals(managedObject7.getType()) || (managedObject6 = (ManagedObject)managedObject7.getAttribute(ATTRIBUTE_ECBUSREF, coordinator)) == null || (managedObject5 = (ManagedObject)managedObject6.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) == null || managedObject == managedObject5) continue;
                logger.traceGeneral(THIS_CLASS, "equipmentSupportFunctionRef chain is faulty");
                throw new SupportSystemConfigurationFailedException("equipmentSupportFunctionRef chain is faulty");
            }
        }
        logger.traceReturn(THIS_CLASS, "validateOrCorrectEquipmentSupportFunctionRef()");
        return managedObject;
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF) || string.equalsIgnoreCase(ATTRIBUTE_INFORMATION_ONLY) || string.equalsIgnoreCase(ATTRIBUTE_INCI_CONNECTOR_REF)) {
            // empty if block
        }
        ManagedObject managedObject = (ManagedObject)this.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator);
        Boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator);
        this.checkAndCorrectInformationOnly(bl, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private void checkAndCorrectInformationOnly(Boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkAndCorrectInformationOnly()");
        Boolean bl2 = Boolean.FALSE;
        if (bl.equals(Boolean.FALSE)) {
            ManagedObject managedObject = (ManagedObject)this.getAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, coordinator);
            if (managedObject == null) {
                bl2 = Boolean.TRUE;
            } else {
                String string = managedObject.getType();
                if (string.equals(MO_TYPE_AUXPIU)) {
                    bl2 = Boolean.FALSE;
                }
                if (string.equals(MO_TYPE_ECBUS)) {
                    bl2 = Boolean.TRUE;
                }
                if (string.equals(MO_TYPE)) {
                    bl2 = Boolean.TRUE;
                }
            }
        }
        if (!((Boolean)this.getAttribute(ATTRIBUTE_INFORMATION_ONLY, coordinator)).equals(bl2)) {
            this.setAttribute(ATTRIBUTE_INFORMATION_ONLY, bl2, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "checkAndCorrectInformationOnly()");
    }

    public void onEcPortDeleted(Coordinator coordinator) throws MoAccessException {
        Boolean bl;
        ManagedObject managedObject;
        logger.traceEnter(THIS_CLASS, "onEcPortDeleted()");
        this.isEcPortDeleted = true;
        ManagedObject managedObject2 = (ManagedObject)this.getAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, coordinator);
        if (managedObject2 != null && managedObject2.getType().equals(MO_TYPE_ECBUS) && (managedObject = (ManagedObject)this.getAttribute(ATTRIBUTE_EQUIPMENT_SUPPORT_FUNCTION_REF, coordinator)) != null && (bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_SUPPORT_SYSTEM_CONTROL, coordinator)) != null && bl.booleanValue()) {
            this.setAttribute(ATTRIBUTE_INCI_CONNECTOR_REF, null, coordinator);
        }
        this.isEcPortDeleted = false;
        logger.traceReturn(THIS_CLASS, "onEcPortDeleted()");
    }

    public void delete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        this.deleteChildren((ManagedObject)this, coordinator);
        super.delete(coordinator);
    }

    private void deleteChildren(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteChildren()");
        MoIterator moIterator = managedObject.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                this.deleteChildren(managedObject2, coordinator);
                logger.traceDebug(THIS_CLASS, "Deleting MO: " + managedObject2);
                managedObject2.delete(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteChildren()");
    }
}

