/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omfapplication;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounter;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmCounterRegistration;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmMoClassCounterType;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmPredefinedScannerType;
import se.ericsson.crbs.omf.mao.indications.avc.TopologySubscriber;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextAlreadyExists;
import se.ericsson.crbs.omf.omfapplication.OmfContextCreateFailureException;
import se.ericsson.crbs.omf.omfapplication.OmfContextFactoryFactory;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;
import se.ericsson.crbs.supsys.omfapplication.MoMetaDataNamesSoam;
import se.ericsson.crbs.supsys.omfapplication.PmAttributeHandler;

public class OmfApplication
implements Mopplet,
TopologySubscriber {
    private static final String MO_TYPE_AUX_PLUG_IN_UNIT = "AuxPlugInUnit";
    private static AbstractLogger logger = LoggingService.getLogger();
    private final OmfContext theOmfContext;
    private Thread theUpdateRATandFDNthread = null;

    public OmfApplication() {
        logger.traceEnter(this.getClass(), "OmfApplication");
        OmfContext omfContext = null;
        try {
            logger.traceDebug(this.getClass(), "Creating OMF Context.");
            MoMetaDataNamesSoam moMetaDataNamesSoam = new MoMetaDataNamesSoam();
            omfContext = OmfContextFactoryFactory.getOmfContextFactoryInstance((String)"").createOmfContext(new OmfContextId("SOAM"), (PmAttribute)new PmAttributeHandler(), (MoMetaDataNames)moMetaDataNamesSoam);
        }
        catch (IOException iOException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + iOException.getMessage());
        }
        catch (OmfContextAlreadyExists omfContextAlreadyExists) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextAlreadyExists.getMessage());
        }
        catch (OmfContextCreateFailureException omfContextCreateFailureException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextCreateFailureException.getMessage());
        }
        this.theOmfContext = omfContext;
        this.subscribeForTopologyNotifications(MO_TYPE_AUX_PLUG_IN_UNIT);
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public OmfApplication(OmfContext omfContext) {
        logger.traceEnter(this.getClass(), "OmfApplication");
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public void init() {
        logger.traceEnter(this.getClass(), "init");
        logger.info(this.getClass(), "LM Loaded - soamLm");
        logger.info(this.getClass(), "Starting soamLm");
        this.theOmfContext.getGenericFactoryInitializer().initializeFactories();
        logger.traceReturn(this.getClass(), "init");
    }

    public void start() {
        ServiceRepository serviceRepository;
        PmCounterRegistration pmCounterRegistration;
        logger.traceEnter(this.getClass(), "start");
        this.theOmfContext.getGenericFactoryInitializer().startFactories();
        this.theOmfContext.getGenericFactoryInitializer().synch();
        logger.info(this.getClass(), "LM Started - soamLm");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            this.theUpdateRATandFDNthread = EquipmentSupportFunctionMaoImpl.startUpdateRATandFDNthread(this.theOmfContext.getMoRepositoryWrapper());
        }
        if ((pmCounterRegistration = (PmCounterRegistration)(serviceRepository = ServiceLocatorFacade.getRepository()).getService(PmCounterRegistration.class)) == null) {
            logger.traceError(this.getClass(), "Could not locate PmCounterRegistration interface.");
            return;
        }
        PmPredefinedScannerType pmPredefinedScannerType = new PmPredefinedScannerType("APC");
        PmCounter pmCounter = new PmCounter("pmMaxPowerConsumption", 1);
        PmCounter pmCounter2 = new PmCounter("pmMinPowerConsumption", 1);
        PmCounter pmCounter3 = new PmCounter("pmPowerConsumption", 150);
        PmCounter pmCounter4 = new PmCounter("pmEnergyConsumption", 1);
        PmCounter pmCounter5 = new PmCounter("pmAccumulatedEnergyConsumption", 1);
        PmCounter[] pmCounterArray = new PmCounter[]{pmCounter, pmCounter2, pmCounter3, pmCounter4, pmCounter5};
        PmCounter pmCounter6 = new PmCounter("pmBatteryTemperatureDistr", 17);
        PmCounter pmCounter7 = new PmCounter("pmBatteryDischargeTimeDistr", 8);
        PmCounter pmCounter8 = new PmCounter("pmBatteryMainLoadUnderVoltDiscTimeDistr", 8);
        PmCounter pmCounter9 = new PmCounter("pmBatteryDepthOfDischargeDistr", 7);
        PmCounter pmCounter10 = new PmCounter("pmBatteryCapacityTotalDelivered", 1, true);
        PmCounter[] pmCounterArray2 = new PmCounter[]{pmCounter6, pmCounter7, pmCounter8, pmCounter9, pmCounter10};
        PmCounter pmCounter11 = new PmCounter("pmConsumedEnergy", 1, true);
        PmCounter pmCounter12 = new PmCounter("pmConsumedEnergyAccumulated", 1, true);
        PmCounter pmCounter13 = new PmCounter("pmPowerConsumption", 150, true);
        PmCounter pmCounter14 = new PmCounter("pmVoltage", 150, true);
        PmCounter[] pmCounterArray3 = new PmCounter[]{pmCounter11, pmCounter12, pmCounter13, pmCounter14};
        PmCounter pmCounter15 = new PmCounter("pmCabinetFanSpeed", 3, true);
        PmCounter pmCounter16 = new PmCounter("pmCabinetFanSpeedExternal", 3, true);
        PmCounter pmCounter17 = new PmCounter("pmCabinetTemperature", 3, true);
        PmCounter pmCounter18 = new PmCounter("pmSpmBarometricAirPressure", 1, true);
        PmCounter pmCounter19 = new PmCounter("pmSpmDifferentialAirPressure", 1, true);
        PmCounter[] pmCounterArray4 = new PmCounter[]{pmCounter15, pmCounter16, pmCounter17, pmCounter18, pmCounter19};
        PmCounter pmCounter20 = new PmCounter("pmPsuAcInputVoltageInterruption", 10, true);
        PmCounter pmCounter21 = new PmCounter("pmPsuPowerLoad", 15, true);
        PmCounter[] pmCounterArray5 = new PmCounter[]{pmCounter20, pmCounter21};
        PmCounter pmCounter22 = new PmCounter("pmSystemVoltage", 15, true);
        PmCounter[] pmCounterArray6 = new PmCounter[]{pmCounter22};
        PmCounter pmCounter23 = new PmCounter("pmConsumedEnergy", 1, true);
        PmCounter pmCounter24 = new PmCounter("pmConsumedEnergyAccumulated", 1, true);
        PmCounter pmCounter25 = new PmCounter("pmPowerConsumption", 150, true);
        PmCounter[] pmCounterArray7 = new PmCounter[]{pmCounter23, pmCounter24, pmCounter25};
        PmCounter pmCounter26 = new PmCounter("pmBatteryCellVoltageMax", 18, true);
        PmCounter pmCounter27 = new PmCounter("pmBatteryCellVoltageDelta", 12, true);
        PmCounter pmCounter28 = new PmCounter("pmBatteryCellVoltageMin", 18, true);
        PmCounter pmCounter29 = new PmCounter("pmBatteryUnitTemp", 17, true);
        PmCounter pmCounter30 = new PmCounter("pmDisconnectsAtCharge", 1, true);
        PmCounter pmCounter31 = new PmCounter("pmOverTempAlarms", 1, true);
        PmCounter pmCounter32 = new PmCounter("pmUnderTempAlarms", 1, true);
        PmCounter[] pmCounterArray8 = new PmCounter[]{pmCounter26, pmCounter27, pmCounter28, pmCounter29, pmCounter30, pmCounter31, pmCounter32};
        PmMoClassCounterType[] pmMoClassCounterTypeArray = new PmMoClassCounterType[]{new PmMoClassCounterType("EnergyMeasurement", pmCounterArray), new PmMoClassCounterType("BatteryBackup", pmCounterArray2), new PmMoClassCounterType("EnergyMeter", pmCounterArray3), new PmMoClassCounterType("Climate", pmCounterArray4), new PmMoClassCounterType("PowerSupply", pmCounterArray5), new PmMoClassCounterType("PowerDistribution", pmCounterArray6), new PmMoClassCounterType("ConsumedEnergy", pmCounterArray7), new PmMoClassCounterType("BatteryUnit", pmCounterArray8)};
        boolean bl = pmCounterRegistration.registerCounters(pmPredefinedScannerType, pmMoClassCounterTypeArray);
        if (bl) {
            logger.info(this.getClass(), "Successfully registered PM counters.");
        } else {
            logger.traceError(this.getClass(), "Unable to register PM counters.");
        }
        logger.traceReturn(this.getClass(), "start");
    }

    private void subscribeForTopologyNotifications(String string) {
        logger.traceEnter(this.getClass(), "subscribeForTopologyNotifications: " + string);
        this.theOmfContext.getGenericMaoContext("moType").getAvcRegistratorFactory().getTopologyRegistrator().registerForTopologyUpdate((TopologySubscriber)this, "moType");
        logger.traceReturn(this.getClass(), "subscribeForTopologyNotifications: " + string);
    }

    public void reportMoDeleted(String string, Coordinator coordinator) {
        logger.traceEnter(this.getClass(), "reportMoDeleted: " + string);
        logger.traceReturn(this.getClass(), "reportMoDeleted: " + string);
    }

    public void reportMoCreated(String string, Coordinator coordinator) {
        logger.traceEnter(this.getClass(), "reportMoCreated: " + string);
        logger.traceReturn(this.getClass(), "reportMoCreated: " + string);
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceError(this.getClass(), "Subscription for topology notifiations has failed!");
    }

    public OmfContext getOmfContextOnlyForTest() {
        return this.theOmfContext;
    }

    public Thread getTheUpdateRATandFDNthreadOnlyForTest() {
        return this.theUpdateRATandFDNthread;
    }
}

