/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;

public final class Air2XPreHandlerAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "13/109 26-CRH 109 0239-1";
    public static final String AIR_USER_LABEL = "*A_I_R#";
    public static final String[] AIR_RRU_PRODUCT_NAME = new String[]{"RRUS 0Y", "RRUS 0Z"};
    public static final String AIR_FLAG_NAME = "isAir";
    public static final int AIR_FLAG = 1;
    public static final int LOW_VERSION = 13030800;
    private static final int HIGH_VERSION = 15020900;
    public static final String FRO_ID = "froId";
    private static Air2XPreHandlerAue instance = new Air2XPreHandlerAue();
    private Coordinator context = null;

    public Air2XPreHandlerAue() {
        super(Air2XPreHandlerAue.class);
    }

    public static Air2XPreHandlerAue instance() {
        return instance;
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        this.context = tw.getCoordinator();
        MoIterator moIter = BoamHelper.findMOs((String)"Sector");
        while (moIter.hasMoreElements()) {
            SectorMo sector = (SectorMo)moIter.nextMo();
            this.prepareAirUpgrade(sector);
        }
        return true;
    }

    private void prepareAirUpgrade(SectorMo sector) throws NoSuchAttributeException, MoAccessException, Exception {
        this.traceEnter("prepareAirUpgrade()");
        String ul = (String)sector.getAttribute("userLabel", this.context);
        if (-1 != ul.indexOf(AIR_USER_LABEL)) {
            ManagedObject[] reserveMos;
            CMoData cMoData;
            String LDN;
            SectorAntennaMo sectorAntennaMo = null;
            boolean isAir = false;
            ManagedObject[] mos = (ManagedObject[])sector.getAttribute("sectorAntennasRef", this.context);
            MoIterator it = mos[0].getChildren();
            while (it.hasMoreElements()) {
                ManagedObject mo = it.nextMo();
                if (0 != mo.getType().compareTo("AuxPlugInUnit")) continue;
                if ((Integer)mo.getAttribute("auType", this.context) == 26) {
                    return;
                }
                String productName = (String)mo.getAttribute("productName", this.context);
                for (int j = 0; j < AIR_RRU_PRODUCT_NAME.length; ++j) {
                    if (-1 == productName.indexOf(AIR_RRU_PRODUCT_NAME[j])) continue;
                    isAir = true;
                    break;
                }
                if (!isAir) continue;
                break;
            }
            if (isAir) {
                for (int i = 0; i < mos.length; ++i) {
                    sectorAntennaMo = (SectorAntennaMo)mos[i];
                    MoIterator iter = sectorAntennaMo.getChildren();
                    while (iter.hasMoreElements()) {
                        ManagedObject mo = iter.nextMo();
                        if (0 != mo.getType().compareTo("AuxPlugInUnit")) continue;
                        LDN = mo.getLocalDistinguishedName();
                        this.trace("Add attribute for aux with ldn" + LDN);
                        cMoData = new CMoData(LDN, mo.getType(), true, this.context);
                        cMoData.registerPersistentAttr(new IntegerAttribute(AIR_FLAG_NAME, false, 1));
                        cMoData.handleTransaction(this.context, CMoData.WRITE_ACCESS);
                    }
                }
            }
            if (0 != (reserveMos = (ManagedObject[])sector.getAttribute("reservedBy", this.context)).length) {
                MoIterator retIt = reserveMos[0].getChildren();
                while (retIt.hasMoreElements()) {
                    ManagedObject mo = retIt.nextMo();
                    if (0 != mo.getType().compareTo("AuxPlugInUnit")) continue;
                    LDN = mo.getLocalDistinguishedName();
                    this.trace("Add attribute for aux with ldn" + LDN);
                    cMoData = new CMoData(LDN, mo.getType(), true, this.context);
                    cMoData.registerPersistentAttr(new IntegerAttribute(AIR_FLAG_NAME, false, 1));
                    cMoData.handleTransaction(this.context, CMoData.WRITE_ACCESS);
                }
            }
        }
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public int getHighVersion() {
        return 15020900;
    }

    public int getLowVersion() {
        return 13030800;
    }

    protected void triggerConvert(List commands) throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"triggerConvert() for air");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }
}

