/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMo;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class RedundancyWRNae12936Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "11/109 26-CRH 109 042/1-5";
    public static final int LOW_VERSION = 6000000;
    private static final int HIGH_VERSION = 7090999;
    private static final String FTC_REDUND_REP = "Cello_Common_Main_FTC_Redundancy";
    private static final String MAIN_CBU = "Main_CBU";
    private static final String MAIN_GPB = "Main_GPB";
    static final int CBU_SLOT = 0;
    static final int GPB_SLOT = 1;
    static final int NEITHER_CBU_GPB = 2;
    static final int UNDETERMINED = 3;
    static final int TERMINATE = 0;
    static final int EXTEND_REPERTOIRE = 1;
    private static final RedundancyWRNae12936Aue INSTANCE = new RedundancyWRNae12936Aue();

    private RedundancyWRNae12936Aue() {
        super(RedundancyWRNae12936Aue.class);
    }

    public static RedundancyWRNae12936Aue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 6000000;
    }

    public int getHighVersion() {
        return 7090999;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    public boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            this.doExecute(tw.getCoordinator());
            return true;
        }
        catch (Exception e) {
            this.info("caught exception: " + e + ", stack trace follows:");
            Const.logStackTrace(this.getClass(), e);
            this.info("\nThis sub-AUE did not finish. Repertoire configuration may need manual correction.");
            return false;
        }
    }

    private void doExecute(Coordinator context) throws MoAccessException {
        this.traceEnter("doExecute()");
        if (this.isBasicCv(context)) {
            this.trace("system is 'Basic CV', no action");
        } else {
            ReliableProgramUniterMo reliableProgramUniterMo = this.findReliableProgramUniter();
            if (reliableProgramUniterMo == null) {
                this.trace("Could not find ReliableProgramUniter MO");
            } else {
                this.trace("found ReliableProgramUniter MO: " + reliableProgramUniterMo);
                SlotHandler slotHandler = new SlotHandler(reliableProgramUniterMo, context);
                switch (slotHandler.getImpliedAction()) {
                    case 0: {
                        this.trace("reason: " + slotHandler.getReason());
                        break;
                    }
                    case 1: {
                        String swAllocationName = this.getSwAllocationName(slotHandler.getSlotType());
                        if (this.coupleRepertoire(swAllocationName, FTC_REDUND_REP, context)) {
                            this.trace("successfully coupled Cello_Common_Main_FTC_Redundancy to " + swAllocationName);
                            break;
                        }
                        this.traceError("failed to couple Cello_Common_Main_FTC_Redundancy to " + swAllocationName);
                        throw new SoftwareErrorException();
                    }
                }
            }
        }
    }

    private boolean isBasicCv(Coordinator context) throws MoAccessException {
        this.traceEnter("isBasicCv()");
        SynchronizationMo syncMo = (SynchronizationMo)this.getMo("Synchronization");
        ManagedObject[] moList = syncMo.getSyncReference(context);
        for (int i = 0; i < moList.length; ++i) {
            if (moList[i] == null) continue;
            return false;
        }
        return true;
    }

    private ManagedObject getMo(String name) throws MoAccessException {
        this.traceEnter("getMo()");
        MoIterator moList = BoamHelper.findMOs((String)name);
        if (moList.hasMoreElements()) {
            return (ManagedObject)moList.nextElement();
        }
        this.traceError("could not find MO: " + name);
        throw new SoftwareErrorException();
    }

    private ReliableProgramUniterMo findReliableProgramUniter() {
        this.traceEnter("findReliableProgramUniter()");
        MoIterator it = FindMo.findMOs("ReliableProgramUniter");
        if (it.hasMoreElements()) {
            return (ReliableProgramUniterMo)it.nextMo();
        }
        return null;
    }

    private boolean coupleRepertoire(String swAllocationName, String repertoire, Coordinator context) throws MoAccessException {
        this.traceEnter("coupleRepertoire(" + swAllocationName + ", " + repertoire + ", context)");
        MoIterator it = FindMo.findMOs("SwAllocation");
        while (it.hasMoreElements()) {
            ManagedObject mo = it.nextMo();
            this.trace("considering SwAllocationMo: " + mo);
            if (!mo.getNamingAttributeValue().equalsIgnoreCase(swAllocationName)) continue;
            SwAllocationMo swAllocationMo = (SwAllocationMo)mo;
            if (!this.hasRepertoire(swAllocationMo, repertoire, context)) {
                this.trace("coupleRepertoire: will setRepertoire()");
                this.setRepertoire(swAllocationMo, this.getRepertoireMo(repertoire, context), context);
            }
            this.trace("coupleRepertoire: returns true");
            return true;
        }
        this.trace("coupleRepertoire: returns false");
        return false;
    }

    private String getSwAllocationName(int slotType) throws MoAccessException {
        this.traceEnter("getSwAllocationName(" + slotType + ")");
        switch (slotType) {
            case 0: {
                this.trace("return Main_CBU");
                return MAIN_CBU;
            }
            case 1: {
                this.trace("return Main_GPB");
                return MAIN_GPB;
            }
        }
        this.traceError("cannot decode " + slotType);
        throw new SoftwareErrorException();
    }

    private boolean hasRepertoire(SwAllocationMo swAllocationMo, String repertoire, Coordinator context) throws MoAccessException {
        this.traceEnter("hasRepertoire(" + swAllocationMo + ", " + repertoire + ", context)");
        ManagedObject[] repertoires = swAllocationMo.getRepertoireList(context);
        for (int i = 0; i < repertoires.length; ++i) {
            if (!repertoire.equals(((RepertoireMo)repertoires[i]).getName(context))) continue;
            this.trace("hasRepertoire: returns true");
            return true;
        }
        this.trace("hasRepertoire: returns false");
        return false;
    }

    private void setRepertoire(SwAllocationMo swAllocationMo, RepertoireMo repertoireMo, Coordinator context) throws MoAccessException {
        this.traceEnter("setRepertoire(" + swAllocationMo + ", " + repertoireMo + ", context)");
        swAllocationMo.actionAddRepertoire((ManagedObject)repertoireMo, context);
    }

    private synchronized RepertoireMo getRepertoireMo(String repertoireName, Coordinator context) throws MoAccessException {
        this.traceEnter("getRepertoireMo(" + repertoireName + ", context)");
        MoIterator it = FindMo.findMOs("Repertoire");
        if (!it.hasMoreElements()) {
            this.trace("Found no RepertoireMo instances at all");
            throw new SoftwareErrorException();
        }
        while (it.hasMoreElements()) {
            RepertoireMo repertoireMo = (RepertoireMo)it.nextMo();
            if (!repertoireName.equals(repertoireMo.getName(context))) continue;
            return repertoireMo;
        }
        this.trace("No RepertoireMo found for: " + repertoireName);
        throw new SoftwareErrorException();
    }

    public class SlotHandler {
        private final int slotType;
        private final int impliedAction;
        private final String reason;

        /*
         * Enabled aggressive block sorting
         */
        public SlotHandler(ReliableProgramUniterMo reliableProgramUniterMo, Coordinator context) throws MoAccessException {
            RedundancyWRNae12936Aue.this.traceEnter("new SlotHandler(" + reliableProgramUniterMo + ")");
            SlotMo admActiveSlot = (SlotMo)reliableProgramUniterMo.getAdmActiveSlot(context);
            SlotMo admPassiveSlot = (SlotMo)reliableProgramUniterMo.getAdmPassiveSlot(context);
            if (admActiveSlot == null || admPassiveSlot == null) {
                this.slotType = 3;
                this.reason = "active slot and passive slot are both null";
                this.impliedAction = 0;
            } else if (admActiveSlot == admPassiveSlot) {
                this.slotType = 3;
                this.reason = "active slot and passive slot refer to same Slot instance";
                this.impliedAction = 0;
            } else if (this.isCBUSlot((ManagedObject)admActiveSlot)) {
                if (!this.isCBUSlot((ManagedObject)admPassiveSlot)) {
                    RedundancyWRNae12936Aue.this.traceError("active slot is CBU and passive slot is not");
                    throw new SoftwareErrorException();
                }
                this.slotType = 0;
                this.reason = "";
                this.impliedAction = 1;
            } else if (this.isGPBSlot((ManagedObject)admActiveSlot)) {
                if (!this.isGPBSlot((ManagedObject)admPassiveSlot)) {
                    RedundancyWRNae12936Aue.this.traceError("active slot is GPB and passive slot is not");
                    throw new SoftwareErrorException();
                }
                this.slotType = 1;
                this.reason = "";
                this.impliedAction = 1;
            } else {
                if (this.isCBUSlot((ManagedObject)admPassiveSlot)) {
                    RedundancyWRNae12936Aue.this.traceError("passive slot is CBU and active slot is not");
                    throw new SoftwareErrorException();
                }
                if (this.isGPBSlot((ManagedObject)admPassiveSlot)) {
                    RedundancyWRNae12936Aue.this.traceError("passive slot is GPB and active slot is not");
                    throw new SoftwareErrorException();
                }
                this.slotType = 2;
                this.reason = "both slots are neither CBU nor GPB";
                this.impliedAction = 0;
            }
            RedundancyWRNae12936Aue.this.trace("SlotHandler created; slotType=" + this.slotType + ", impliedAction=" + this.impliedAction + ", reason=" + this.reason);
        }

        private int getSlotType() {
            RedundancyWRNae12936Aue.this.traceEnter("getSlotType(), will return: " + this.slotType);
            return this.slotType;
        }

        private int getImpliedAction() {
            RedundancyWRNae12936Aue.this.traceEnter("getImpliedAction(), will return: " + this.impliedAction);
            return this.impliedAction;
        }

        private String getReason() {
            RedundancyWRNae12936Aue.this.traceEnter("getReason(), will return: " + this.reason);
            return this.reason;
        }

        public boolean isCBUSlot(ManagedObject slot) {
            RedundancyWRNae12936Aue.this.traceEnter("isCBUSlot(" + slot + ")");
            MoIterator moIter = BoamHelper.findMOs((String)"Cbu", (ManagedObject)slot, (int)2);
            while (moIter.hasMoreElements()) {
                ManagedObject mo = moIter.nextMo();
                if (!mo.getParent().getType().equals("PlugInUnit")) continue;
                RedundancyWRNae12936Aue.this.trace("isCBUSlot: MO " + mo + " has parent " + mo.getParent() + " which is a " + "PlugInUnit" + ", return true");
                return true;
            }
            RedundancyWRNae12936Aue.this.trace("isCBUSlot: return false");
            return false;
        }

        public boolean isGPBSlot(ManagedObject slot) {
            RedundancyWRNae12936Aue.this.traceEnter("isGPBSlot(" + slot + ")");
            if (this.isCBUSlot(slot)) {
                RedundancyWRNae12936Aue.this.trace("isGPBSlot: return false because the slot is a CBU slot");
                return false;
            }
            MoIterator moIter = BoamHelper.findMOs((String)"PlugInUnit", (ManagedObject)slot, (int)1);
            boolean notEmpty = moIter.hasMoreElements();
            RedundancyWRNae12936Aue.this.trace("isGPBSlot: return " + notEmpty);
            return notEmpty;
        }
    }
}

